/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import com.sun.mail.util.MailConnectException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.mail.MailAuthenticationException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u0000 \u000f2\u00060\u0001j\u0002`\u0002:\u0001\u000fB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/notification/NotificationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "code", "", "message", "isSevere", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;Z)V", "getCode", "()Ljava/lang/String;", "()Z", "Companion", "jetbrains.jetpass.notification"})
public final class NotificationException
extends RuntimeException {
    @NotNull
    private final String code;
    private final boolean isSevere;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getCode() {
        return this.code;
    }

    public final boolean isSevere() {
        return this.isSevere;
    }

    public NotificationException(@NotNull String code, @NotNull String message, boolean isSevere) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        super(message);
        this.code = code;
        this.isSevere = isSevere;
    }

    public NotificationException(@NotNull String code, @NotNull String message, @NotNull Throwable cause, boolean isSevere) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(message, cause);
        this.code = code;
        this.isSevere = isSevere;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bJ\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u000b\u00a8\u0006\u0015"}, d2={"Ljetbrains/jetpass/notification/NotificationException$Companion;", "", "()V", "jabberDisabled", "Ljetbrains/jetpass/notification/NotificationException;", "jabberSendFailed", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "notificationNumberEmails", "notificationRenderFailed", "", "smtpAuthFailed", "Lorg/springframework/mail/MailAuthenticationException;", "smtpCantConnect", "Lcom/sun/mail/util/MailConnectException;", "smtpDisabled", "subject", "", "smtpSendFailed", "message", "jetbrains.jetpass.notification"})
    public static final class Companion {
        @NotNull
        public final NotificationException smtpDisabled(@NotNull String subject) {
            Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
            return new NotificationException("notification_smtp_disabled", "Notification \"" + subject + "\" was not sent, because email notifications are disabled", false);
        }

        @NotNull
        public final NotificationException smtpSendFailed(@Nullable String message, @NotNull Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = message;
            if (string == null) {
                string = "Cannot send email";
            }
            return new NotificationException("notification_smtp_send_failed", string, cause, true);
        }

        @NotNull
        public final NotificationException smtpAuthFailed(@NotNull MailAuthenticationException cause) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)cause), (String)"cause");
            return new NotificationException("notification_smtp_auth_failed", "SMTP server does not authorize Hub to send email", cause, true);
        }

        @NotNull
        public final NotificationException smtpCantConnect(@NotNull MailConnectException cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = cause.getMessage();
            if (string == null) {
                string = "Cannot connect to SMTP server";
            }
            return new NotificationException("notification_smtp_connection_failed", string, (Throwable)cause, true);
        }

        @NotNull
        public final NotificationException jabberDisabled() {
            return new NotificationException("notification_jabber_disabled", "Jabber notifications are disabled", false);
        }

        @NotNull
        public final NotificationException jabberSendFailed(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = cause.getMessage();
            if (string == null) {
                string = "Cannot send jabber";
            }
            return new NotificationException("notification_jabber_send_failed", string, cause, true);
        }

        @NotNull
        public final NotificationException notificationRenderFailed(@NotNull Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new NotificationException("notification_template_render_failed", "Cannot render email to send", cause, true);
        }

        @NotNull
        public final NotificationException notificationNumberEmails() {
            return new NotificationException("notification_number_email_constraint_today", "Invite cannot sent, because for free licence allowed not more 10 emails a day", false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

