/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.jetpass.notification.EmailNotificationTemplate;
import jetbrains.jetpass.notification.EmailNotificator;
import jetbrains.jetpass.notification.FMIcon;
import jetbrains.jetpass.notification.FMService;
import jetbrains.jetpass.notification.FMUser;
import jetbrains.jetpass.notification.FreemarkerRenderer;
import jetbrains.jetpass.notification.JabberNotificator;
import jetbrains.jetpass.notification.NotificationException;
import jetbrains.jetpass.notification.SVGImageConverter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020\u001eJ\u001e\u0010!\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001eJ(\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u001eJ(\u00102\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u00010\u001eJD\u00102\u001a\u00020(2\b\u00106\u001a\u0004\u0018\u00010\u001e2\u0006\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\n2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00010:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J,\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u001e2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00010:H\u0016J\u0016\u0010?\u001a\u00020(2\u0006\u00107\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&J\u000e\u0010@\u001a\u00020(2\u0006\u0010=\u001a\u00020\u001eJ\u001e\u0010A\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001eJ\u001e\u0010B\u001a\u00020(2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Ljetbrains/jetpass/notification/NotificationService;", "", "()V", "emailNotificator", "Ljetbrains/jetpass/notification/EmailNotificator;", "getEmailNotificator", "()Ljetbrains/jetpass/notification/EmailNotificator;", "setEmailNotificator", "(Ljetbrains/jetpass/notification/EmailNotificator;)V", "emailSettingsTest", "Ljetbrains/jetpass/notification/EmailNotificationTemplate;", "emailVerification", "freemarkerRenderer", "Ljetbrains/jetpass/notification/FreemarkerRenderer;", "getFreemarkerRenderer", "()Ljetbrains/jetpass/notification/FreemarkerRenderer;", "setFreemarkerRenderer", "(Ljetbrains/jetpass/notification/FreemarkerRenderer;)V", "imageConverter", "Ljetbrains/jetpass/notification/SVGImageConverter;", "getImageConverter", "()Ljetbrains/jetpass/notification/SVGImageConverter;", "invitation", "jabberNotificator", "Ljetbrains/jetpass/notification/JabberNotificator;", "getJabberNotificator", "()Ljetbrains/jetpass/notification/JabberNotificator;", "setJabberNotificator", "(Ljetbrains/jetpass/notification/JabberNotificator;)V", "jabberSettingsTestTemplateName", "", "jabberVerificationTemplateName", "passwordRestore", "registration", "inlineServiceIcon", "", "Ljetbrains/jetpass/notification/FMIcon;", "service", "Ljetbrains/jetpass/notification/FMService;", "invite", "", "inviter", "user", "Ljetbrains/jetpass/notification/FMUser;", "inviteUrl", "verifyContactURL", "restorePassword", "expiration", "Lorg/joda/time/DateTime;", "restoreUrl", "sendEmail", "subject", "htmlText", "unsubscribeURL", "userName", "email", "template", "root", "", "files", "sendJabber", "jabber", "templateName", "testEmail", "testJabber", "verifyEmail", "verifyJabber", "jetbrains.jetpass.notification"})
public class NotificationService {
    @NotNull
    public EmailNotificator emailNotificator;
    @NotNull
    public JabberNotificator jabberNotificator;
    @NotNull
    public FreemarkerRenderer freemarkerRenderer;
    @NotNull
    private final SVGImageConverter imageConverter = new SVGImageConverter();
    private final EmailNotificationTemplate invitation = new EmailNotificationTemplate("invitation-subj.ftl", "invitation-body.ftl");
    private final EmailNotificationTemplate registration = new EmailNotificationTemplate("registration-subj.ftl", "registration-body.ftl");
    private final EmailNotificationTemplate emailVerification = new EmailNotificationTemplate("email-verification-subj.ftl", "email-verification-body.ftl");
    private final String jabberVerificationTemplateName = "jabber-verification-body.ftl";
    private final EmailNotificationTemplate passwordRestore = new EmailNotificationTemplate("password-restore-subj.ftl", "password-restore-body.ftl");
    private final EmailNotificationTemplate emailSettingsTest = new EmailNotificationTemplate("email-test-subj.ftl", "email-test-body.ftl");
    private final String jabberSettingsTestTemplateName = "jabber-test-body.ftl";

    @NotNull
    public final EmailNotificator getEmailNotificator() {
        EmailNotificator emailNotificator = this.emailNotificator;
        if (emailNotificator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emailNotificator");
        }
        return emailNotificator;
    }

    public final void setEmailNotificator(@NotNull EmailNotificator emailNotificator) {
        Intrinsics.checkParameterIsNotNull((Object)emailNotificator, (String)"<set-?>");
        this.emailNotificator = emailNotificator;
    }

    @NotNull
    public final JabberNotificator getJabberNotificator() {
        JabberNotificator jabberNotificator = this.jabberNotificator;
        if (jabberNotificator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jabberNotificator");
        }
        return jabberNotificator;
    }

    public final void setJabberNotificator(@NotNull JabberNotificator jabberNotificator) {
        Intrinsics.checkParameterIsNotNull((Object)jabberNotificator, (String)"<set-?>");
        this.jabberNotificator = jabberNotificator;
    }

    @NotNull
    public FreemarkerRenderer getFreemarkerRenderer() {
        FreemarkerRenderer freemarkerRenderer = this.freemarkerRenderer;
        if (freemarkerRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"freemarkerRenderer");
        }
        return freemarkerRenderer;
    }

    public void setFreemarkerRenderer(@NotNull FreemarkerRenderer freemarkerRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)freemarkerRenderer, (String)"<set-?>");
        this.freemarkerRenderer = freemarkerRenderer;
    }

    @NotNull
    public final SVGImageConverter getImageConverter() {
        return this.imageConverter;
    }

    public final void invite(@NotNull String inviter, @NotNull FMUser user, @NotNull FMService service2, @NotNull String inviteUrl) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)inviter, (String)"inviter");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)inviteUrl, (String)"inviteUrl");
        HashMap root = new HashMap();
        Map map = root;
        String string = "inviter";
        Object object = inviter;
        map.put(string, object);
        map = root;
        string = "user";
        object = user;
        map.put(string, object);
        map = root;
        string = "service";
        object = service2;
        map.put(string, object);
        map = root;
        string = "inviteUrl";
        object = inviteUrl;
        map.put(string, object);
        this.sendEmail(user.getName(), user.getEmail(), this.invitation, root, this.inlineServiceIcon(service2));
    }

    public final void registration(@NotNull FMUser user, @NotNull FMService service2, @NotNull String verifyContactURL) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)verifyContactURL, (String)"verifyContactURL");
        HashMap root = new HashMap();
        Map map = root;
        String string = "user";
        Object object = user;
        map.put(string, object);
        map = root;
        string = "service";
        object = service2;
        map.put(string, object);
        map = root;
        string = "verifyContactURL";
        object = verifyContactURL;
        map.put(string, object);
        this.sendEmail(user.getName(), user.getEmail(), this.registration, root, this.inlineServiceIcon(service2));
    }

    public final void verifyEmail(@NotNull FMUser user, @NotNull FMService service2, @NotNull String verifyContactURL) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)verifyContactURL, (String)"verifyContactURL");
        HashMap root = new HashMap();
        Map map = root;
        String string = "user";
        Object object = user;
        map.put(string, object);
        map = root;
        string = "service";
        object = service2;
        map.put(string, object);
        map = root;
        string = "verifyContactURL";
        object = verifyContactURL;
        map.put(string, object);
        this.sendEmail(user.getName(), user.getEmail(), this.emailVerification, root, this.inlineServiceIcon(service2));
    }

    public final void verifyJabber(@NotNull String jabber, @NotNull FMService service2, @NotNull String verifyContactURL) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)verifyContactURL, (String)"verifyContactURL");
        HashMap root = new HashMap();
        Map map = root;
        String string = "service";
        Object object = service2;
        map.put(string, object);
        map = root;
        string = "verifyContactURL";
        object = verifyContactURL;
        map.put(string, object);
        this.sendJabber(jabber, this.jabberVerificationTemplateName, root);
    }

    public final void restorePassword(@NotNull FMUser user, @NotNull FMService service2, @Nullable DateTime expiration, @NotNull String restoreUrl) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)restoreUrl, (String)"restoreUrl");
        HashMap root = new HashMap();
        Map map = root;
        String string = "user";
        Object object = user;
        map.put(string, object);
        map = root;
        string = "service";
        object = service2;
        map.put(string, object);
        if (expiration != null) {
            map = root;
            string = "expiration";
            Date date = expiration.toDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"expiration.toDate()");
            object = date;
            map.put(string, object);
        }
        map = root;
        string = "restoreUrl";
        object = restoreUrl;
        map.put(string, object);
        this.sendEmail(user.getName(), user.getEmail(), this.passwordRestore, root, this.inlineServiceIcon(service2));
    }

    public final void testEmail(@NotNull String email, @NotNull FMService service2) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        HashMap root = new HashMap();
        Map map = root;
        String string = "service";
        FMService fMService = service2;
        map.put(string, fMService);
        this.sendEmail(null, email, this.emailSettingsTest, root, this.inlineServiceIcon(service2));
    }

    public final void sendEmail(@NotNull FMUser user, @NotNull String subject, @NotNull String htmlText, @Nullable String unsubscribeURL) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)htmlText, (String)"htmlText");
        EmailNotificator emailNotificator = this.emailNotificator;
        if (emailNotificator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emailNotificator");
        }
        emailNotificator.send(user.getName(), user.getEmail(), subject, htmlText, CollectionsKt.emptyList(), unsubscribeURL);
    }

    public final void testJabber(@NotNull String jabber) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        HashMap root = new HashMap();
        this.sendJabber(jabber, this.jabberSettingsTestTemplateName, root);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FMIcon> inlineServiceIcon(@NotNull FMService service2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object)service2.getIcon()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FMIcon fMIcon = (FMIcon)item$iv$iv;
            Collection collection = destination$iv$iv;
            FMIcon fMIcon2 = this.imageConverter.convert((FMIcon)it, 80.0f);
            collection.add(fMIcon2);
        }
        return (List)destination$iv$iv;
    }

    public void sendEmail(@Nullable String userName, @NotNull String email, @NotNull EmailNotificationTemplate template, @NotNull Map<String, ? extends Object> root, @NotNull List<? extends FMIcon> files) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        Intrinsics.checkParameterIsNotNull(root, (String)"root");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        String subject = this.getFreemarkerRenderer().render(template.getSubjectTemplateName(), root);
        String body = this.getFreemarkerRenderer().render(template.getBodyTemplateName(), root);
        EmailNotificator emailNotificator = this.emailNotificator;
        if (emailNotificator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emailNotificator");
        }
        emailNotificator.send(userName, email, subject, body, files, null);
    }

    public void sendJabber(@NotNull String jabber, @NotNull String templateName, @NotNull Map<String, ? extends Object> root) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        Intrinsics.checkParameterIsNotNull(root, (String)"root");
        String body = this.getFreemarkerRenderer().render(templateName, root);
        JabberNotificator jabberNotificator = this.jabberNotificator;
        if (jabberNotificator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jabberNotificator");
        }
        jabberNotificator.send(jabber, body);
    }
}

