/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.workflow.annotations.Access;
import jetbrains.youtrack.api.workflow.annotations.ApiClass;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.api.workflow.annotations.ApiMethod;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsType;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsTypes;
import jetbrains.youtrack.api.workflow.annotations.ApiProperty;
import jetbrains.youtrack.api.workflow.annotations.ApiPropertyAccess;
import jetbrains.youtrack.api.workflow.annotations.ApiScope;
import jetbrains.youtrack.api.workflow.annotations.ApiSince;
import jetbrains.youtrack.core.dates.DateMath;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdMentionsProvider;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdBaseWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem$beforeFlush$1;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdToManyLink;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdSearchingNode;
import kotlinx.dnq.simple.XdMutableConstrainedProperty;
import kotlinx.dnq.simple.XdNullableProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.store.container.StoreContainer;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

@ApiClass
@ApiDoc(value="Represents a work item that has been added to an issue.")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020@H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\b\b\u0002\u0010F\u001a\u00020.J\b\u0010G\u001a\u00020@H\u0007R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\fR1\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00158F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001c\u0010\u000e\u0012\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR5\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0006\u001a\u0004\u0018\u00010\u001d8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b$\u0010%\u0012\u0004\b\u001f\u0010\u0012\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R!\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*R!\u0010-\u001a\b\u0012\u0004\u0012\u00020.0'8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010,\u001a\u0004\b/\u0010*R5\u00101\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b7\u00108\u0012\u0004\b2\u0010\u0012\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u0010:\u001a\u0002092\u0006\u0010\u000f\u001a\u0002098F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006I"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "Ljetbrains/youtrack/timetracking/persistence/XdBaseWorkItem;", "Ljetbrains/youtrack/persistent/XdMentionsProvider;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "", "_date", "get_date", "()J", "set_date", "(J)V", "_date$delegate", "Lkotlinx/dnq/simple/XdProperty;", "value", "date", "date$annotations", "()V", "getDate", "setDate", "", "duration", "duration$annotations", "getDuration", "()I", "setDuration", "(I)V", "duration$delegate", "", "jiraId", "jiraId$annotations", "getJiraId", "()Ljava/lang/String;", "setJiraId", "(Ljava/lang/String;)V", "jiraId$delegate", "Lkotlinx/dnq/simple/XdMutableConstrainedProperty;", "mentionedIssues", "Lkotlinx/dnq/query/XdMutableQuery;", "Ljetbrains/youtrack/persistent/XdIssue;", "getMentionedIssues", "()Lkotlinx/dnq/query/XdMutableQuery;", "mentionedIssues$delegate", "Lkotlinx/dnq/link/XdToManyLink;", "mentionedUsers", "Ljetbrains/youtrack/persistent/XdUser;", "getMentionedUsers", "mentionedUsers$delegate", "oldDate", "oldDate$annotations", "getOldDate", "()Ljava/lang/Long;", "setOldDate", "(Ljava/lang/Long;)V", "oldDate$delegate", "Lkotlinx/dnq/simple/XdNullableProperty;", "Lorg/joda/time/Period;", "timePeriod", "getTimePeriod", "()Lorg/joda/time/Period;", "setTimePeriod", "(Lorg/joda/time/Period;)V", "beforeFlush", "", "constructor", "isAccessible", "", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "remove", "Companion", "youtrack-time-tracking"})
public final class XdIssueWorkItem
extends XdBaseWorkItem
implements XdMentionsProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdProperty _date$delegate;
    @Nullable
    private final XdNullableProperty oldDate$delegate;
    @NotNull
    private final XdProperty duration$delegate;
    @Nullable
    private final XdMutableConstrainedProperty jiraId$delegate;
    @NotNull
    private final XdToManyLink mentionedIssues$delegate;
    @NotNull
    private final XdToManyLink mentionedUsers$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "_date", "get_date()J")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "oldDate", "getOldDate()Ljava/lang/Long;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "duration", "getDuration()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "jiraId", "getJiraId()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "mentionedIssues", "getMentionedIssues()Lkotlinx/dnq/query/XdMutableQuery;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "mentionedUsers", "getMentionedUsers()Lkotlinx/dnq/query/XdMutableQuery;"))};
        Companion = new Companion(null);
    }

    @Override
    public void constructor() {
        super.constructor();
        this.setDate(XdWorkItemKt.toMidnightInUTC$default(this.getCreated(), null, 1, null));
    }

    public final long get_date() {
        return ((Number)((Object)this._date$delegate.getValue((XdEntity)this, $$delegatedProperties[0]))).longValue();
    }

    public final void set_date(long l) {
        this._date$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (Comparable)Long.valueOf(l));
    }

    @Deprecated(message="scheduled for removal. use date instead.")
    public static /* synthetic */ void oldDate$annotations() {
    }

    @Nullable
    public final Long getOldDate() {
        return (Long)this.oldDate$delegate.getValue((XdEntity)this, $$delegatedProperties[1]);
    }

    public final void setOldDate(@Nullable Long l) {
        this.oldDate$delegate.setValue((XdEntity)this, $$delegatedProperties[1], (Comparable)l);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.RW, scope=ApiScope.WORKFLOW), @ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The duration of the work item in minutes.\nWritable since 2018.1.40800")
    public static /* synthetic */ void duration$annotations() {
    }

    public final int getDuration() {
        return ((Number)((Object)this.duration$delegate.getValue((XdEntity)this, $$delegatedProperties[2]))).intValue();
    }

    public final void setDuration(int n) {
        this.duration$delegate.setValue((XdEntity)this, $$delegatedProperties[2], (Comparable)Integer.valueOf(n));
    }

    @ApiProperty(name="jiraId", dbName="jiraId", access={@ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    public static /* synthetic */ void jiraId$annotations() {
    }

    @Nullable
    public final String getJiraId() {
        return (String)this.jiraId$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setJiraId(@Nullable String string) {
        this.jiraId$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW), @ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The date and time that is assigned to the work item. Stored as a Unix timestamp in UTC. The time part is set to midnight for the current date.")
    @ApiMpsType(value=ApiMpsTypes.INSTANT)
    public static /* synthetic */ void date$annotations() {
    }

    public final long getDate() {
        return this.get_date();
    }

    public final void setDate(long value2) {
        this.set_date(XdWorkItemKt.toMidnightInUTC$default(value2, null, 1, null));
    }

    @NotNull
    public final Period getTimePeriod() {
        return BeansKt.toTimePeriod(this.getDuration());
    }

    public final void setTimePeriod(@NotNull Period value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.setDuration(jetbrains.charisma.timeTracking.BeansKt.getTimeTrackingProvider().getMinutes(value2));
    }

    @NotNull
    public XdMutableQuery<XdIssue> getMentionedIssues() {
        return this.mentionedIssues$delegate.getValue((XdEntity)this, $$delegatedProperties[4]);
    }

    @NotNull
    public XdMutableQuery<XdUser> getMentionedUsers() {
        return this.mentionedUsers$delegate.getValue((XdEntity)this, $$delegatedProperties[5]);
    }

    public void beforeFlush() {
        super.beforeFlush();
        if ((this.isNew() || ReflectionUtilKt.hasChanges((XdEntity)this, (KProperty1)((KProperty1)XdIssueWorkItem$beforeFlush$1.INSTANCE))) && this.getDuration() <= 0) {
            if (this.isRemoved()) {
                String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.Work_duration_can_t_be_empty", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026duration_can_t_be_empty\")");
                Void void_ = PersitenceExtensionsKt.userFriendlyFail$default((String)string, null, (int)2, null);
                throw null;
            }
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.Work_duration_can_t_be_empty", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026duration_can_t_be_empty\")");
            Void void_ = PersitenceExtensionsKt.userFriendlyFail((String)string, (XdEntity)this);
            throw null;
        }
        if (!DateMath.isDateStartInUTC((Long)this.getDate())) {
            if (this.isRemoved()) {
                Void void_ = PersitenceExtensionsKt.userFriendlyFail$default((String)(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.incorrect_date", new Object[0]) + this.getDate()), null, (int)2, null);
                throw null;
            }
            Void void_ = PersitenceExtensionsKt.userFriendlyFail((String)(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.incorrect_date", new Object[0]) + this.getDate()), (XdEntity)this);
            throw null;
        }
    }

    public final boolean isAccessible(@NotNull Operation operation, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Operation fixedOperation = operation == Operation.UPDATE && Intrinsics.areEqual((Object)user, (Object)this.getCreator()) ^ true && Intrinsics.areEqual((Object)user, (Object)this.getAuthor()) ^ true ? Operation.UPDATE_NOT_OWN : operation;
        return user.hasPermission(Companion.getEntityType(), fixedOperation, this.getIssue().getProject());
    }

    public static /* synthetic */ boolean isAccessible$default(XdIssueWorkItem xdIssueWorkItem, Operation operation, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return xdIssueWorkItem.isAccessible(operation, xdUser);
    }

    @Deprecated(message="to be moved to public api location")
    @ApiMethod(name="delete", scopes={ApiScope.WORKFLOW})
    @ApiMpsIgnore
    @ApiDoc(value="Permanently deletes the work item.")
    @ApiSince(value="2018.2.42312")
    public final void remove() {
        this.delete();
    }

    public XdIssueWorkItem(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
        this._date$delegate = (XdProperty)PropertyDelegatesKt.xdRequiredLongProp$default((String)"date", (boolean)false, null, (int)6, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.oldDate$delegate = (XdNullableProperty)PropertyDelegatesKt.xdNullableLongProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.duration$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.jiraId$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        OnDeletePolicy onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        OnDeletePolicy onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        this.mentionedIssues$delegate = (XdToManyLink)LinkDelegatesKt.xdLink0_N$default((XdEntityType)((XdEntityType)XdIssue.Companion), null, (OnDeletePolicy)onDeletePolicy, (OnDeletePolicy)onDeletePolicy2, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[4]);
        onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        this.mentionedUsers$delegate = (XdToManyLink)LinkDelegatesKt.xdLink0_N$default((XdEntityType)((XdEntityType)XdUser.Companion), null, (OnDeletePolicy)onDeletePolicy, (OnDeletePolicy)onDeletePolicy2, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[5]);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0007J9\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "()V", "find", "Lkotlinx/dnq/query/XdQuery;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "start", "", "end", "isAccessible", "", "project", "Ljetbrains/youtrack/persistent/XdProject;", "operation", "Ljetbrains/youtrack/core/security/Operation;", "new", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "author", "date", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "youtrack-time-tracking"})
    public static final class Companion
    extends XdNaturalEntityType<XdIssueWorkItem> {
        @NotNull
        public final XdIssueWorkItem new(@NotNull XdIssue issue2, @NotNull XdUser author2, long date2, @Nullable Function1<? super XdIssueWorkItem, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)author2, (String)"author");
            return (XdIssueWorkItem)Companion.new((Function1)new Function1<XdIssueWorkItem, Unit>(issue2, date2, author2, init){
                final /* synthetic */ XdIssue $issue;
                final /* synthetic */ long $date;
                final /* synthetic */ XdUser $author;
                final /* synthetic */ Function1 $init;

                public final void invoke(@NotNull XdIssueWorkItem $receiver) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        $receiver.setIssue(this.$issue);
                        $receiver.setDate(XdWorkItemKt.toMidnightInUTC$default(this.$date, null, 1, null));
                        $receiver.setAuthor(this.$author);
                        $receiver.setCreator((XdUser)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser())));
                        $receiver.setCreated(System.currentTimeMillis());
                        Function1 function1 = this.$init;
                        if (function1 == null) break block0;
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)$receiver));
                    }
                }
                {
                    this.$issue = xdIssue;
                    this.$date = l;
                    this.$author = xdUser;
                    this.$init = function1;
                    super(1);
                }
            });
        }

        @ApiMethod(scopes={ApiScope.PLUGIN})
        @NotNull
        public final XdIssueWorkItem new(@NotNull XdIssue issue2, @NotNull XdUser author2, long date2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)author2, (String)"author");
            return this.new(issue2, author2, date2, (Function1<? super XdIssueWorkItem, Unit>)((Function1)new.2.INSTANCE));
        }

        @NotNull
        public final XdQuery<XdIssueWorkItem> find(@NotNull XdUser user, long start, long end) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            return XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssueWorkItem, XdSearchingNode>(user, start, end){
                final /* synthetic */ XdUser $user;
                final /* synthetic */ long $start;
                final /* synthetic */ long $end;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdIssueWorkItem it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $receiver.eq((XdEntity)it.getAuthor(), (XdEntity)this.$user).and($receiver.between((Comparable)Long.valueOf(it.get_date()), TuplesKt.to((Object)this.$start, (Object)this.$end)));
                }
                {
                    this.$user = xdUser;
                    this.$start = l;
                    this.$end = l2;
                    super(2);
                }
            }));
        }

        public final boolean isAccessible(@NotNull XdUser user, @NotNull XdProject project2, @NotNull Operation operation) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
            return user.hasPermission(Companion.getEntityType(), operation, project2);
        }

        private Companion() {
            super("IssueWorkItem", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

