/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence.listeners;

import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.persistent.listeners.GlobalXdListener;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/timetracking/persistence/listeners/ConditionalFieldsListener;", "Ljetbrains/youtrack/persistent/listeners/GlobalXdListener;", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "()V", "updatedSyncBeforeConstraints", "", "old", "current", "youtrack-time-tracking"})
public class ConditionalFieldsListener
extends GlobalXdListener<XdProjectCustomField> {
    public void updatedSyncBeforeConstraints(@NotNull XdProjectCustomField old, @NotNull XdProjectCustomField current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        if (current.getCondition() != null) {
            XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(current.getProject());
            String messageId = null;
            if (Intrinsics.areEqual((Object)current, (Object)((Object)settings.getEstimate()))) {
                messageId = "ConditionalFieldsListener.cant_add_condition_to_estimation";
            } else if (Intrinsics.areEqual((Object)current, (Object)((Object)settings.getSpentTime()))) {
                messageId = "ConditionalFieldsListener.cant_add_condition_to_spent_time";
            }
            if (messageId != null) {
                if (settings.getEnabled()) {
                    String string = BeansKt.getLocalizer().localizedMsg(messageId, new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(messageId)");
                    throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(string, current.getEntity()));
                }
                settings.setEstimate(null);
                settings.setSpentTime(null);
            }
        }
    }
}

