/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.ApplicationCall;
import io.ktor.features.Compression;
import io.ktor.features.CompressionEncoderBuilder;
import io.ktor.features.CompressionKt;
import io.ktor.features.ConditionsHolderBuilder;
import io.ktor.features.DeflateEncoder;
import io.ktor.features.GzipEncoder;
import io.ktor.features.IdentityEncoder;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.OutgoingContent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u001a)\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001d\u0010\u0003\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\b\b\u001a%\u0010\t\u001a\u00020\u0001*\u00020\n2\u0019\b\u0002\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\b\u001a#\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a%\u0010\u0013\u001a\u00020\u0001*\u00020\n2\u0019\b\u0002\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\b\u001a%\u0010\u0014\u001a\u00020\u0001*\u00020\n2\u0019\b\u0002\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\b\u001a\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a#\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"condition", "", "Lio/ktor/features/ConditionsHolderBuilder;", "predicate", "Lkotlin/Function2;", "Lio/ktor/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "deflate", "Lio/ktor/features/Compression$Configuration;", "block", "Lkotlin/Function1;", "Lio/ktor/features/CompressionEncoderBuilder;", "excludeContentType", "mimeTypes", "", "Lio/ktor/http/ContentType;", "(Lio/ktor/features/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "gzip", "identity", "isCompressionSuppressed", "matchContentType", "minimumSize", "minSize", "", "ktor-server-core"})
public final class CompressionKt {
    private static final boolean isCompressionSuppressed(@NotNull ApplicationCall $receiver) {
        return $receiver.getAttributes().contains(Compression.Feature.getSuppressionAttribute());
    }

    public static final void gzip(@NotNull Compression.Configuration $receiver, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.encoder("gzip", GzipEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void gzip$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = gzip.1.INSTANCE;
        }
        CompressionKt.gzip(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void deflate(@NotNull Compression.Configuration $receiver, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.encoder("deflate", DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)((Function1)new Function1<CompressionEncoderBuilder, Unit>(block){
            final /* synthetic */ Function1 $block;

            public final void invoke(@NotNull CompressionEncoderBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setPriority(0.9);
                this.$block.invoke((Object)$receiver);
            }
            {
                this.$block = function1;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void deflate$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = deflate.1.INSTANCE;
        }
        CompressionKt.deflate(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void identity(@NotNull Compression.Configuration $receiver, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.encoder("identity", IdentityEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void identity$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = identity.1.INSTANCE;
        }
        CompressionKt.identity(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $receiver, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        $receiver.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $receiver, long minSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        CompressionKt.condition($receiver, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(minSize){
            final /* synthetic */ long $minSize;

            public final boolean invoke(@NotNull ApplicationCall $receiver, @NotNull OutgoingContent content) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                Long l = content.getContentLength();
                if (l != null) {
                    Long l2 = l;
                    long it = ((Number)l2).longValue();
                    boolean bl2 = false;
                    bl = it >= this.$minSize;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$minSize = l;
                super(2);
            }
        }));
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $receiver, ContentType ... mimeTypes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($receiver, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;

            public final boolean invoke(@NotNull ApplicationCall $receiver, @NotNull OutgoingContent content) {
                boolean bl;
                block2: {
                    ContentType[] $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                    ContentType contentType = content.getContentType();
                    if (contentType == null) {
                        return false;
                    }
                    ContentType contentType2 = contentType;
                    ContentType[] contentTypeArray = $receiver$iv = this.$mimeTypes;
                    int n = contentTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType it = element$iv = contentTypeArray[i];
                        boolean bl2 = false;
                        if (!contentType2.match(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$mimeTypes = contentTypeArray;
                super(2);
            }
        }));
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $receiver, ContentType ... mimeTypes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($receiver, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;

            public final boolean invoke(@NotNull ApplicationCall $receiver, @NotNull OutgoingContent content) {
                boolean bl;
                block5: {
                    ContentType[] $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                    ContentType contentType = content.getContentType();
                    if (contentType == null) {
                        String string = $receiver.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                        if (string != null) {
                            String string2;
                            String it = string2 = string;
                            boolean bl2 = false;
                            contentType = ContentType.Companion.parse(it);
                        } else {
                            contentType = null;
                        }
                    }
                    if (contentType == null) {
                        return true;
                    }
                    ContentType contentType2 = contentType;
                    ContentType[] contentTypeArray = $receiver$iv = this.$mimeTypes;
                    int n = contentTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType excludePattern = element$iv = contentTypeArray[i];
                        boolean bl3 = false;
                        if (!contentType2.match(excludePattern)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.$mimeTypes = contentTypeArray;
                super(2);
            }
        }));
    }

    public static final /* synthetic */ boolean access$isCompressionSuppressed(ApplicationCall $receiver) {
        return CompressionKt.isCompressionSuppressed($receiver);
    }
}

