/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.application.ApplicationCall;
import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.content.JarFileContent;
import io.ktor.http.content.LocalFileContent;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.StaticContentResolutionKt;
import io.ktor.http.content.URIFileContent;
import io.ktor.util.NioPathKt;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a@\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f\u00a8\u0006\u0011"}, d2={"findContainingJarFile", "Ljava/io/File;", "url", "", "appendPathPart", "part", "extension", "resolveResource", "Lio/ktor/http/content/OutgoingContent;", "Lio/ktor/application/ApplicationCall;", "path", "resourcePackage", "classLoader", "Ljava/lang/ClassLoader;", "mimeResolve", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "ktor-server-core"})
public final class StaticContentResolutionKt {
    @Nullable
    public static final OutgoingContent resolveResource(@NotNull ApplicationCall $receiver, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Intrinsics.checkParameterIsNotNull(mimeResolve, (String)"mimeResolve");
        String string = resourcePackage;
        if (string == null || (string = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)) == null) {
            string = "";
        }
        String packagePath = StaticContentResolutionKt.appendPathPart(string, path);
        Path path2 = Paths.get(packagePath, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(packagePath)");
        Path normalizedPath = NioPathKt.normalizeAndRelativize((Path)path2);
        String normalizedResource = StringsKt.replace$default((String)((Object)normalizedPath).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedResource);
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"classLoader.getResources(normalizedResource)");
        Enumeration<URL> enumeration2 = enumeration;
        Iterator iterator = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)).iterator();
        while (iterator.hasNext()) {
            URL url2;
            URL uRL = url2 = (URL)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
            if (uRL.getProtocol() == null) continue;
            int n = -1;
            switch (((String)((Object)enumeration2)).hashCode()) {
                case 3143036: {
                    if (!((String)((Object)enumeration2)).equals("file")) break;
                    n = 1;
                    break;
                }
                case 104987: {
                    if (!((String)((Object)enumeration2)).equals("jar")) break;
                    n = 2;
                    break;
                }
                case 105516: {
                    if (!((String)((Object)enumeration2)).equals("jrt")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String string2 = url2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
                    File file2 = new File(CodecsKt.decodeURLPart$default((String)string2, (int)0, (int)0, null, (int)7, null));
                    return file2.isFile() ? (OutgoingContent)new LocalFileContent(file2, (ContentType)mimeResolve.invoke((Object)FilesKt.getExtension((File)file2))) : null;
                }
                case 2: {
                    OutgoingContent outgoingContent;
                    if (StringsKt.endsWith$default((String)packagePath, (String)"/", (boolean)false, (int)2, null)) {
                        outgoingContent = null;
                    } else {
                        String string3 = url2.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.toString()");
                        File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                        String string4 = url2.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"url.path");
                        outgoingContent = (OutgoingContent)new JarFileContent(zipFile, normalizedResource, (ContentType)mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string4)));
                    }
                    return outgoingContent;
                }
                case 3: {
                    String string5 = url2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"url.path");
                    return (OutgoingContent)new URIFileContent(url2, (ContentType)mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string5)));
                }
            }
        }
        return null;
    }

    @Nullable
    public static /* synthetic */ OutgoingContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = resolveResource.1.INSTANCE;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, (Function1<? super String, ContentType>)function1);
    }

    @NotNull
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
        if (StringsKt.startsWith$default((String)url2, (String)"jar:file:", (boolean)false, (int)2, null)) {
            boolean bl;
            int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, (String)"!", (int)9, (boolean)false, (int)4, null);
            boolean bl2 = bl = jarPathSeparator != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Jar path requires !/ separator but it is: " + url2;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = url2;
            int n = 9;
            String string2 = string.substring(n, jarPathSeparator);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            String string4 = CodecsKt.decodeURLPart$default((String)string3, (int)0, (int)0, null, (int)7, null);
            return new File(string4);
        }
        throw (Throwable)new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    private static final String extension(@NotNull String $receiver) {
        String string;
        Integer n = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'/', (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            n = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'\\', (int)0, (boolean)false, (int)6, null);
            it = ((Number)n).intValue();
            boolean bl2 = false;
            n2 = it != -1 ? n : null;
        }
        int indexOfName = n2 != null ? n2 : 0;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$receiver, (char)'.', (int)indexOfName, (boolean)false, (int)4, null);
        if (indexOfDot >= 0) {
            String string2;
            String string3 = string2 = $receiver;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(indexOfDot);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }

    private static final String appendPathPart(@NotNull String $receiver, String part) {
        String string;
        CharSequence charSequence = $receiver;
        int n = charSequence.length() > 0 && $receiver.charAt($receiver.length() - 1) == '/' ? 1 : 0;
        charSequence = part;
        int n2 = n;
        boolean bl = charSequence.length() > 0;
        int count = n2 + (bl && part.charAt(0) == '/' ? 1 : 0);
        switch (count) {
            case 2: {
                string = $receiver + StringsKt.removePrefix((String)part, (CharSequence)"/");
                break;
            }
            case 1: {
                string = $receiver + part;
                break;
            }
            default: {
                CharSequence $receiver2 = charSequence = new StringBuilder($receiver.length() + part.length() + 1);
                boolean bl2 = false;
                ((StringBuilder)$receiver2).append($receiver);
                ((StringBuilder)$receiver2).append('/');
                ((StringBuilder)$receiver2).append(part);
                String string2 = ((StringBuilder)charSequence).toString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder(length + p\u2026append(part) }.toString()");
            }
        }
        return string;
    }
}

