/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.request;

import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RangesKt;
import io.ktor.http.RangesSpecifier;
import io.ktor.request.ApplicationRequest;
import io.ktor.util.KtorExperimentalAPI;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0007\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0012\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0006*\u00020\u0002\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0006\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010 \u001a\u00020!*\u00020\u0002\u001a\n\u0010\"\u001a\u00020!*\u00020\u0002\u001a\f\u0010#\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0002\u001a\f\u0010(\u001a\u0004\u0018\u00010)*\u00020\u0002\u001a\f\u0010*\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006+"}, d2={"httpMethod", "Lio/ktor/http/HttpMethod;", "Lio/ktor/request/ApplicationRequest;", "getHttpMethod", "(Lio/ktor/request/ApplicationRequest;)Lio/ktor/http/HttpMethod;", "httpVersion", "", "getHttpVersion", "(Lio/ktor/request/ApplicationRequest;)Ljava/lang/String;", "uri", "getUri", "accept", "acceptCharset", "acceptCharsetItems", "", "Lio/ktor/http/HeaderValue;", "acceptEncoding", "acceptEncodingItems", "acceptItems", "acceptLanguage", "acceptLanguageItems", "authorization", "cacheControl", "contentCharset", "Ljava/nio/charset/Charset;", "Lkotlinx/io/charsets/Charset;", "contentType", "Lio/ktor/http/ContentType;", "document", "header", "name", "host", "isChunked", "", "isMultipart", "location", "path", "port", "", "queryString", "ranges", "Lio/ktor/http/RangesSpecifier;", "userAgent", "ktor-server-core"})
public final class ApplicationRequestPropertiesKt {
    @Nullable
    public static final String header(@NotNull ApplicationRequest $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $receiver.getHeaders().get(name);
    }

    @NotNull
    public static final String queryString(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.substringAfter((String)OriginConnectionPointKt.getOrigin($receiver).getUri(), (char)'?', (String)"");
    }

    @NotNull
    public static final ContentType contentType(@NotNull ApplicationRequest $receiver) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                string = ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getContentType());
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = ContentType.Companion.parse(it);
                if (string != null) break block3;
            }
            string = ContentType.Companion.getAny();
        }
        return string;
    }

    @Nullable
    public static final Charset contentCharset(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)ApplicationRequestPropertiesKt.contentType($receiver)));
    }

    @NotNull
    public static final String document(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.substringAfterLast$default((String)ApplicationRequestPropertiesKt.path($receiver), (char)'/', null, (int)2, null);
    }

    @NotNull
    public static final String path(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.substringBefore$default((String)OriginConnectionPointKt.getOrigin($receiver).getUri(), (char)'?', null, (int)2, null);
    }

    @KtorExperimentalAPI
    @Nullable
    public static final String authorization(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAuthorization());
    }

    @Nullable
    public static final String location(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getLocation());
    }

    @Nullable
    public static final String accept(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAccept());
    }

    @NotNull
    public static final List<HeaderValue> acceptItems(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HttpHeaderValueParserKt.parseAndSortContentTypeHeader((String)ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAccept()));
    }

    @Nullable
    public static final String acceptEncoding(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptEncoding());
    }

    @NotNull
    public static final List<HeaderValue> acceptEncodingItems(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptEncoding()));
    }

    @Nullable
    public static final String acceptLanguage(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptLanguage());
    }

    @NotNull
    public static final List<HeaderValue> acceptLanguageItems(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptLanguage()));
    }

    @Nullable
    public static final String acceptCharset(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptCharset());
    }

    @NotNull
    public static final List<HeaderValue> acceptCharsetItems(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getAcceptCharset()));
    }

    public static final boolean isChunked(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getTransferEncoding());
        return string != null && StringsKt.compareTo((String)string, (String)"chunked", (boolean)true) == 0;
    }

    public static final boolean isMultipart(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.contentType($receiver).match(ContentType.MultiPart.INSTANCE.getAny());
    }

    @Nullable
    public static final String userAgent(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getUserAgent());
    }

    @Nullable
    public static final String cacheControl(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getCacheControl());
    }

    @NotNull
    public static final String host(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OriginConnectionPointKt.getOrigin($receiver).getHost();
    }

    public static final int port(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OriginConnectionPointKt.getOrigin($receiver).getPort();
    }

    @Nullable
    public static final RangesSpecifier ranges(@NotNull ApplicationRequest $receiver) {
        RangesSpecifier rangesSpecifier;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = ApplicationRequestPropertiesKt.header($receiver, HttpHeaders.INSTANCE.getRange());
        if (string != null) {
            String string2;
            String rangesSpec = string2 = string;
            boolean bl = false;
            rangesSpecifier = RangesKt.parseRangesSpecifier((String)rangesSpec);
        } else {
            rangesSpecifier = null;
        }
        return rangesSpecifier;
    }

    @NotNull
    public static final String getUri(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OriginConnectionPointKt.getOrigin($receiver).getUri();
    }

    @NotNull
    public static final HttpMethod getHttpMethod(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OriginConnectionPointKt.getOrigin($receiver).getMethod();
    }

    @NotNull
    public static final String getHttpVersion(@NotNull ApplicationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OriginConnectionPointKt.getOrigin($receiver).getVersion();
    }
}

