/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.response;

import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ResponseHeaders;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJz\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00052\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0019J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u0013\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/ktor/response/ResponseCookies;", "", "response", "Lio/ktor/response/ApplicationResponse;", "secureTransport", "", "(Lio/ktor/response/ApplicationResponse;Z)V", "append", "", "item", "Lio/ktor/http/Cookie;", "name", "", "value", "encoding", "Lio/ktor/http/CookieEncoding;", "maxAge", "", "expires", "Lio/ktor/util/date/GMTDate;", "domain", "path", "secure", "httpOnly", "extensions", "", "appendExpired", "get", "ktor-server-core"})
public final class ResponseCookies {
    private final ApplicationResponse response;
    private final boolean secureTransport;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Cookie get(@NotNull String name) {
        Object v0;
        block2: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable $receiver$iv = this.response.getHeaders().values("Set-Cookie");
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Cookie it = (Cookie)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public final void append(@NotNull Cookie item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (item.getSecure() && !this.secureTransport) {
            throw (Throwable)new IllegalArgumentException("You should set secure cookie only via secure transport (HTTPS)");
        }
        ResponseHeaders.append$default(this.response.getHeaders(), "Set-Cookie", CookieKt.renderSetCookieHeader((Cookie)item), false, 4, null);
    }

    public final void append(@NotNull String name, @NotNull String value, @NotNull CookieEncoding encoding, int maxAge, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        Intrinsics.checkParameterIsNotNull(extensions, (String)"extensions");
        this.append(new Cookie(name, value, encoding, maxAge, expires, domain, path, secure, httpOnly, extensions));
    }

    public static /* synthetic */ void append$default(ResponseCookies responseCookies, String string, String string2, CookieEncoding cookieEncoding, int n, GMTDate gMTDate, String string3, String string4, boolean bl, boolean bl2, Map map, int n2, Object object) {
        if ((n2 & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            map = MapsKt.emptyMap();
        }
        responseCookies.append(string, string2, cookieEncoding, n, gMTDate, string3, string4, bl, bl2, map);
    }

    public final void appendExpired(@NotNull String name, @Nullable String domain, @Nullable String path) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Map map = null;
        boolean bl = false;
        boolean bl2 = false;
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        String string = path;
        String string2 = domain;
        ResponseCookies.append$default(this, name, "", null, 0, gMTDate, string2, string, bl2, bl, map, 908, null);
    }

    public static /* synthetic */ void appendExpired$default(ResponseCookies responseCookies, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        responseCookies.appendExpired(string, string2, string3);
    }

    public ResponseCookies(@NotNull ApplicationResponse response, boolean secureTransport) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.response = response;
        this.secureTransport = secureTransport;
    }
}

