/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.routing;

import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.routing.RouteSelector;
import io.ktor.routing.RouteSelectorEvaluation;
import io.ktor.routing.RoutingResolveContext;
import io.ktor.util.KtorExperimentalAPI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lio/ktor/routing/HostRouteSelector;", "Lio/ktor/routing/RouteSelector;", "hostList", "", "", "hostPatterns", "Lkotlin/text/Regex;", "portsList", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getHostList", "()Ljava/util/List;", "getHostPatterns", "getPortsList", "component1", "component2", "component3", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/routing/RoutingResolveContext;", "segmentIndex", "hashCode", "toString", "Companion", "ktor-server-core"})
public final class HostRouteSelector
extends RouteSelector {
    @NotNull
    private final List<String> hostList;
    @NotNull
    private final List<Regex> hostPatterns;
    @NotNull
    private final List<Integer> portsList;
    @NotNull
    public static final String HostNameParameter = "$RequestHost";
    @NotNull
    public static final String PortParameter = "$RequestPort";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Collection matches12;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String requestHost = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getHost();
        int requestPort = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getPort();
        Collection collection = this.hostList;
        if (!collection.isEmpty() || !(collection = (Collection)this.hostPatterns).isEmpty()) {
            boolean matches2;
            boolean matches12;
            block8: {
                boolean bl;
                matches12 = this.hostList.contains(requestHost);
                if (!matches12) {
                    Iterable $receiver$iv = this.hostPatterns;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        parametersBuilder = $receiver$iv.iterator();
                        while (parametersBuilder.hasNext()) {
                            Object element$iv = parametersBuilder.next();
                            Regex it = (Regex)element$iv;
                            boolean bl2 = false;
                            if (!it.matches((CharSequence)requestHost)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                } else {
                    bl = matches2 = false;
                }
            }
            if (!matches12 && !matches2) {
                return RouteSelectorEvaluation.Companion.getFailed();
            }
        }
        if (!(matches12 = (Collection)this.portsList).isEmpty() && !this.portsList.contains(requestPort)) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $receiver = parametersBuilder = new ParametersBuilder(0, 1, null);
        boolean bl = false;
        $receiver.append(HostNameParameter, requestHost);
        $receiver.append(PortParameter, String.valueOf(requestPort));
        Parameters params = parametersBuilder.build();
        return new RouteSelectorEvaluation(true, 1.0, params, 0, 8, null);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.hostList + ", " + this.hostPatterns + ", " + this.portsList + ')';
    }

    @NotNull
    public final List<String> getHostList() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> getHostPatterns() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> getPortsList() {
        return this.portsList;
    }

    public HostRouteSelector(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(hostList, (String)"hostList");
        Intrinsics.checkParameterIsNotNull(hostPatterns, (String)"hostPatterns");
        Intrinsics.checkParameterIsNotNull(portsList, (String)"portsList");
        super(1.0);
        this.hostList = hostList;
        this.hostPatterns = hostPatterns;
        this.portsList = portsList;
        Collection collection = this.hostList;
        boolean bl2 = !collection.isEmpty() || !(collection = (Collection)this.hostPatterns).isEmpty() || !(collection = (Collection)this.portsList).isEmpty() ? true : (bl = false);
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<String> component1() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> component2() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> component3() {
        return this.portsList;
    }

    @NotNull
    public final HostRouteSelector copy(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        Intrinsics.checkParameterIsNotNull(hostList, (String)"hostList");
        Intrinsics.checkParameterIsNotNull(hostPatterns, (String)"hostPatterns");
        Intrinsics.checkParameterIsNotNull(portsList, (String)"portsList");
        return new HostRouteSelector(hostList, hostPatterns, portsList);
    }

    @NotNull
    public static /* synthetic */ HostRouteSelector copy$default(HostRouteSelector hostRouteSelector, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = hostRouteSelector.hostList;
        }
        if ((n & 2) != 0) {
            list2 = hostRouteSelector.hostPatterns;
        }
        if ((n & 4) != 0) {
            list3 = hostRouteSelector.portsList;
        }
        return hostRouteSelector.copy(list, list2, list3);
    }

    public int hashCode() {
        List<String> list = this.hostList;
        List<Regex> list2 = this.hostPatterns;
        List<Integer> list3 = this.portsList;
        return ((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HostRouteSelector)) break block3;
                HostRouteSelector hostRouteSelector = (HostRouteSelector)object;
                if (!Intrinsics.areEqual(this.hostList, hostRouteSelector.hostList) || !Intrinsics.areEqual(this.hostPatterns, hostRouteSelector.hostPatterns) || !Intrinsics.areEqual(this.portsList, hostRouteSelector.portsList)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lio/ktor/routing/HostRouteSelector$Companion;", "", "()V", "HostNameParameter", "", "HostNameParameter$annotations", "PortParameter", "PortParameter$annotations", "ktor-server-core"})
    public static final class Companion {
        @KtorExperimentalAPI
        public static /* synthetic */ void HostNameParameter$annotations() {
        }

        @KtorExperimentalAPI
        public static /* synthetic */ void PortParameter$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

