/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.license.runtime;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import jetbrains.teamsys.license.runtime.InvalidLicenseException;
import jetbrains.teamsys.license.runtime.LicenseUtil;

public class LicenseChecker {
    private BigInteger license;
    private final long generationTime;
    private final long expirationTime;
    private final int productType;
    private final int productVersion;
    private final int productMinorVersion;
    private final int buildNumber;
    private final int licenseType;

    public LicenseChecker(String name, BigInteger license, BigInteger n) throws GeneralSecurityException {
        license = license.modPow(LicenseUtil.THREE, n);
        BigInteger maskOfMD5 = LicenseUtil.ONE.shiftLeft(128).subtract(LicenseUtil.ONE);
        BigInteger licenseMD5 = license.and(maskOfMD5);
        license = license.shiftRight(128);
        if (!licenseMD5.equals(LicenseUtil.getLicenseMD5(license))) {
            throw new InvalidLicenseException("License is invalid");
        }
        BigInteger usernameMD5 = license.and(maskOfMD5);
        if (!usernameMD5.equals(LicenseUtil.getUsernameMD5(name))) {
            throw new InvalidLicenseException("License name is invalid", true);
        }
        this.license = license.shiftRight(128);
        this.productType = (int)this.getValue(16);
        this.productVersion = (int)this.getBroadcastableValue(10, Integer.MAX_VALUE);
        this.productMinorVersion = (int)this.getBroadcastableValue(10, Integer.MAX_VALUE);
        this.buildNumber = (int)this.getBroadcastableValue(20, Integer.MAX_VALUE);
        this.licenseType = (int)this.getValue(4);
        this.generationTime = this.getValue(63);
        this.expirationTime = this.getValue(63);
    }

    public Long getGenerationTime() {
        return this.generationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public int getProductType() {
        return this.productType;
    }

    public int getProductVersion() {
        return this.productVersion;
    }

    public int getProductMinorVersion() {
        return this.productMinorVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getLicenseType() {
        return this.licenseType;
    }

    protected long getValue(int bitlen) {
        long result = this.license.longValue();
        this.license = this.license.shiftRight(bitlen);
        return bitlen < 63 ? result & (1L << bitlen) - 1L : result & Long.MAX_VALUE;
    }

    public long getBroadcastableValue(int bitlen, long broadcastValue) {
        long result = this.getValue(bitlen);
        return result < LicenseUtil.powerOf2(bitlen) - 1L ? result : broadcastValue;
    }
}

