/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license.reader;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jetbrains.ring.license.License;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.ring.license.LicenseType;
import jetbrains.ring.license.Product;
import jetbrains.ring.license.reader.EmptyLicenseKeyException;
import jetbrains.ring.license.reader.EmptyLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseFormatException;
import jetbrains.ring.license.reader.InvalidLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseSignatureException;
import jetbrains.ring.license.reader.LicenseReadException;
import jetbrains.ring.license.reader.UnknownLicenseTypeException;
import jetbrains.ring.license.reader.UnknownProductException;
import org.jetbrains.annotations.NotNull;

public class LicenseReader {
    private static final int MD5_BITLEN = 128;
    private static final BigInteger RSA_MOD = new BigInteger("263209838529653741309366162078767955401650210060093940479440536241110980313794956537153327107041219371342779419863684554849202277263853757273750327567871802106538309185809561001712198328099404198770096988081455939118836298393133358550417396551205893870871649995935725104508543665608276612812277299875371100701");
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final long ONE_YEAR = 31536000000L;

    public License read(final String licenseName, String licenseKey) throws LicenseReadException {
        BigInteger licenseNumber;
        if (licenseName == null || licenseName.length() == 0) {
            throw new EmptyLicenseNameException();
        }
        if (licenseKey == null || licenseKey.length() == 0) {
            throw new EmptyLicenseKeyException();
        }
        try {
            licenseNumber = new BigInteger(licenseKey, 16);
        }
        catch (NumberFormatException e) {
            throw new InvalidLicenseFormatException();
        }
        BitStream license = new BitStream(licenseNumber.modPow(THREE, RSA_MOD));
        BigInteger licenseMD5 = license.readBigInteger(128);
        if (!licenseMD5.equals(LicenseReader.getLicenseMD5(license.getStream()))) {
            throw new InvalidLicenseSignatureException();
        }
        BigInteger usernameMD5 = license.readBigInteger(128);
        if (!usernameMD5.equals(LicenseReader.getUsernameMD5(licenseName))) {
            throw new InvalidLicenseNameException();
        }
        int productCode = license.readInt(16);
        final Product product = Product.valueOf(productCode);
        if (product == null) {
            throw new UnknownProductException(productCode);
        }
        final int majorVersion = license.readInt(10, Integer.MAX_VALUE);
        final int minorVersion = license.readInt(10, Integer.MAX_VALUE);
        final int buildNumber = license.readInt(20, Integer.MAX_VALUE);
        int licenseTypeCode = license.readInt(4);
        final LicenseType licenseType = LicenseType.valueOf(licenseTypeCode);
        if (licenseType == null) {
            throw new UnknownLicenseTypeException(licenseTypeCode);
        }
        final long generationTime = license.readLong(63);
        final long expirationTime = license.readLong(63, Long.MAX_VALUE);
        final int userCount = license.readInt(31);
        final long issueCount = license.readLong(63, Long.MAX_VALUE);
        final int projectCount = license.readInt(31, Integer.MAX_VALUE);
        final long flags = license.readLong(63);
        long freeUpgradeDays = license.readInt(15);
        final long upgradeExpirationTime = freeUpgradeDays == 0L ? (LicenseFlag.HOSTED_SOLUTION.hasFlag(flags) ? Long.MAX_VALUE : generationTime + 31536000000L) : generationTime + freeUpgradeDays * 24L * 60L * 60L * 1000L;
        int diskSpaceMB = license.readInt(31);
        final int diskSpace = diskSpaceMB > 0 ? diskSpaceMB : Integer.MAX_VALUE;
        final int reporterCount = license.readInt(12) * 10;
        return new License(){

            @Override
            @NotNull
            public String getName() {
                return licenseName;
            }

            @Override
            @NotNull
            public Product getProduct() {
                return product;
            }

            @Override
            public int getMajorVersion() {
                return majorVersion;
            }

            @Override
            public int getMinorVersion() {
                return minorVersion;
            }

            @Override
            public int getBuildNumber() {
                return buildNumber;
            }

            @Override
            @NotNull
            public LicenseType getLicenseType() {
                return licenseType;
            }

            @Override
            public long getGenerationTime() {
                return generationTime;
            }

            @Override
            public long getExpirationTime() {
                return expirationTime;
            }

            @Override
            public long getUpgradeExpirationTime() {
                return upgradeExpirationTime;
            }

            @Override
            public int getUserCount() {
                return userCount;
            }

            @Override
            public int getProjectCount() {
                return projectCount;
            }

            @Override
            public int getDiskSpace() {
                return diskSpace;
            }

            @Override
            public boolean isHosted() {
                return LicenseFlag.HOSTED_SOLUTION.hasFlag(flags);
            }

            @Override
            public boolean isLogoChangeForbidden() {
                return LicenseFlag.CHANGE_LOGO_FORBIDDEN.hasFlag(flags);
            }

            @Override
            public boolean isGuestBanForbidden() {
                return LicenseFlag.BAN_GUEST_FORBIDDEN.hasFlag(flags);
            }

            @Override
            public boolean isHttpsAllowed() {
                return LicenseFlag.HTTPS_ENABLED.hasFlag(flags);
            }

            @Override
            public int getReporterCount() {
                return reporterCount;
            }

            @Override
            public long getIssueCount() {
                return issueCount;
            }

            @Override
            public boolean isLdapEnabled() {
                return LicenseFlag.LDAP.hasFlag(flags);
            }

            @Override
            public boolean isTrackerDisabled() {
                return LicenseFlag.TRACKER_DISABLED.hasFlag(flags);
            }

            @Override
            public boolean isAgileDisabled() {
                return LicenseFlag.AGILE_DISABLED.hasFlag(flags);
            }

            public String toString() {
                return "License{name=\"" + this.getName() + "\"" + ", users=" + (this.getUserCount() == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(this.getUserCount())) + ", product=" + this.getProduct().name() + ", status=" + (this.getBuildNumber() == Integer.MAX_VALUE ? "any" : (this.getBuildNumber() == 1000000 ? "EAP" : (this.getBuildNumber() == 1000001 ? "beta" : (this.getBuildNumber() == 1000002 ? "RC" : Integer.valueOf(this.getBuildNumber()))))) + ", majorVersion=" + (this.getMajorVersion() == Integer.MAX_VALUE ? "any" : Integer.valueOf(this.getMajorVersion())) + ", licenseType=" + this.getLicenseType().name() + ", expiration=" + (this.getExpirationTime() == Long.MAX_VALUE ? "never" : new SimpleDateFormat("yyyy-MMM-dd").format(new Date(this.getExpirationTime()))) + ", upgradeExpiration=" + (this.getUpgradeExpirationTime() == Long.MAX_VALUE ? "never" : new SimpleDateFormat("yyyy-MMM-dd").format(new Date(this.getUpgradeExpirationTime()))) + "}";
            }
        };
    }

    private static BigInteger getUsernameMD5(@NotNull String username) {
        MessageDigest md5 = LicenseReader.getMD5();
        try {
            md5.update(username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new BigInteger(1, md5.digest());
    }

    private static BigInteger getLicenseMD5(@NotNull BigInteger license) {
        MessageDigest md5 = LicenseReader.getMD5();
        md5.update(license.toByteArray());
        return new BigInteger(1, md5.digest());
    }

    private static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BitStream {
        private BigInteger stream;

        public BitStream(BigInteger stream) {
            this.stream = stream;
        }

        public BigInteger getStream() {
            return this.stream;
        }

        public BigInteger readBigInteger(int bitLength) {
            BigInteger mask = BigInteger.ONE.shiftLeft(bitLength).subtract(BigInteger.ONE);
            BigInteger value = this.stream.and(mask);
            this.stream = this.stream.shiftRight(bitLength);
            return value;
        }

        public long readLong(int bitLength) {
            long result = this.stream.longValue();
            this.stream = this.stream.shiftRight(bitLength);
            return bitLength < 63 ? result & (1L << bitLength) - 1L : result & Long.MAX_VALUE;
        }

        public long readLong(int bitLength, long broadcastValue) {
            long result = this.readLong(bitLength);
            return result < (1L << bitLength) - 1L ? result : broadcastValue;
        }

        public int readInt(int bitLength) {
            int result = this.stream.intValue();
            this.stream = this.stream.shiftRight(bitLength);
            return bitLength < 31 ? result & (1 << bitLength) - 1 : result & Integer.MAX_VALUE;
        }

        public int readInt(int bitLength, int broadcastValue) {
            int result = this.readInt(bitLength);
            return result < (1 << bitLength) - 1 ? result : broadcastValue;
        }
    }
}

