/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.config;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.api.internal.auth.AuthService;
import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.validation.AdditionalKeystore;
import com.jetbrains.bundle.util.auth.Authenticator;
import com.jetbrains.bundle.util.auth.impl.SimpleAuthenticator;
import com.jetbrains.installer.config.AuthInterceptor;
import com.jetbrains.installer.config.WizardAuthService;
import com.jetbrains.installer.database.ExodusExplorer;
import com.jetbrains.installer.license.WizardLicenseCheckResult;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.KeyStoreContent;
import com.jetbrains.installer.model.LicenseAgreementsInfo;
import com.jetbrains.installer.model.PathInfo;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.SupportedLocale;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.model.blocks.AdditionalKeystoreWrapper;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.installer.model.blocks.CommonSettings;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.DumpOnInstall;
import com.jetbrains.installer.model.blocks.DumpOnUpgrade;
import com.jetbrains.installer.model.blocks.HttpModeSettings;
import com.jetbrains.installer.model.blocks.HttpsModeSettings;
import com.jetbrains.installer.model.blocks.HubBundleServiceInfo;
import com.jetbrains.installer.model.blocks.HubSettings;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.rest.UpgradeSourceResource;
import com.jetbrains.installer.util.WizardHubUtil;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.DefaultUpgradeHelper;
import com.jetbrains.installer.validation.HubUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeSourceValidationResult;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.UpsourceUpgradeHelper;
import com.jetbrains.installer.validation.YouTrackUpgradeHelper;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.ServiceUtil;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class AppConfig
extends WebMvcConfigurationSupport {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String DEFAULT_LOCALE = "en-US";
    @Autowired
    ServletContext context;

    @Bean(name={"isFinished"})
    AtomicBoolean getFinished() {
        return new AtomicBoolean(false);
    }

    @Bean(name={"upgradeMode"})
    AtomicBoolean getUpgradeMode() {
        return new AtomicBoolean(this.getWizardBackendConfig().isUpgradeDetected());
    }

    @Bean(name={"exodusExplorer"})
    ExodusExplorer getDatabaseExplorer() {
        return new ExodusExplorer();
    }

    @Bean(name={"defaultBasicSettings"})
    BasicSettings getDefaultBasicSettings() {
        BasicSettings defaultBasicSettings = new BasicSettings();
        this.initBasicSettings(defaultBasicSettings);
        return defaultBasicSettings;
    }

    @Bean(name={"defaultLicenseKeyInfo"})
    LicenseKeyInfo getDefaultLicenseKeyInfo() {
        Properties initParameters = this.getInitParameters();
        return this.resolveDefaultLicenseKeyInfoFromProperties(initParameters);
    }

    @Bean(name={"defaultUpgradeLicenseKeyInfo"})
    LicenseKeyInfo getDefaultUpgradeLicenseKeyInfo() {
        UpgradeSettings settings;
        if (this.getWizardBackendConfig().isUpgradeDetected() && (settings = this.getDefaultUpgradeSettings()).getContext() != null) {
            Properties extractedProperties = settings.getContext().getExtractedProperties();
            return LicenseKeyInfo.resolveKnownKeysFromProperties(extractedProperties, this.getDefaultLicenseKeyInfo());
        }
        return new LicenseKeyInfo();
    }

    private LicenseKeyInfo resolveDefaultLicenseKeyInfoFromProperties(@NotNull Properties extractedProperties) {
        LicenseKeyInfo licenseKeyInfo = new LicenseKeyInfo();
        Map serviceToLicenseKey = PropertiesBasedConfigurationHelper.getHelper().getServicesPropertyValue((Object)extractedProperties, "license-key");
        if (serviceToLicenseKey.size() == 1) {
            String serviceId = (String)serviceToLicenseKey.keySet().iterator().next();
            String licenseKey = (String)serviceToLicenseKey.get(serviceId);
            String licenseUserName = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)extractedProperties, serviceId, "license-user-name");
            LicenseKeyInfo.LicenseKey licenseInfo = this.createDefaultLicenseKeyInfo(serviceId, licenseUserName, licenseKey);
            licenseKeyInfo.setKey(licenseInfo);
        } else if (serviceToLicenseKey.size() > 1) {
            throw new IllegalStateException(String.format("License keys belonging to different services %s were found. Single service with license key is supported only", new HashSet(serviceToLicenseKey.keySet())));
        }
        return licenseKeyInfo;
    }

    @Bean(name={"defaultHubSettings"})
    HubSettings getDefaultHubSettings() {
        HubSettings defaultHubSettings = new HubSettings();
        this.initHubSettings(defaultHubSettings);
        return defaultHubSettings;
    }

    @Bean(name={"defaultUpgradeSource"})
    UpgradeSource getDefaultUpgradeSource() {
        UpgradeSource defaultUpgradeSource = new UpgradeSource();
        this.initUpgradeSource(defaultUpgradeSource);
        return defaultUpgradeSource;
    }

    @Bean(name={"defaultUpgradeSettings"})
    UpgradeSettings getDefaultUpgradeSettings() {
        UpgradeSettings settings = new UpgradeSettings();
        this.initUpgradeSettings(settings, this.getDefaultUpgradeSource());
        return settings;
    }

    @Bean
    BundleUpgradeHelper getUpgradeHelper() {
        String productName = this.getWizardBackendConfig().getProductName();
        if ("youtrack".equalsIgnoreCase(productName)) {
            return new YouTrackUpgradeHelper();
        }
        if ("hub".equalsIgnoreCase(productName)) {
            return new HubUpgradeHelper();
        }
        if ("upsource".equalsIgnoreCase(productName)) {
            return new UpsourceUpgradeHelper();
        }
        this.LOG.warn("No special upgrade helper found! DefaultUpgradeHelper will be used.");
        return new DefaultUpgradeHelper();
    }

    @Bean
    BundleDefaults getBundleDefaults() {
        BundleDefaults defaults = new BundleDefaults();
        defaults.setDataDir(this.getBundlePropertyDefault(BundleProperty.DATA_DIR.getName()));
        defaults.setBackupsDir(this.getBundlePropertyDefault(BundleProperty.BACKUPS_DIR.getName()));
        defaults.setLogsDir(this.getBundlePropertyDefault(BundleProperty.LOGS_DIR.getName()));
        defaults.setTempDir(this.getBundlePropertyDefault(BundleProperty.TEMP_DIR.getName()));
        String baseUrl = this.getBundlePropertyDefault(BundleProperty.BASE_URL.getName());
        defaults.setBaseUrl(UrlUtil.trimSlashes((String)baseUrl));
        defaults.setBundleListenPort(this.getBundlePropertyDefault(BundleProperty.LISTEN_PORT.getName()));
        defaults.setTlsServerCertKeyStorePassword(this.getBundlePropertyDefault(BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD.getName()));
        defaults.setTlsServerCertKeyStoreKeyAlias(this.getBundlePropertyDefault(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS.getName()));
        defaults.setTlsServerCertKeyStoreKeyPassword(this.getBundlePropertyDefault(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD.getName()));
        String tlsRedirectionFromHttpFlag = this.getBundlePropertyDefault(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName());
        defaults.setTlsRedirectionFromHttpFlag(tlsRedirectionFromHttpFlag);
        defaults.setTlsRedirectionFromHttpListenPort(this.getBundlePropertyDefault(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName()));
        String defaultNonSecurePort = this.getRequiredInitParameter("jetbrains.bundle.default-non-secure-port");
        String defaultSecurePort = this.getRequiredInitParameter("jetbrains.bundle.default-secure-port");
        ServerConnectorModeSettings connectorSettings = this.getDefaultServerConnectorModeSettings(defaultNonSecurePort, defaultSecurePort, Boolean.valueOf(tlsRedirectionFromHttpFlag));
        defaults.setServerConnectorModeSettings(connectorSettings);
        defaults.setSecureContent(new KeyStoreContent());
        defaults.setUseOldServerCertFlag(false);
        defaults.setRootUser(this.getBundlePropertyDefault(BundleProperty.ROOT_USER.getName()));
        defaults.setDisableInternalHub(Boolean.valueOf(this.getBundlePropertyDefault(BundleProperty.constructDisableServiceProperty((String)"hub", (boolean)false))));
        defaults.setAllowAnonymousAccess(Boolean.valueOf(this.getBundlePropertyDefault(BundleProperty.ALLOW_ANONYMOUS_ACCESS.getName(), Boolean.TRUE.toString())));
        defaults.setLocale(this.getBundlePropertyDefault(BundleProperty.LOCALE.getName()));
        return defaults;
    }

    @NotNull
    private ServerConnectorModeSettings getDefaultServerConnectorModeSettings(String defaultNonSecurePort, String defaultSecurePort, boolean tlsRedirectionFromHttpFlag) {
        ServerConnectorModeSettings connectorSettings;
        String defaultSecureMode = this.getBundlePropertyDefault(BundleProperty.SECURE_MODE.getName(), SecureMode.DISABLE.getName());
        if (SecureMode.DISABLE.getName().equals(defaultSecureMode)) {
            HttpModeSettings httpSettings = new HttpModeSettings();
            httpSettings.setNonSecureListenPort(defaultNonSecurePort);
            connectorSettings = httpSettings;
        } else if (SecureMode.TLS.getName().equals(defaultSecureMode)) {
            HttpsModeSettings httpsSettings = new HttpsModeSettings();
            httpsSettings.setSecureListenPort(defaultSecurePort);
            httpsSettings.setNonSecureRedirectListenPort(defaultNonSecurePort);
            httpsSettings.setRedirectionFromHttpEnabled(tlsRedirectionFromHttpFlag);
            connectorSettings = httpsSettings;
        } else {
            throw new IllegalStateException("Unsupported secure mode: " + defaultSecureMode);
        }
        connectorSettings.setListenAddress(this.getBundlePropertyDefault(BundleProperty.LISTEN_ADDRESS.getName()));
        connectorSettings.setDefaultNonSecureListenPort(defaultNonSecurePort);
        connectorSettings.setDefaultSecureListenPort(defaultSecurePort);
        connectorSettings.setDefaultRedirectionFromHttpFlag(tlsRedirectionFromHttpFlag);
        return connectorSettings;
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        return super.requestMappingHandlerAdapter();
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.addDefaultHttpMessageConverters(converters);
        for (HttpMessageConverter<?> c : converters) {
            if (!(c instanceof MappingJackson2HttpMessageConverter)) continue;
            this.customizeObjectMapper(((MappingJackson2HttpMessageConverter)c).getObjectMapper());
        }
    }

    private void customizeObjectMapper(@NotNull ObjectMapper objectMapper) {
        objectMapper.configure(MapperFeature.USE_GETTERS_AS_SETTERS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, false);
    }

    @Bean
    WizardHubUtil getWizardHubUtil() {
        return new WizardHubUtil();
    }

    @Bean
    WizardBackendConfig getWizardBackendConfig() {
        String keyEntriesPassword = this.getRequiredInitParameter("jetbrains.bundle.additional-keystore-store-password");
        return new WizardBackendConfig(this.getRequiredInitParameter("jetbrains.bundle.wizard.auth.token"), Paths.get(this.getRequiredInitParameter("jetbrains.bundle.wizard.auth.token.storage"), new String[0]), this.getRequiredInitParameter("jetbrains.bundle.wizard.service_for_redirection.url"), this.getRequiredInitParameter("jetbrains.bundle.wizard.service_for_redirection.context"), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.wizard.service_for_redirection.depends_on_bundle_port")), this.context.getInitParameter("jetbrains.bundle.wizard.installation.user"), BundleInstallationType.valueOf((String)this.getRequiredInitParameter("jetbrains.bundle.wizard.installation.type")), this.getRequiredInitParameter("jetbrains.bundle.wizard.product.full_version"), this.getRequiredInitParameter("jetbrains.bundle.product.name"), this.getRequiredInitParameter("jetbrains.bundle.wizard.product.presentation_name"), this.context.getInitParameter("jetbrains.bundle.product.upgrade.minimal.version"), this.context.getInitParameter("jetbrains.bundle.wizard.product.script.path"), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.wizard.external_hub_permitted")), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.wizard.upgrade_available")), this.context.getInitParameter("jetbrains.bundle.product.manufacturer"), this.getRequiredInitParameter("jetbrains.bundle.wizard.base_url"), this.getSupportedLocales(), this.context.getInitParameter("jetbrains.bundle.wizard.locales.community.link"), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.listen_address.is_editable")), this.getRequiredInitParameter("jetbrains.bundle.hub-service-id"), this.getRequiredInitParameter("jetbrains.bundle.hub-service-secret"), this.context.getInitParameter("jetbrains.bundle.wizard.hub-configurator-config-file"), this.context.getInitParameter("jetbrains.bundle.wizard.configurator-config-file-in-backup"), this.getRequiredInitParameter("jetbrains.bundle.additional-keystore-path"), keyEntriesPassword, keyEntriesPassword, Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.wizard.upgrade_detected")), this.context.getInitParameter("jetbrains.bundle.wizard.product.previous_full_version"), PathInfo.ensureEndsAsDir(this.getRequiredInitParameter("jetbrains.bundle.wizard.installation.directory")), this.context.getInitParameter("jetbrains.bundle.upgrade.help-link"), this.context.getInitParameter("jetbrains.bundle.upgrade.default-location"), Arrays.asList(this.getRequiredInitParameter("jetbrains.bundle.enabled.product.services").split(",")), this.context.getInitParameter("jetbrains.bundle.whats-new-page-link"), Paths.get(this.getRequiredInitParameter("jetbrains.bundle.conf-path"), new String[0]), Paths.get(this.getRequiredInitParameter("jetbrains.bundle.logs-path"), new String[0]), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.force-warning-on-invalid-base-url")), Boolean.valueOf(this.context.getInitParameter("jetbrains.bundle.https-feature-flag")), this.context.getInitParameter("jetbrains.bundle.tls-files-generation-help-page-link"));
    }

    @Bean
    DumpContext getDumpContext() {
        return new DumpContext();
    }

    @NotNull
    private String getRequiredInitParameter(String name) {
        String urlToShowAfterCompletion = this.context.getInitParameter(name);
        if (urlToShowAfterCompletion == null) {
            throw new IllegalStateException("Servlet context init parameter '" + name + "' must be set");
        }
        return urlToShowAfterCompletion;
    }

    @Bean
    WizardInfo getWizardInfo() {
        WizardBackendConfig backendConfig = this.getWizardBackendConfig();
        WizardInfo info = new WizardInfo();
        info.setProductPresentationName(backendConfig.getProductPresentationName());
        info.setExternalHubPermitted(backendConfig.isExternalHubPermitted());
        info.setUpgradeAvailable(backendConfig.isUpgradeAvailable());
        info.setProductFullVersion(backendConfig.getProductFullVersion());
        info.setProductManufacturer(backendConfig.getProductManufacturer());
        info.setProductName(backendConfig.getProductName());
        info.setWizardLocales(this.getWizardLocales());
        info.setLocalesCommunityLink(backendConfig.getLocalesCommunityLink());
        info.setAvailableProductLocales(backendConfig.getProductLocales());
        info.setIsListenAddressEditable(backendConfig.isListenAddressEditableFlag());
        info.setProductScriptPath(backendConfig.getProductScriptPath());
        info.setInstallationType(backendConfig.getInstallationType());
        info.setInstallationDirectory(PathInfo.ensureEndsAsDir(backendConfig.getInstallationDirectory()));
        info.setWhatsNewPageLink(backendConfig.getWhatsNewPageLink());
        info.setForceWarningOnInvalidBaseUrlFlag(backendConfig.isForceWarningOnInvalidBaseUrlFlag());
        info.setHttpsFeatureFlag(backendConfig.isHttpsFeatureFlag());
        info.setTlsFilesGenerationPageLink(backendConfig.getTlsFilesGenerationPageLink());
        return info;
    }

    private Collection<String> getWizardLocales() {
        ArrayList<String> locales = new ArrayList<String>(1);
        locales.add(DEFAULT_LOCALE);
        return locales;
    }

    @Bean(name={"basicSettings"})
    @DumpOnInstall
    BasicSettings getBasicSettings() {
        BasicSettings basicSettings = new BasicSettings();
        this.initBasicSettings(basicSettings);
        return basicSettings;
    }

    @Bean
    StepsInfo getStepsInfo() {
        return new StepsInfo();
    }

    @Bean
    @DumpOnUpgrade
    @DumpOnInstall
    CommonSettings getCommonSettings() {
        return new CommonSettings();
    }

    private void initBasicSettings(BasicSettings settings) {
        WizardBackendConfig config = this.getWizardBackendConfig();
        BundleDefaults bundleDefaults = this.getBundleDefaults();
        settings.setBaseUrl(bundleDefaults.getBaseUrl());
        settings.setDataDir(PathInfo.ensureEndsAsDir(bundleDefaults.getDataDir()));
        settings.setBackupsDir(PathInfo.ensureEndsAsDir(bundleDefaults.getBackupsDir()));
        settings.setLogsDir(PathInfo.ensureEndsAsDir(bundleDefaults.getLogsDir()));
        settings.setTempDir(PathInfo.ensureEndsAsDir(bundleDefaults.getTempDir()));
        settings.setStatisticsUpload(true);
        settings.setProductLocale(AppConfig.getDefaultProductLocale(config.getProductLocales(), bundleDefaults));
        settings.setUseOldServerCertFlag(bundleDefaults.isUseOldServerCertFlag());
        settings.setSecureContent(bundleDefaults.getSecureContent());
        settings.setServerConnectorModeSettings(bundleDefaults.getServerConnectorModeSettings());
    }

    @Bean(name={"licenseKeyInfo"})
    @DumpOnInstall
    @DumpOnUpgrade
    LicenseKeyInfo getLicenseKey() {
        LicenseKeyInfo licenseKeyInfo = new LicenseKeyInfo();
        licenseKeyInfo.addKeysFrom(this.getDefaultLicenseKeyInfo());
        licenseKeyInfo.updateKeysFrom(this.getDefaultUpgradeLicenseKeyInfo());
        return licenseKeyInfo;
    }

    @NotNull
    private Properties getInitParameters() {
        Enumeration initParameterNames = this.context.getInitParameterNames();
        Properties result = new Properties();
        while (initParameterNames.hasMoreElements()) {
            String paramName = (String)initParameterNames.nextElement();
            result.setProperty(paramName, this.context.getInitParameter(paramName));
        }
        return result;
    }

    private LicenseKeyInfo.LicenseKey createDefaultLicenseKeyInfo(@NotNull String serviceId, @NotNull String licenseUserName, @NotNull String licenseKey) {
        Date firstMajorReleaseDate;
        Integer distMajorVersion = this.getOptionalIntegerInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "product-major-version"));
        Integer distMinorVersion = this.getOptionalIntegerInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "product-minor-version"));
        Integer distBuildNumber = this.getOptionalIntegerInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "product-build-number"));
        String firstMajorReleaseDateProperty = this.context.getInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "first-major-release-date"));
        try {
            firstMajorReleaseDate = ServiceUtil.parseDate((String)firstMajorReleaseDateProperty, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new IllegalStateException("Can't parse major release date: " + firstMajorReleaseDateProperty, e);
        }
        LicenseKeyInfo.LicenseKey licenseInfo = new LicenseKeyInfo.LicenseKey(serviceId, licenseUserName, licenseKey, distMajorVersion, distMinorVersion, distBuildNumber, firstMajorReleaseDate);
        WizardLicenseCheckResult.Status status = licenseInfo.getStatus();
        if (status != WizardLicenseCheckResult.Status.OK) {
            this.LOG.warn("Invalid default license for " + serviceId + ": " + status.name());
        }
        return licenseInfo;
    }

    private Integer getOptionalIntegerInitParameter(String name) {
        String value = this.context.getInitParameter(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            this.LOG.warn("Incorrect init parameter " + name + ". Integer expected!");
            return null;
        }
    }

    private static String getDefaultProductLocale(@NotNull Collection<SupportedLocale> productLocales, @NotNull BundleDefaults bundleDefaults) {
        if (!productLocales.isEmpty()) {
            String defaultLocale = bundleDefaults.getLocale();
            if (defaultLocale != null && SupportedLocale.containsLocale(productLocales, defaultLocale)) {
                return defaultLocale;
            }
            if (SupportedLocale.containsLocale(productLocales, DEFAULT_LOCALE)) {
                return DEFAULT_LOCALE;
            }
            return productLocales.iterator().next().getLocale();
        }
        return null;
    }

    @Bean(name={"hubSettings"})
    @DumpOnInstall
    HubSettings getHubSettings() {
        HubSettings hubSettings = new HubSettings();
        this.initHubSettings(hubSettings);
        return hubSettings;
    }

    private void initHubSettings(HubSettings settings) {
        WizardInfo info = this.getWizardInfo();
        BundleDefaults bundleDefaults = this.getBundleDefaults();
        settings.setHubUrl(null);
        settings.setDisableInternalHub(info.isExternalHubPermitted() && bundleDefaults.isDisableInternalHub());
        settings.setRootUser(bundleDefaults.getRootUser());
        settings.setRootPassword(null);
        settings.setAllowAnonymousAccess(bundleDefaults.getAllowAnonymousAccess());
    }

    @Bean(name={"upgradeSettings"})
    @DumpOnUpgrade
    UpgradeSettings getUpgradeSettings() {
        UpgradeSettings settings = new UpgradeSettings();
        this.initUpgradeSettings(settings, this.getUpgradeSource());
        return settings;
    }

    private void initUpgradeSettings(@NotNull UpgradeSettings settings, @NotNull UpgradeSource upgradeSource) {
        UpgradeSettings upgradeSettings;
        Path preparedLocation;
        BundleUpgradeHelper upgradeHelper = this.getUpgradeHelper();
        UpgradeSourceValidationResult sourceValidationResult = upgradeHelper.validate(upgradeSource.getType(), upgradeSource.getSourceLocation());
        if (!sourceValidationResult.getValidationResult().hasErrors() && (preparedLocation = sourceValidationResult.getPreparedSourceLocation()) != null && (upgradeSettings = upgradeHelper.extractSettings(upgradeSource.getType(), preparedLocation, sourceValidationResult.getProperties(), sourceValidationResult.getValidationResult())) != null && !sourceValidationResult.getValidationResult().hasErrors()) {
            settings.copyFrom(upgradeSettings);
        }
    }

    @Bean(name={"upgradeSource"})
    UpgradeSource getUpgradeSource() {
        UpgradeSource upgradeSource = new UpgradeSource();
        this.initUpgradeSource(upgradeSource);
        return upgradeSource;
    }

    @Bean
    UpgradeSourceResource.OldUpgradeDataInfo getOldUpgradeDataInfo() throws UpgradeValidationException {
        String installationDirectory;
        UpgradeSourceResource.OldUpgradeDataInfo oldUpgradeDataInfo = new UpgradeSourceResource.OldUpgradeDataInfo();
        WizardBackendConfig wizardBackendConfig = this.getWizardBackendConfig();
        if (!wizardBackendConfig.isUpgradeDetected()) {
            oldUpgradeDataInfo.setCompleted(true);
        }
        if (!oldUpgradeDataInfo.getCompleted() && oldUpgradeDataInfo.getBackupPath() == null && (installationDirectory = wizardBackendConfig.getInstallationDirectory()) != null) {
            BundleUpgradeHelper upgradeHelper = this.getUpgradeHelper();
            Path backupPath = upgradeHelper.getOldUpgradeDataBackupDirectory(Paths.get(installationDirectory, new String[0]));
            oldUpgradeDataInfo.setBackupPath(backupPath.toString());
        }
        return oldUpgradeDataInfo;
    }

    private void initUpgradeSource(UpgradeSource upgradeSource) {
        WizardBackendConfig config = this.getWizardBackendConfig();
        if (config.isUpgradeDetected()) {
            upgradeSource.setType(UpgradeSource.Type.OLD_INSTALL_DIR);
            upgradeSource.setSourceLocation(config.getInstallationDirectory());
            UpgradeSourceValidationResult sourceValidationResult = this.getUpgradeHelper().validate(upgradeSource.getType(), upgradeSource.getSourceLocation());
            if (!sourceValidationResult.getValidationResult().hasErrors()) {
                upgradeSource.setPreparedSourceLocation(sourceValidationResult.getPreparedSourceLocation());
            }
        }
    }

    @Bean
    LicenseAgreementsInfo getLicenceInfo() {
        LicenseAgreementsInfo info = new LicenseAgreementsInfo();
        Enumeration initParameterNames = this.context.getInitParameterNames();
        ArrayList<LicenseAgreementsInfo.LicenseAgreementInfo> licenses = new ArrayList<LicenseAgreementsInfo.LicenseAgreementInfo>();
        while (initParameterNames.hasMoreElements()) {
            String paramName = (String)initParameterNames.nextElement();
            String serviceIdPrefix = PropertiesBasedConfigurationHelper.getHelper().parseServiceIdPrefix(paramName);
            if (serviceIdPrefix == null || !paramName.endsWith(".license.agreement.path")) continue;
            String serviceName = serviceIdPrefix.split(Pattern.quote("."))[1];
            assert (serviceName.length() > 0);
            String licensePath = this.context.getInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceName, "license.agreement.path"));
            String licenseProductName = this.context.getInitParameter(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceName, "license.agreement.product.name"));
            LicenseAgreementsInfo.LicenseAgreementInfo licenseAgreementInfo = new LicenseAgreementsInfo.LicenseAgreementInfo();
            licenseAgreementInfo.setProductName(licenseProductName);
            licenseAgreementInfo.setDocumentPath(licensePath);
            licenses.add(licenseAgreementInfo);
        }
        info.setLicenseAgreements(licenses);
        return info;
    }

    @Bean
    @DumpOnUpgrade
    @DumpOnInstall
    protected AdditionalKeystoreWrapper getAdditionalKeystore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        WizardBackendConfig config = this.getWizardBackendConfig();
        return new AdditionalKeystoreWrapper(new AdditionalKeystore(Paths.get(config.getAdditionalKeystorePath(), new String[0]), config.getAdditionalKeystorePassword()));
    }

    @Bean
    HubClientProvider getHubClientProvider() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        WizardBackendConfig config = this.getWizardBackendConfig();
        AdditionalKeystoreWrapper additionalKeystore = this.getAdditionalKeystore();
        return new HubClientProvider(additionalKeystore.getKeystore().getKeyStore(), config.getAdditionalKeystoreKeyEntriesPassword());
    }

    @Bean
    @DumpOnInstall
    HubBundleServiceInfo getHubBundleServiceInfo() {
        WizardBackendConfig config = this.getWizardBackendConfig();
        String ipAddress = SystemUtil.getNonLoopbackLocalHostIPAddress();
        String name = String.format("%s Bundle%s", config.getProductPresentationName(), ipAddress != null ? " (@" + ipAddress + ")" : "");
        HubBundleServiceInfo hubBundleServiceInfo = new HubBundleServiceInfo();
        hubBundleServiceInfo.setBundleServiceName(name);
        hubBundleServiceInfo.setBundleServiceId(config.getBundleServiceId());
        hubBundleServiceInfo.setBundleServiceSecret(config.getBundleServiceSecret());
        return hubBundleServiceInfo;
    }

    @Bean
    public WizardAuthService getWizardAuthService() {
        return new WizardAuthService();
    }

    @Bean
    public Authenticator getAuthenticator() {
        return new SimpleAuthenticator((AuthService)this.getWizardAuthService());
    }

    @NotNull
    private String getBundlePropertyDefault(String property, @NotNull String defaultValue) {
        String value = this.getBundlePropertyDefault(property);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String getBundlePropertyDefault(String property) {
        String paramName = "jetbrains.bundle." + property + ".default";
        return this.context.getInitParameter(paramName);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        WebContentInterceptor interceptor = new WebContentInterceptor();
        interceptor.setCacheSeconds(0);
        interceptor.setCacheControl(CacheControl.noStore());
        registry.addInterceptor((HandlerInterceptor)interceptor);
        AuthInterceptor authInterceptor = new AuthInterceptor(this.getAuthenticator());
        registry.addInterceptor((HandlerInterceptor)authInterceptor);
    }

    private List<SupportedLocale> getSupportedLocales() {
        ArrayList<SupportedLocale> result = new ArrayList<SupportedLocale>();
        result.addAll(this.convertToSupportedLocale("jetbrains.bundle.wizard.locales", false));
        result.addAll(this.convertToSupportedLocale("jetbrains.bundle.wizard.locales.community", true));
        return result;
    }

    @NotNull
    private Collection<SupportedLocale> convertToSupportedLocale(@NotNull String parameter, boolean isCommunity) {
        Collection<String> locales = AppConfig.parseLocales(this.context.getInitParameter(parameter));
        ArrayList<SupportedLocale> result = new ArrayList<SupportedLocale>();
        for (String s : locales) {
            SupportedLocale locale = new SupportedLocale();
            locale.setLocale(s);
            locale.setCommunity(isCommunity);
            result.add(locale);
        }
        return result;
    }

    @NotNull
    private static Collection<String> parseLocales(String localeListAsString) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (localeListAsString != null) {
            String[] locales;
            for (String locale : locales = localeListAsString.trim().split(",")) {
                if (locale.trim().isEmpty()) continue;
                resultList.add(locale.trim());
            }
        }
        return resultList;
    }
}

