/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.config;

import com.jetbrains.installer.filters.CorsFilter;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import jetbrains.ring.servlet.StaticServlet;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

public class InstallerWebApplicationInitializer
extends AbstractDispatcherServletInitializer {
    public static final String API_CONTEXT_PATH = "/api";
    private AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();

    protected WebApplicationContext createRootApplicationContext() {
        return null;
    }

    protected WebApplicationContext createServletApplicationContext() {
        this.context.scan(new String[]{"com.jetbrains.installer"});
        return this.context;
    }

    protected String getServletName() {
        return "InstallerServletDispatcher";
    }

    protected String[] getServletMappings() {
        return new String[]{"/api/*"};
    }

    protected Filter[] getServletFilters() {
        CharacterEncodingFilter cef = new CharacterEncodingFilter();
        cef.setEncoding("UTF-8");
        cef.setForceEncoding(true);
        return new Filter[]{cef, new CorsFilter()};
    }

    protected FilterRegistration.Dynamic registerServletFilter(ServletContext servletContext, Filter filter) {
        return super.registerServletFilter(servletContext, filter);
    }

    protected void registerDispatcherServlet(ServletContext servletContext) {
        super.registerDispatcherServlet(servletContext);
        this.registerStaticServlet(servletContext);
    }

    private void registerStaticServlet(ServletContext servletContext) {
        ServletRegistration.Dynamic registration = servletContext.addServlet("RingStaticServlet", (Servlet)new StaticServlet());
        registration.setInitParameter("welcomePage", "/index.html");
        registration.setInitParameter("contextTag", "context");
        registration.setInitParameter("cacheWelcome", Boolean.TRUE.toString());
        registration.setInitParameter("cacheControl", "no-cache, no-store, must-revalidate, max-age=0, proxy-revalidate, s-maxage=0");
        registration.setLoadOnStartup(1);
        registration.addMapping(new String[]{"/*"});
    }
}

