/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.database;

import com.jetbrains.bundle.util.BundleUtil;
import com.jetbrains.installer.database.PersistedYouTrackProperty;
import com.jetbrains.installer.database.YouTrackInstallationType;
import java.io.File;
import java.nio.file.Path;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExodusExplorer {
    public static final String EXODUS_FILE_EXT = ".xd";
    private static final String YT_STORE_NAME = "teamsysstore";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    static final String CONFIG_ENTITY_NAME = "NotificationsConfig";
    static final String METADATA_ENTITY_NAME = "ApplicationMetaData";
    static final String RING_SETTINGS_ENTITY_NAME = "RingSettings";
    static final String RING_BUNDLE_SETTINGS_ENTITY_NAME = "RingBundleSettings";

    public boolean isExodusDatabase(@NotNull Path databaseDir) {
        return BundleUtil.isExodusDatabase((Path)databaseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeOpened(@NotNull Path databaseDir) {
        try (Environment environment = null;){
            environment = Environments.newInstance((File)databaseDir.toFile(), (EnvironmentConfig)ExodusExplorer.createEnvironmentConfig());
            boolean bl = true;
            return bl;
        }
    }

    @Nullable
    public String getYouTrackFullVersion(Path databasePath) {
        String prefix;
        Integer build = (Integer)this.readSimpleProperty(databasePath, PersistedYouTrackProperty.PRODUCT_BUILD);
        if (build == null) {
            return null;
        }
        String majorMinorVersion = (String)this.readSimpleProperty(databasePath, PersistedYouTrackProperty.PRODUCT_MAJOR_MINOR_VERSION);
        if (majorMinorVersion != null) {
            return majorMinorVersion + "." + build;
        }
        if (build < 8000) {
            prefix = "5.0.";
        } else if (build < 9000) {
            prefix = "5.1.";
        } else if (build < 10000) {
            prefix = "5.2.";
        } else if (build < 13000) {
            prefix = "6.0.";
        } else if (build < 19000) {
            prefix = "6.5.";
        } else {
            this.LOG.error(String.format("Major product version can not be resolved. Build number %s loaded from database property [%s->%s] is greater than 19000 and at the same time property [%s->%s] is not found", build, PersistedYouTrackProperty.PRODUCT_BUILD.getDbEntityName(), PersistedYouTrackProperty.PRODUCT_BUILD.getDbPropName(), PersistedYouTrackProperty.PRODUCT_MAJOR_MINOR_VERSION.getDbEntityName(), PersistedYouTrackProperty.PRODUCT_MAJOR_MINOR_VERSION.getDbPropName()));
            return null;
        }
        return prefix + build;
    }

    public YouTrackInstallationType getYouTrackInstallationType(Path databasePath) {
        String instType = (String)this.readSimpleProperty(databasePath, PersistedYouTrackProperty.BUNDLE_INSTALLATION_TYPE);
        if (instType == null) {
            return null;
        }
        try {
            return YouTrackInstallationType.valueOf(instType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Boolean readBooleanSimpleProperty(Path databasePath, PersistedYouTrackProperty property) {
        return (Boolean)this.readSimpleProperty(databasePath, property);
    }

    public String readStringSimpleProperty(Path databasePath, PersistedYouTrackProperty property) {
        return (String)this.readSimpleProperty(databasePath, property);
    }

    private <T> T readSimplePropertyNotNull(Path databasePath, PersistedYouTrackProperty property) {
        T value = this.readSimpleProperty(databasePath, property);
        if (value == null) {
            throw new ExodusException(property.getDbPropName() + " of " + property.getDbEntityName() + " does not exist in " + databasePath);
        }
        return value;
    }

    private <T> T readSimpleProperty(Path databasePath, final PersistedYouTrackProperty property) {
        return this.execute(new StoreTransactionalComputable<T>(){

            public T compute(@NotNull StoreTransaction storeTransaction) {
                Entity first;
                EntityIterable iterable = storeTransaction.getAll(property.getDbEntityName());
                if (iterable.size() > 0L && (first = iterable.getFirst()) != null) {
                    return first.getProperty(property.getDbPropName());
                }
                return null;
            }
        }, databasePath);
    }

    public String readStringBlobProperty(Path databasePath, PersistedYouTrackProperty property) {
        return (String)this.readBlobProperty(databasePath, property);
    }

    private <T> T readBlobProperty(Path databasePath, final PersistedYouTrackProperty property) {
        return this.execute(new StoreTransactionalComputable<T>(){

            public T compute(@NotNull StoreTransaction storeTransaction) {
                Entity first;
                EntityIterable iterable = storeTransaction.getAll(property.getDbEntityName());
                if (iterable.size() > 0L && (first = iterable.getFirst()) != null) {
                    return first.getBlobString(property.getDbPropName());
                }
                return null;
            }
        }, databasePath);
    }

    private static EnvironmentConfig createEnvironmentConfig() {
        return new EnvironmentConfig().setManagementEnabled(false).setLogCacheShared(false).setLogCacheUseNio(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(StoreTransactionalComputable<T> computable, Path databasePath) {
        Environment environment = null;
        PersistentEntityStoreImpl store = null;
        try {
            environment = Environments.newInstance((File)databasePath.toFile(), (EnvironmentConfig)ExodusExplorer.createEnvironmentConfig());
            PersistentEntityStoreConfig conf = new PersistentEntityStoreConfig();
            conf.setRefactoringSkipAll(true);
            conf.setManagementEnabled(false);
            store = PersistentEntityStores.newInstance((PersistentEntityStoreConfig)conf, (Environment)environment, (String)YT_STORE_NAME);
            Object object = store.computeInReadonlyTransaction(computable);
            return (T)object;
        }
        finally {
            if (store != null) {
                try {
                    store.getAsyncProcessor().waitForJobs(10L);
                }
                catch (Exception e) {
                    this.LOG.warn("Exception while waiting for jobs", (Throwable)e);
                }
            }
            if (environment != null) {
                environment.close();
            }
        }
    }
}

