/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.filters;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;

public class HttpServerCorsFilter
extends Filter {
    @Override
    public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
        Headers requestHeaders = httpExchange.getRequestHeaders();
        Headers responseHeaders = httpExchange.getResponseHeaders();
        Object originHeader = requestHeaders.get("Origin");
        if (originHeader != null && originHeader.size() == 1) {
            responseHeaders.add("Access-Control-Allow-Origin", (String)originHeader.iterator().next());
            responseHeaders.add("Access-Control-Allow-Credentials", Boolean.TRUE.toString());
            responseHeaders.add("Access-Control-Expose-Headers", "X-Cache-Date, X-Atmosphere-tracking-id");
        }
        if ("OPTIONS".equals(httpExchange.getRequestMethod())) {
            responseHeaders.add("Access-Control-Allow-Methods", "OPTIONS, GET, POST, PUT, DELETE");
            responseHeaders.add("Access-Control-Allow-Headers", "Accept, Authorization, Content-Type, Origin, X-Atmosphere-Framework, X-Atmosphere-Transport, X-Atmosphere-tracking-id, X-Cache-Date");
            responseHeaders.add("Access-Control-Max-Age", "-1");
        }
        chain.doFilter(httpExchange);
    }

    @Override
    public String description() {
        return null;
    }
}

