/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

public class BuildNumber {
    private int build;
    private BuildNumberType type;

    public static BuildNumber parseBuildNumber(int build) {
        BuildNumberType[] types;
        for (BuildNumberType type : types = BuildNumberType.values()) {
            if (type == BuildNumberType.SINGLE || type.getId() != build) continue;
            return new BuildNumber(type);
        }
        return new BuildNumber(build);
    }

    private BuildNumber(BuildNumberType type) {
        this(type.getId(), type);
    }

    private BuildNumber(int build) {
        this(build, BuildNumberType.SINGLE);
    }

    private BuildNumber(int build, BuildNumberType type) {
        this.build = build;
        this.type = type;
    }

    public String toString() {
        if (this.getType() == BuildNumberType.SINGLE) {
            return "Only build " + this.getBuild();
        }
        return this.type.getName();
    }

    public int getBuild() {
        return this.build;
    }

    public BuildNumberType getType() {
        return this.type;
    }

    static enum BuildNumberType {
        ANY(Integer.MAX_VALUE, "Unlimited"),
        EAP(1000000, "Early Access Preview only"),
        BETA(1000001, "Beta only"),
        RC(1000002, "Release Candidate only"),
        SINGLE(-1, "Single build only");

        private final int id;
        private final String name;

        private BuildNumberType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

