/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

import com.jetbrains.installer.license.LicenseField;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class FieldPartial {
    public static final FieldPartial COMMON_FIELDS = new FieldPartial(LicenseField.LICENSE_TYPE, LicenseField.PRODUCT_TYPE, LicenseField.EXPIRATION_TIME, LicenseField.RENEWAL_TIME, LicenseField.MAX_USERS, LicenseField.MAJOR_VERSION);
    public static final FieldPartial YOUTRACK_FIELDS = new FieldPartial(LicenseField.MAX_ISSUES, LicenseField.MAX_PROJECTS, LicenseField.CAN_CHANGE_LOGO, LicenseField.BUILD_NUMBER).union(COMMON_FIELDS);
    public static final FieldPartial HUB_FIELDS = new FieldPartial(LicenseField.BUILD_NUMBER).union(COMMON_FIELDS);
    private final Set<LicenseField> fields;

    public FieldPartial(LicenseField ... fields) {
        this(FieldPartial.convertArrayToSet(fields));
    }

    public FieldPartial(Set<LicenseField> fields) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Fields can't be empty");
        }
        this.fields = fields;
    }

    public Set<LicenseField> getFields() {
        return this.fields;
    }

    public FieldPartial union(FieldPartial that) {
        this.fields.addAll(that.getFields());
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (LicenseField field : this.fields) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            builder.append(field.getName());
        }
        return builder.toString();
    }

    private static Set<LicenseField> convertArrayToSet(LicenseField[] arr) {
        LinkedHashSet<LicenseField> set = new LinkedHashSet<LicenseField>(arr.length);
        Collections.addAll(set, arr);
        return set;
    }
}

