/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

import com.jetbrains.installer.license.WizardLicenseCheckResult;
import org.jetbrains.annotations.NotNull;

public enum LicenseField {
    LICENSE_TYPE("License type", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getLicenseType().getName();
        }
    }),
    PRODUCT_TYPE("Product type", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getProductType().toString();
        }
    }),
    MAJOR_VERSION("Product major version", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getProductMajorVersionString();
        }
    }),
    MINOR_VERSION("Product minor version", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getProductMinorVersionString();
        }
    }),
    BUILD_NUMBER("Product build number", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getBuildNumber().toString();
        }
    }),
    EXPIRATION_TIME("Expiration date", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getExpirationTimeString();
        }
    }),
    RENEWAL_TIME("Renewal possible until", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getRenewalTimeString();
        }
    }),
    MAX_USERS("Maximum users count", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getMaxUsersCountString();
        }
    }),
    MAX_ISSUES("Maximum issues count", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getMaxIssuesCountString();
        }
    }),
    MAX_PROJECTS("Maximum projects count", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getMaxProjectsCountSting();
        }
    }),
    MAX_DISK_SPACE("Maximum disk space", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return result.getMaxDiskSpaceSting();
        }
    }),
    CAN_CHANGE_LOGO("User can change logo", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return String.valueOf(result.getUserCanChangeLogo());
        }
    }),
    CAN_BAN_GUEST("Anonymous access can be forbidden", new ValueExtractor(){

        @Override
        public String extractValue(@NotNull WizardLicenseCheckResult result) {
            return String.valueOf(!result.isGuestBanForbidden());
        }
    });

    private final String name;
    private ValueExtractor valueExtractor;

    private LicenseField(String name, ValueExtractor converter) {
        this.name = name;
        this.valueExtractor = converter;
    }

    public String extractValue(@NotNull WizardLicenseCheckResult result) {
        return this.valueExtractor.extractValue(result);
    }

    public String getName() {
        return this.name;
    }

    static interface ValueExtractor {
        public String extractValue(@NotNull WizardLicenseCheckResult var1);
    }
}

