/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

enum LicenseType {
    COMMERCIAL(0, "Commercial"),
    FREE(1, "Free license"),
    TRIAL(2, "Trial license"),
    OPEN_SOURCE(3, "Open source license"),
    CLASSROOM(4, "Classroom license");

    private final long id;
    private final String name;

    private LicenseType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static LicenseType parseLicenseType(int licenseType) {
        LicenseType[] types;
        for (LicenseType type : types = LicenseType.values()) {
            if (type.getId() != (long)licenseType) continue;
            return type;
        }
        throw new IllegalStateException("Unknown license type: " + licenseType);
    }
}

