/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

import com.jetbrains.installer.license.FieldPartial;

public class ProductInfo {
    private int licenseProductId;
    private ProductType type;

    public static ProductInfo parseProductType(int build) {
        ProductType[] types;
        for (ProductType type : types = ProductType.values()) {
            if (type == ProductType.UNKNOWN || type.getId() != build) continue;
            return new ProductInfo(type);
        }
        return new ProductInfo(build);
    }

    private ProductInfo(ProductType type) {
        this(type.getId(), type);
    }

    private ProductInfo(int licenseProductId) {
        this(licenseProductId, ProductType.UNKNOWN);
    }

    private ProductInfo(int licenseProductId, ProductType type) {
        this.licenseProductId = licenseProductId;
        this.type = type;
    }

    public String toString() {
        if (this.getType() == ProductType.UNKNOWN) {
            return "Product #" + this.getLicenseProductId();
        }
        return this.type.getName();
    }

    public int getLicenseProductId() {
        return this.licenseProductId;
    }

    public ProductType getType() {
        return this.type;
    }

    public FieldPartial getFieldsToShow() {
        return this.type.getFieldsToShow();
    }

    public static enum ProductType {
        ANY(Integer.MAX_VALUE, "Unlimited", FieldPartial.COMMON_FIELDS),
        YOUTRACK(0, "YouTrack", FieldPartial.YOUTRACK_FIELDS),
        UPSOURCE(1, "Upsource", FieldPartial.COMMON_FIELDS),
        HUB(2, "Hub", FieldPartial.HUB_FIELDS),
        UNKNOWN(-1, "Unknown", FieldPartial.COMMON_FIELDS);

        private final int id;
        private final String name;
        private FieldPartial fieldsToShow;

        private ProductType(int id, String name, FieldPartial fieldsToShow) {
            this.id = id;
            this.name = name;
            this.fieldsToShow = fieldsToShow;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public FieldPartial getFieldsToShow() {
            return this.fieldsToShow;
        }
    }
}

