/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.license;

import com.jetbrains.installer.license.BuildNumber;
import com.jetbrains.installer.license.FieldPartial;
import com.jetbrains.installer.license.LicenseField;
import com.jetbrains.installer.license.LicenseType;
import com.jetbrains.installer.license.ProductInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jetbrains.ring.license.BuildStatus;
import jetbrains.ring.license.License;
import jetbrains.ring.license.Product;
import jetbrains.ring.license.checker.ApplicationDescriptor;
import jetbrains.ring.license.checker.InvalidMinorVersionException;
import jetbrains.ring.license.checker.InvalidProductException;
import jetbrains.ring.license.checker.LicenseCheckerImpl;
import jetbrains.ring.license.checker.LicenseExpiredException;
import jetbrains.ring.license.checker.LicenseLimitException;
import jetbrains.ring.license.checker.NotGeneratedLicenseException;
import jetbrains.ring.license.checker.NotHostedLicenseException;
import jetbrains.ring.license.checker.NotStandaloneLicenseException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import jetbrains.ring.license.reader.EmptyLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseSignatureException;
import jetbrains.ring.license.reader.LicenseReader;
import jetbrains.ring.license.reader.UnknownLicenseTypeException;
import jetbrains.ring.license.reader.UnknownProductException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardLicenseCheckResult {
    private final String licenseUserName;
    private final License license;
    private Status status;

    @NotNull
    public static WizardLicenseCheckResult checkLicense(@NotNull String licenseUserName, @NotNull String licenseKey, @Nullable Integer productType, @Nullable Integer majorVersion, @Nullable Integer minorVersion, @Nullable Integer buildNumber, @Nullable Date firstMajorReleaseDate) {
        Status status;
        try {
            License license = new LicenseReader().read(licenseUserName, licenseKey);
            return new WizardLicenseCheckResult(licenseUserName, license, productType, majorVersion, minorVersion, buildNumber, firstMajorReleaseDate);
        }
        catch (InvalidLicenseSignatureException e) {
            status = Status.INVALID_KEY;
        }
        catch (UnknownLicenseTypeException e) {
            status = Status.INVALID_LICENSE_TYPE;
        }
        catch (UnknownProductException e) {
            status = Status.INVALID_PRODUCT_TYPE;
        }
        catch (EmptyLicenseNameException | InvalidLicenseNameException e) {
            status = Status.INVALID_USER_NAME;
        }
        catch (Exception e) {
            status = Status.INVALID_KEY;
        }
        return new WizardLicenseCheckResult(licenseUserName, status);
    }

    public WizardLicenseCheckResult(@NotNull String licenseUserName, @NotNull Status status) {
        this.licenseUserName = licenseUserName;
        this.license = null;
        this.status = status;
    }

    public WizardLicenseCheckResult(@NotNull String licenseUserName, @NotNull License license, @Nullable Integer productType, @Nullable Integer majorVersion, @Nullable Integer minorVersion, @Nullable Integer buildNumber, @Nullable Date firstMajorReleaseDate) {
        this.licenseUserName = licenseUserName;
        this.license = license;
        this.calculateStatus(productType, majorVersion, minorVersion, buildNumber, firstMajorReleaseDate);
    }

    public String getProductMajorVersionString() {
        int productMajorVersion = this.getProductMajorVersion();
        return this.licenseIntegerToString(productMajorVersion);
    }

    public String getProductMinorVersionString() {
        return this.licenseIntegerToString(this.getProductMinorVersion());
    }

    private String licenseIntegerToString(int value) {
        if (value == Integer.MAX_VALUE) {
            return "Unlimited";
        }
        return String.valueOf(value);
    }

    public String getMaxUsersCountString() {
        return this.licenseIntegerToString(this.getMaxUsersCount());
    }

    public String getMaxIssuesCountString() {
        long value = this.getMaxIssuesCount();
        if (value == Long.MAX_VALUE) {
            return "Unlimited";
        }
        return String.valueOf(value);
    }

    public String getMaxProjectsCountSting() {
        return this.licenseIntegerToString(this.getMaxProjectsCount());
    }

    public String getMaxDiskSpaceSting() {
        return this.licenseIntegerToString(this.getMaxDiskSpace());
    }

    private int getMaxDiskSpace() {
        return this.license.getDiskSpace();
    }

    private void calculateStatus(final @Nullable Integer productType, final @Nullable Integer majorVersion, final @Nullable Integer minorVersion, final @Nullable Integer buildNumber, final @Nullable Date firstMajorReleaseDate) {
        this.assertCheckerNotNull();
        ApplicationDescriptor appDescriptor = new ApplicationDescriptor(){

            public Product getProduct() {
                if (productType != null) {
                    return Product.valueOf((int)productType);
                }
                return Product.YOUTRACK;
            }

            public long getReleaseDate() {
                return firstMajorReleaseDate != null ? firstMajorReleaseDate.getTime() : 0L;
            }

            public int getMajorVersion() {
                if (majorVersion != null) {
                    return majorVersion;
                }
                return 0;
            }

            public int getMinorVersion() {
                if (minorVersion != null) {
                    return minorVersion;
                }
                return 0;
            }

            public BuildStatus getBuildStatus() {
                int licenseBuildNumber = WizardLicenseCheckResult.this.license.getBuildNumber();
                if (licenseBuildNumber == 1000000) {
                    return BuildStatus.EAP;
                }
                if (licenseBuildNumber == 1000001) {
                    return BuildStatus.BETA;
                }
                if (licenseBuildNumber == 1000002) {
                    return BuildStatus.RELEASE_CANDIDATE;
                }
                return BuildStatus.RELEASE;
            }

            public int getBuildNumber() {
                if (buildNumber != null) {
                    return buildNumber;
                }
                return 0;
            }

            public boolean isHosted() {
                return false;
            }

            public int getUsersNumber() {
                return 0;
            }

            public int getProjectNumber() {
                return 0;
            }

            public long getIssueNumber() {
                return 0L;
            }

            public int getDiskUsage() {
                return 0;
            }
        };
        LicenseCheckerImpl licenseChecker = new LicenseCheckerImpl(this.license, appDescriptor);
        try {
            licenseChecker.checkExpiration();
            licenseChecker.checkUpgradeExpiration();
            licenseChecker.checkHosted();
            if (productType != null) {
                licenseChecker.checkProduct();
            }
            if (minorVersion != null) {
                licenseChecker.checkMinorVersion();
            }
            this.status = Status.OK;
        }
        catch (NotHostedLicenseException | NotStandaloneLicenseException e) {
            this.status = Status.HOSTED_SOLUTION;
        }
        catch (NotGeneratedLicenseException e) {
            this.status = Status.GENERATION_DATE_IN_FUTURE;
        }
        catch (LicenseExpiredException e) {
            this.status = Status.EXPIRED;
        }
        catch (UpgradeExpiredException e) {
            this.status = Status.FREE_UPGRADE_PERIOD_EXPIRED;
        }
        catch (InvalidMinorVersionException e) {
            this.status = Status.INVALID_VERSION;
        }
        catch (InvalidProductException e) {
            this.status = Status.INVALID_PRODUCT_TYPE;
        }
        catch (LicenseLimitException e) {
            this.status = Status.INVALID_KEY;
        }
    }

    public Map<String, String> toMap(FieldPartial fields) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.license != null) {
            if (fields == null) {
                fields = new FieldPartial(LicenseField.values());
            }
            for (LicenseField field : fields.getFields()) {
                parameters.put(field.getName(), field.extractValue(this));
            }
        }
        return parameters;
    }

    public String getLicenseUserName() {
        return this.licenseUserName;
    }

    public License getLicense() {
        return this.license;
    }

    private void assertCheckerNotNull() {
        if (this.license == null) {
            throw new IllegalStateException("Cannot get property of invalid license key.");
        }
    }

    public boolean isGuestBanForbidden() {
        this.assertCheckerNotNull();
        return this.license.isGuestBanForbidden();
    }

    public ProductInfo getProductType() {
        this.assertCheckerNotNull();
        return ProductInfo.parseProductType(this.license.getProduct().getType());
    }

    public int getProductMajorVersion() {
        this.assertCheckerNotNull();
        return this.license.getMajorVersion();
    }

    public int getProductMinorVersion() {
        this.assertCheckerNotNull();
        return this.license.getMinorVersion();
    }

    public BuildNumber getBuildNumber() {
        this.assertCheckerNotNull();
        return BuildNumber.parseBuildNumber(this.license.getBuildNumber());
    }

    public LicenseType getLicenseType() {
        this.assertCheckerNotNull();
        return LicenseType.parseLicenseType(this.license.getLicenseType().getType());
    }

    public String getExpirationTimeString() {
        long expirationTime = this.license.getExpirationTime();
        if (expirationTime == Long.MAX_VALUE) {
            return "Unlimited";
        }
        return new Date(expirationTime).toString();
    }

    public long getExpirationTime() {
        this.assertCheckerNotNull();
        return this.license.getExpirationTime();
    }

    public String getRenewalTimeString() {
        long renewalTime = this.license.getUpgradeExpirationTime();
        if (renewalTime == Long.MAX_VALUE) {
            return "Unlimited";
        }
        return new Date(renewalTime).toString();
    }

    public long getRenewalTime() {
        this.assertCheckerNotNull();
        return this.license.getUpgradeExpirationTime();
    }

    public int getMaxUsersCount() {
        this.assertCheckerNotNull();
        return this.license.getUserCount();
    }

    public long getMaxIssuesCount() {
        this.assertCheckerNotNull();
        return this.license.getIssueCount();
    }

    public int getMaxProjectsCount() {
        this.assertCheckerNotNull();
        return this.license.getProjectCount();
    }

    public boolean getUserCanChangeLogo() {
        this.assertCheckerNotNull();
        return !this.license.isLogoChangeForbidden();
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        OK,
        INVALID_KEY,
        INVALID_USER_NAME,
        INVALID_LICENSE_TYPE,
        EXPIRED,
        FREE_UPGRADE_PERIOD_EXPIRED,
        GENERATION_DATE_IN_FUTURE,
        HOSTED_SOLUTION,
        INVALID_PRODUCT_TYPE,
        INVALID_BUILD_NUMBER,
        INVALID_VERSION;

    }
}

