/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SecureMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleDefaults {
    private String logsDir;
    private String dataDir;
    private String backupsDir;
    private String tempDir;
    private String rootUser;
    private String rootPassword;
    private String bundleListenPort;
    private String locale;
    private String baseUrl;
    private boolean disableInternalHub;
    private boolean allowAnonymousAccess;
    private String tlsServerCertKeyStorePassword;
    private String tlsServerCertKeyStoreKeyAlias;
    private String tlsServerCertKeyStoreKeyPassword;
    private String tlsRedirectionFromHttpFlag;
    private String tlsRedirectionFromHttpListenPort;
    private boolean useOldServerCertFlag;
    @NotNull
    private SecureContent secureContent;
    @NotNull
    private ServerConnectorModeSettings serverConnectorModeSettings;

    public String getLogsDir() {
        return this.logsDir;
    }

    public void setLogsDir(String logsDir) {
        this.logsDir = logsDir;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getBackupsDir() {
        return this.backupsDir;
    }

    public void setBackupsDir(String backupsDir) {
        this.backupsDir = backupsDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getRootUser() {
        return this.rootUser;
    }

    public void setRootUser(String rootUser) {
        this.rootUser = rootUser;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getBundleListenPort() {
        return this.bundleListenPort;
    }

    public void setBundleListenPort(String listenPort) {
        this.bundleListenPort = listenPort;
    }

    public String getListenAddress() {
        return this.serverConnectorModeSettings.getListenAddress();
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isDisableInternalHub() {
        return this.disableInternalHub;
    }

    public void setDisableInternalHub(boolean disableInternalHub) {
        this.disableInternalHub = disableInternalHub;
    }

    public boolean getAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public String getFromDefaultsIfNull(@Nullable String propertyValue, @NotNull String propertyName) {
        if (propertyValue == null) {
            propertyValue = this.getStringPropertyByName(propertyName);
        }
        return propertyValue;
    }

    public String getStringPropertyByName(@NotNull String name) {
        if (BundleProperty.DATA_DIR.getName().equals(name)) {
            return this.getDataDir();
        }
        if (BundleProperty.BACKUPS_DIR.getName().equals(name)) {
            return this.getBackupsDir();
        }
        if (BundleProperty.LOGS_DIR.getName().equals(name)) {
            return this.getLogsDir();
        }
        if (BundleProperty.TEMP_DIR.getName().equals(name)) {
            return this.getTempDir();
        }
        if (BundleProperty.BASE_URL.getName().equals(name)) {
            return this.getBaseUrl();
        }
        if (BundleProperty.LISTEN_PORT.getName().equals(name)) {
            return this.getBundleListenPort();
        }
        if (BundleProperty.LISTEN_ADDRESS.getName().equals(name)) {
            return this.getListenAddress();
        }
        if (BundleProperty.ROOT_USER.getName().equals(name)) {
            return this.getRootUser();
        }
        if (BundleProperty.LOCALE.getName().equals(name)) {
            return this.getLocale();
        }
        if (BundleProperty.ROOT_PASSWORD.getName().equals(name)) {
            return this.getRootPassword();
        }
        if (BundleProperty.SECURE_MODE.getName().equals(name)) {
            return this.getSecureMode().getName();
        }
        if (BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD.getName().equals(name)) {
            return this.getTlsServerCertKeyStorePassword();
        }
        if (BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS.getName().equals(name)) {
            return this.getTlsServerCertKeyStoreKeyAlias();
        }
        if (BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD.getName().equals(name)) {
            return this.getTlsServerCertKeyStoreKeyPassword();
        }
        if (BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName().equals(name)) {
            return this.getTlsRedirectionFromHttpFlag();
        }
        if (BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName().equals(name)) {
            return this.getTlsRedirectionFromHttpListenPort();
        }
        if ("defaultNonSecureListenPort".equals(name)) {
            return this.getServerConnectorModeSettings().getDefaultNonSecureListenPort();
        }
        if ("defaultSecureListenPort".equals(name)) {
            return this.getServerConnectorModeSettings().getDefaultSecureListenPort();
        }
        if ("useOldServerCertFlag".equals(name)) {
            return String.valueOf(this.isUseOldServerCertFlag());
        }
        throw new UnsupportedOperationException("Property '" + name + "' not supported!");
    }

    public Boolean getBooleanPropertyByName(@NotNull String name) {
        if (BundleProperty.constructDisableServiceProperty((String)"hub", (boolean)false).equals(name)) {
            return this.isDisableInternalHub();
        }
        if (BundleProperty.ALLOW_ANONYMOUS_ACCESS.getName().equals(name)) {
            return this.getAllowAnonymousAccess();
        }
        throw new UnsupportedOperationException("Property '" + name + "' not supported!");
    }

    @NotNull
    public SecureMode getSecureMode() {
        return this.getServerConnectorModeSettings().getSecureMode();
    }

    public boolean isUseOldServerCertFlag() {
        return this.useOldServerCertFlag;
    }

    public void setUseOldServerCertFlag(boolean useOldServerCertFlag) {
        this.useOldServerCertFlag = useOldServerCertFlag;
    }

    @NotNull
    public SecureContent getSecureContent() {
        return this.secureContent;
    }

    public void setSecureContent(@NotNull SecureContent secureContent) {
        this.secureContent = secureContent;
    }

    @NotNull
    public ServerConnectorModeSettings getServerConnectorModeSettings() {
        return this.serverConnectorModeSettings;
    }

    public void setServerConnectorModeSettings(@NotNull ServerConnectorModeSettings serverConnectorModeSettings) {
        this.serverConnectorModeSettings = serverConnectorModeSettings;
    }

    public String getTlsServerCertKeyStorePassword() {
        return this.tlsServerCertKeyStorePassword;
    }

    public void setTlsServerCertKeyStorePassword(String tlsServerCertKeyStorePassword) {
        this.tlsServerCertKeyStorePassword = tlsServerCertKeyStorePassword;
    }

    public String getTlsServerCertKeyStoreKeyAlias() {
        return this.tlsServerCertKeyStoreKeyAlias;
    }

    public void setTlsServerCertKeyStoreKeyAlias(String tlsServerCertKeyStoreKeyAlias) {
        this.tlsServerCertKeyStoreKeyAlias = tlsServerCertKeyStoreKeyAlias;
    }

    public String getTlsServerCertKeyStoreKeyPassword() {
        return this.tlsServerCertKeyStoreKeyPassword;
    }

    public void setTlsServerCertKeyStoreKeyPassword(String tlsServerCertKeyStoreKeyPassword) {
        this.tlsServerCertKeyStoreKeyPassword = tlsServerCertKeyStoreKeyPassword;
    }

    public String getTlsRedirectionFromHttpFlag() {
        return this.tlsRedirectionFromHttpFlag;
    }

    public void setTlsRedirectionFromHttpFlag(String tlsRedirectionFromHttpFlag) {
        this.tlsRedirectionFromHttpFlag = tlsRedirectionFromHttpFlag;
    }

    public String getTlsRedirectionFromHttpListenPort() {
        return this.tlsRedirectionFromHttpListenPort;
    }

    public void setTlsRedirectionFromHttpListenPort(String tlsRedirectionFromHttpListenPort) {
        this.tlsRedirectionFromHttpListenPort = tlsRedirectionFromHttpListenPort;
    }
}

