/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.bundle.util.tls.KeyStoreGenerationException;
import com.jetbrains.bundle.util.tls.KeyStoreGenerator;
import com.jetbrains.bundle.util.tls.PemPrivateKeyLoader;
import com.jetbrains.bundle.util.tls.PrivateKeyDecryptionException;
import com.jetbrains.installer.model.KeyStoreContent;
import com.jetbrains.installer.model.KeyStoreHolder;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyCertContent
extends SecureContent {
    private static final String BUNDLE_PRIVATE_KEY_PASSPHRASE_PROPERTY = "bundle.tls-server-cert-private-key-passphrase";
    public static final String PRIVATE_KEY = "privateKey";
    private static final String PRIVATE_KEY_PASSPHRASE = "privateKeyPassphrase";
    public static final String CERTIFICATE = "certificate";
    public static final String CERTIFICATE_CHAIN = "certificateChain";
    @JsonProperty(value="privateKey")
    private String privateKey;
    @JsonProperty(value="privateKeyPassphrase")
    @BlockProperty(value="bundle.tls-server-cert-private-key-passphrase")
    private String passphrase;
    @JsonProperty(value="certificate")
    private String certificate;
    @JsonProperty(value="certificateChain")
    private String certificateChain;

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Override
    CertificateInfo doValidate(@NotNull ValidationResult result) {
        return this.validPrivateKeyAndCertificate(this.privateKey, this.passphrase, this.certificate, this.certificateChain, result);
    }

    @Override
    public SecureContent createEmptyContent() {
        return new KeyCertContent();
    }

    @Override
    public Collection<ErrorInfo> clearSecureEmptyFieldsErrors(@NotNull ValidationResult result) {
        if (StringUtils.isEmpty((String)this.privateKey) && StringUtils.isEmpty((String)this.certificate) && StringUtils.isEmpty((String)this.certificateChain) && StringUtils.isEmpty((String)this.passphrase)) {
            return result.removeErrorForFields(Arrays.asList(PRIVATE_KEY, CERTIFICATE, CERTIFICATE_CHAIN, PRIVATE_KEY_PASSPHRASE));
        }
        return Collections.emptySet();
    }

    @Override
    public void addCertificateExpiredError(@NotNull X509Certificate certificate, boolean isChain, @NotNull ValidationResult result) {
        String jsonFieldRelatedToError = isChain ? CERTIFICATE_CHAIN : CERTIFICATE;
        Map<String, String> parameters = Collections.singletonMap("NotAfter", this.getDateFormat().format(certificate.getNotAfter()));
        result.addError(ValidationError.CERTIFICATE_EXPIRED.toErrorInfo(parameters, jsonFieldRelatedToError));
    }

    @Override
    public void addCertificateNotYetValidError(@NotNull X509Certificate certificate, boolean isChain, @NotNull ValidationResult result) {
        String jsonFieldRelatedToError = isChain ? CERTIFICATE_CHAIN : CERTIFICATE;
        Map<String, String> parameters = Collections.singletonMap("NotBefore", this.getDateFormat().format(certificate.getNotBefore()));
        result.addError(ValidationError.CERTIFICATE_NOT_YET_VALID.toErrorInfo(parameters, jsonFieldRelatedToError));
    }

    @Override
    @NotNull
    public KeyStoreHolder buildKeyStore() {
        ValidationResult result = new ValidationResult();
        if (StringUtils.isEmpty((String)this.privateKey)) {
            result.addError(ValidationError.PRIVATE_KEY_IS_NOT_UPLOADED.toErrorInfo(PRIVATE_KEY));
        }
        if (StringUtils.isEmpty((String)this.certificate)) {
            result.addError(ValidationError.CERTIFICATE_IS_NOT_UPLOADED.toErrorInfo(CERTIFICATE));
        }
        if (result.hasErrors()) {
            throw new ValidationException(result);
        }
        return this.buildKeyStore(this.privateKey, this.passphrase, this.certificate, this.certificateChain);
    }

    @Override
    public void dumpSecureFiles(@NotNull Properties properties, @NotNull WizardBackendConfig wizardBackendConfig) throws IOException {
        if (this.privateKey != null && this.certificate != null) {
            this.dumpPrivateKeyAndCert(properties, wizardBackendConfig, this.privateKey, this.certificate, this.certificateChain);
        }
    }

    @Override
    String getFieldAssociatedWithDumpSecureFilesError() {
        return PRIVATE_KEY;
    }

    private CertificateInfo validPrivateKeyAndCertificate(String privateKey, String privateKeyPassphrase, String certificate, String certificateChain, @NotNull ValidationResult result) {
        if (StringUtils.isEmpty((String)privateKey) || StringUtils.isEmpty((String)certificate)) {
            if (StringUtils.isEmpty((String)privateKey)) {
                result.addError(ValidationError.PRIVATE_KEY_IS_NOT_UPLOADED.toErrorInfo(PRIVATE_KEY));
            }
            if (StringUtils.isEmpty((String)certificate)) {
                result.addError(ValidationError.CERTIFICATE_IS_NOT_UPLOADED.toErrorInfo(CERTIFICATE));
            }
            return null;
        }
        byte[] privateKeyBytes = privateKey.getBytes();
        byte[] certificateBytes = certificate.getBytes();
        PrivateKey privateKeyToValidate = this.validatePrivateKey(privateKeyBytes, privateKeyPassphrase, result);
        X509Certificate certificateToValidate = this.validateCertificate(certificateBytes, false, result);
        X509Certificate certificateChainToValidate = null;
        if (StringUtils.isNotEmpty((String)certificateChain)) {
            byte[] certificateChainBytes = certificateChain.getBytes();
            certificateChainToValidate = this.validateCertificate(certificateChainBytes, true, result);
        }
        if (certificateToValidate != null && privateKeyToValidate != null) {
            this.validateEquivalentKeyAndCertificate(privateKeyToValidate, certificateToValidate, certificateChainToValidate, result);
        }
        return this.getCertificateInfo(certificateToValidate, result, CERTIFICATE);
    }

    @Nullable
    private PrivateKey validatePrivateKey(@NotNull byte[] privateKeyBytes, @Nullable String passphrase, @NotNull ValidationResult result) {
        PrivateKey privateKey = null;
        try {
            PemPrivateKeyLoader pemPrivateKeyLoader = new PemPrivateKeyLoader(privateKeyBytes, passphrase);
            privateKey = pemPrivateKeyLoader.load();
            if (privateKey == null) {
                result.addError(ValidationError.PRIVATE_KEY_INVALID_NO_DETAILS.toErrorInfo(PRIVATE_KEY));
            }
        }
        catch (PrivateKeyDecryptionException e) {
            if (passphrase == null || passphrase.trim().length() == 0) {
                String errorMessage = "Passphrase for private key is not defined";
                result.addError(ValidationError.PRIVATE_KEY_DECRYPTION_FAILED.toErrorInfo(Collections.singletonMap("message", errorMessage), PRIVATE_KEY_PASSPHRASE));
                result.addError(ValidationError.PRIVATE_KEY_DECRYPTION_FAILED.toErrorInfo(Collections.singletonMap("message", errorMessage), PRIVATE_KEY));
            } else {
                result.addError(ValidationError.PRIVATE_KEY_DECRYPTION_FAILED.toErrorInfo(Collections.singletonMap("message", e.getCause().getMessage()), PRIVATE_KEY));
            }
        }
        catch (Exception e) {
            result.addError(ValidationError.PRIVATE_KEY_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), PRIVATE_KEY));
        }
        return privateKey;
    }

    private void validateEquivalentKeyAndCertificate(@NotNull PrivateKey privateKeyToValidate, @NotNull X509Certificate certificateToValidate, @Nullable X509Certificate certificateChainToValidate, @NotNull ValidationResult result) {
        boolean doesPrivateKeyMatchCert;
        PublicKey publicKeyFromCert = certificateToValidate.getPublicKey();
        if (privateKeyToValidate instanceof RSAPrivateCrtKey) {
            try {
                RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)privateKeyToValidate;
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(privateKey.getModulus(), privateKey.getPublicExponent());
                PublicKey publicKeyDerivedFromPrivateKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
                doesPrivateKeyMatchCert = publicKeyFromCert.equals(publicKeyDerivedFromPrivateKey);
            }
            catch (Exception e) {
                result.addError(ValidationError.CANNOT_GENERATE_PUBLIC_KEY_FROM_PRIVATE_KEY.toErrorInfo(Collections.singletonMap("message", e.getMessage()), PRIVATE_KEY));
                return;
            }
        } else if (privateKeyToValidate instanceof DSAPrivateKey) {
            DSAPrivateKey privateKey = (DSAPrivateKey)privateKeyToValidate;
            doesPrivateKeyMatchCert = publicKeyFromCert instanceof DSAPublicKey && this.areDsaParamsEqual(((DSAPublicKey)publicKeyFromCert).getParams(), privateKey.getParams());
        } else if (privateKeyToValidate instanceof ECPrivateKey) {
            ECPrivateKey privateKey = (ECPrivateKey)privateKeyToValidate;
            doesPrivateKeyMatchCert = publicKeyFromCert instanceof ECPublicKey && this.areEcParamsEqual(((ECPublicKey)publicKeyFromCert).getParams(), privateKey.getParams());
        } else {
            result.addError(ValidationError.UNSUPPORTED_PRIVATE_KEY_TYPE.toErrorInfo(Collections.singletonMap("type", "Unsupported private key type: " + privateKeyToValidate.getClass().getName()), PRIVATE_KEY));
            return;
        }
        if (!doesPrivateKeyMatchCert) {
            result.addError(ValidationError.PRIVATE_KEY_AND_CERTIFICATE_SHOULD_MATCH.toErrorInfo(PRIVATE_KEY));
            result.addError(ValidationError.PRIVATE_KEY_AND_CERTIFICATE_SHOULD_MATCH.toErrorInfo(CERTIFICATE));
        }
        if (certificateChainToValidate != null) {
            try {
                certificateToValidate.verify(certificateChainToValidate.getPublicKey());
            }
            catch (Exception e) {
                result.addError(ValidationError.CERTIFICATE_AND_CERTIFICATE_CHAIN_SHOULD_MATCH.toErrorInfo(CERTIFICATE));
                result.addError(ValidationError.CERTIFICATE_AND_CERTIFICATE_CHAIN_SHOULD_MATCH.toErrorInfo(CERTIFICATE_CHAIN));
            }
        }
    }

    @Override
    @Nullable
    public X509Certificate getParsedCertificate() throws CertificateException, IOException {
        return this.certificate != null ? this.getParsedCertificate(this.certificate.getBytes()) : null;
    }

    @NotNull
    private X509Certificate getParsedCertificate(@NotNull byte[] certificateBytes) throws CertificateException, IOException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateBytes);){
            X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(inputStream);
            return x509Certificate;
        }
    }

    private boolean areDsaParamsEqual(@NotNull DSAParams one, @NotNull DSAParams another) {
        return Objects.equals(one.getP(), another.getP()) && Objects.equals(one.getQ(), another.getQ()) && Objects.equals(one.getG(), another.getG());
    }

    private boolean areEcParamsEqual(@NotNull ECParameterSpec one, @NotNull ECParameterSpec another) {
        return Objects.equals(one.getCofactor(), another.getCofactor()) && Objects.equals(one.getCurve(), another.getCurve()) && Objects.equals(one.getGenerator(), another.getGenerator()) && Objects.equals(one.getOrder(), another.getOrder());
    }

    @NotNull
    private KeyStoreHolder buildKeyStore(@NotNull String privateKey, @Nullable String privateKeyPassphrase, @NotNull String certificate, @Nullable String certificateChain) {
        KeyStore keyStore;
        String keystorePassword = "password";
        String keyAlias = "alias";
        try {
            keyStore = KeyStoreGenerator.generate((Path)Paths.get("notExistingPathForValidationEndpointCase", new String[0]), (String)"password", (String)"alias", (byte[])privateKey.getBytes(), (String)privateKeyPassphrase, (byte[])certificate.getBytes(), certificateChain != null && certificateChain.length() != 0 ? certificateChain.getBytes() : null);
        }
        catch (KeyStoreGenerationException e) {
            this.LOG.debug("Keystore generation error", (Throwable)e);
            ValidationResult result = new ValidationResult();
            result.addError(ValidationError.KEYSTORE_FAILED_TO_GENERATE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), PRIVATE_KEY));
            throw new ValidationException(result);
        }
        return new KeyStoreHolder(keyStore, new KeyStoreContent.KeyStoreInfo("password", "alias", "password"));
    }

    private void dumpPrivateKeyAndCert(@NotNull Properties properties, @NotNull WizardBackendConfig wizardBackendConfig, @NotNull String privateKey, @NotNull String certificate, @Nullable String certificateChain) throws IOException {
        Path oldKeyStoreFile;
        Path oldKeyStoreDir;
        Path filePrivateKey = BundleEnvironment.getUploadPrivateKeyPath((Path)wizardBackendConfig.getConfDir());
        Path fileCertificate = BundleEnvironment.getUploadCertificatePath((Path)wizardBackendConfig.getConfDir());
        Path fileCertificateChain = BundleEnvironment.getUploadCertificateChainPath((Path)wizardBackendConfig.getConfDir());
        Path privateKeyAndCertDir = filePrivateKey.getParent();
        if (Files.isDirectory(privateKeyAndCertDir, new LinkOption[0]) && Files.exists(privateKeyAndCertDir, new LinkOption[0])) {
            FileUtils.cleanDirectory((File)privateKeyAndCertDir.toFile());
        }
        if (!Files.exists(privateKeyAndCertDir, new LinkOption[0])) {
            Files.createDirectories(privateKeyAndCertDir, new FileAttribute[0]);
        }
        Files.write(filePrivateKey, privateKey.getBytes(), new OpenOption[0]);
        properties.setProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE.getPrefixedName(), filePrivateKey.toString());
        Files.write(fileCertificate, certificate.getBytes(), new OpenOption[0]);
        properties.setProperty(BundleProperty.TLS_SERVER_CERT_FILE.getPrefixedName(), fileCertificate.toString());
        if (StringUtils.isNotEmpty((String)certificateChain)) {
            Files.write(fileCertificateChain, certificateChain.getBytes(), new OpenOption[0]);
            properties.setProperty(BundleProperty.TLS_SERVER_CERT_CHAIN_FILE.getPrefixedName(), fileCertificateChain.toString());
        }
        if (Files.isDirectory(oldKeyStoreDir = (oldKeyStoreFile = BundleEnvironment.getUploadKeyStorePath((Path)wizardBackendConfig.getConfDir())).getParent(), new LinkOption[0]) && Files.exists(oldKeyStoreDir, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)oldKeyStoreDir.toFile());
        }
    }

    @Nullable
    private X509Certificate validateCertificate(@NotNull byte[] certificateBytes, boolean isChain, @NotNull ValidationResult result) {
        X509Certificate certificate;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateBytes);){
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)fact.generateCertificate(inputStream);
        }
        catch (IOException | CertificateException e) {
            this.addCertificateInvalidError(isChain, result, e);
            return null;
        }
        this.validateCertificate(certificate, isChain, result);
        return certificate;
    }

    private void addCertificateInvalidError(boolean isChain, @NotNull ValidationResult result, Exception e) {
        if (!isChain) {
            result.addError(ValidationError.CERTIFICATE_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), CERTIFICATE));
        } else {
            result.addError(ValidationError.CERTIFICATE_CHAIN_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), CERTIFICATE_CHAIN));
        }
    }
}

