/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.KeyStoreHolder;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyStoreContent
extends SecureContent {
    private static final String BUNDLE_SECURE_KEYSTORE_ALIAS_PROPERTY = "bundle.tls-server-cert-keystore-key-alias";
    private static final String BUNDLE_SECURE_ALIAS_PASSWORD_PROPERTY = "bundle.tls-server-cert-keystore-key-password";
    private static final String BUNDLE_SECURE_KEYSTORE_PASSWORD_PROPERTY = "bundle.tls-server-cert-keystore-password";
    public static final String KEYSTORE_FILE_NAME = "keyStoreFileName";
    private static final String KEYSTORE_FILE = "keyStoreFile";
    private static final String SECURE_KEYSTORE_PASSWORD_PROPERTY = "secureKeyStorePassword";
    private static final String SECURE_KEYSTORE_ALIAS_PROPERTY = "secureKeyStoreAlias";
    private static final String SECURE_ALIAS_PASSWORD_PROPERTY = "aliasPassword";
    @JsonProperty(value="keyStoreFile")
    private String keyStoreFile;
    @JsonProperty(value="keyStoreFileName")
    private String keyStoreFileName;
    @BlockProperty(value="bundle.tls-server-cert-keystore-password")
    @JsonProperty(value="secureKeyStorePassword")
    private String secureKeystorePassword;
    @BlockProperty(value="bundle.tls-server-cert-keystore-key-alias")
    @JsonProperty(value="secureKeyStoreAlias")
    private String secureKeyStoreAlias;
    @BlockProperty(value="bundle.tls-server-cert-keystore-key-password")
    @JsonProperty(value="aliasPassword")
    private String aliasPassword;

    public KeyStoreContent() {
    }

    public KeyStoreContent(String keyStoreFile, String keyStoreFileName, String secureKeystorePassword, String secureKeyStoreAlias, String aliasPassword) {
        this.keyStoreFile = keyStoreFile;
        this.keyStoreFileName = keyStoreFileName;
        this.secureKeystorePassword = secureKeystorePassword;
        this.secureKeyStoreAlias = secureKeyStoreAlias;
        this.aliasPassword = aliasPassword;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
    }

    public String getSecureKeystorePassword() {
        return this.secureKeystorePassword;
    }

    public void setSecureKeystorePassword(String secureKeystorePassword) {
        this.secureKeystorePassword = secureKeystorePassword;
    }

    public String getSecureKeyStoreAlias() {
        return this.secureKeyStoreAlias;
    }

    public void setSecureKeyStoreAlias(String secureKeyStoreAlias) {
        this.secureKeyStoreAlias = secureKeyStoreAlias;
    }

    public String getAliasPassword() {
        return this.aliasPassword;
    }

    public void setAliasPassword(String aliasPassword) {
        this.aliasPassword = aliasPassword;
    }

    @Override
    CertificateInfo doValidate(@NotNull ValidationResult result) {
        return this.validateKeyStore(result);
    }

    @Override
    public SecureContent createEmptyContent() {
        return new KeyStoreContent();
    }

    private Collection<ErrorInfo> clearSecureErrors(@NotNull ValidationResult result) {
        return result.removeErrorForFields(Arrays.asList(KEYSTORE_FILE, KEYSTORE_FILE_NAME, SECURE_KEYSTORE_PASSWORD_PROPERTY, SECURE_KEYSTORE_ALIAS_PROPERTY, SECURE_ALIAS_PASSWORD_PROPERTY));
    }

    @Override
    public Collection<ErrorInfo> clearSecureEmptyFieldsErrors(@NotNull ValidationResult result) {
        if (StringUtils.isEmpty((CharSequence)this.keyStoreFile) && StringUtils.isEmpty((CharSequence)this.keyStoreFileName) && StringUtils.isEmpty((CharSequence)this.secureKeystorePassword) && StringUtils.isEmpty((CharSequence)this.secureKeyStoreAlias) && StringUtils.isEmpty((CharSequence)this.aliasPassword)) {
            return this.clearSecureErrors(result);
        }
        return Collections.emptySet();
    }

    @Override
    public void addCertificateExpiredError(@NotNull X509Certificate certificate, boolean isChain, @NotNull ValidationResult result) {
        result.addError(ValidationError.CERTIFICATE_IN_KEYSTORE_EXPIRED.toErrorInfo(Collections.singletonMap("NotAfter", this.getDateFormat().format(certificate.getNotAfter())), KEYSTORE_FILE_NAME));
    }

    @Override
    public void addCertificateNotYetValidError(@NotNull X509Certificate certificate, boolean isChain, @NotNull ValidationResult result) {
        result.addError(ValidationError.CERTIFICATE_IN_KEYSTORE_NOT_YET_VALID.toErrorInfo(Collections.singletonMap("NotBefore", this.getDateFormat().format(certificate.getNotBefore())), KEYSTORE_FILE_NAME));
    }

    @Nullable
    private KeyStoreInfo resolveKeyStoreInfo(@NotNull ValidationResult result) {
        if (StringUtils.isEmpty((CharSequence)this.keyStoreFile)) {
            result.addError(ValidationError.KEYSTORE_FILE_IS_NOT_UPLOADED.toErrorInfo(KEYSTORE_FILE_NAME));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.secureKeyStoreAlias)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo(SECURE_KEYSTORE_ALIAS_PROPERTY));
        }
        if (result.hasErrors()) {
            return null;
        }
        return new KeyStoreInfo(this.secureKeystorePassword != null ? this.secureKeystorePassword : "", this.secureKeyStoreAlias, this.aliasPassword != null ? this.aliasPassword : "");
    }

    private CertificateInfo validateKeyStore(@NotNull ValidationResult result) {
        if (this.keyStoreFile == null) {
            result.addError(ValidationError.KEYSTORE_FILE_IS_NOT_UPLOADED.toErrorInfo(KEYSTORE_FILE_NAME));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.keyStoreFile)) {
            result.addError(ValidationError.KEYSTORE_FILE_IS_EMPTY.toErrorInfo(KEYSTORE_FILE_NAME));
            return null;
        }
        String keyStorePassword = this.secureKeystorePassword != null ? this.secureKeystorePassword : "";
        KeyStore keyStore = KeyStoreContent.loadKeyStore(this.keyStoreFile, keyStorePassword, result);
        if (keyStore == null) {
            if (!result.hasErrors()) {
                throw new IllegalStateException("Keystore silently failed to load");
            }
            return null;
        }
        if (result.hasErrors()) {
            return null;
        }
        X509Certificate certificate = this.loadCertificate(this.secureKeyStoreAlias, keyStore, result);
        if (result.hasErrors()) {
            return null;
        }
        if (certificate == null) {
            if (StringUtils.isEmpty((CharSequence)this.secureKeyStoreAlias)) {
                result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo(SECURE_KEYSTORE_ALIAS_PROPERTY));
            } else {
                result.addError(ValidationError.NO_EXIST_ALIAS.toErrorInfo(SECURE_KEYSTORE_ALIAS_PROPERTY));
            }
            return null;
        }
        this.validateCertificate(certificate, false, result);
        try {
            Key privateKey;
            if (StringUtils.isEmpty((CharSequence)this.aliasPassword)) {
                try {
                    privateKey = keyStore.getKey(this.secureKeyStoreAlias, keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    privateKey = keyStore.getKey(this.secureKeyStoreAlias, "".toCharArray());
                }
            } else {
                privateKey = keyStore.getKey(this.secureKeyStoreAlias, this.aliasPassword.toCharArray());
            }
            if (privateKey == null) {
                result.addError(ValidationError.ALIAS_DOES_NOT_IDENTIFY_ANY_PRIVATE_KEY.toErrorInfo(SECURE_KEYSTORE_ALIAS_PROPERTY));
            }
        }
        catch (Exception e) {
            result.addError(ValidationError.WRONG_ALIAS_PASSWORD.toErrorInfo(SECURE_ALIAS_PASSWORD_PROPERTY));
        }
        return this.getCertificateInfo(certificate, result, KEYSTORE_FILE_NAME);
    }

    @Override
    @NotNull
    public KeyStoreHolder buildKeyStore() throws KeyStoreException {
        ValidationResult result = new ValidationResult();
        KeyStoreHolder keystoreHolder = this.resolveKeyStore(result);
        Enumeration<String> aliases = keystoreHolder.getKeyStore().aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (alias.equalsIgnoreCase(keystoreHolder.getKeyAlias())) continue;
            keystoreHolder.getKeyStore().deleteEntry(alias);
        }
        return keystoreHolder;
    }

    @NotNull
    private KeyStoreHolder resolveKeyStore(@NotNull ValidationResult result) {
        KeyStoreInfo keyStoreInfo = this.resolveKeyStoreInfo(result);
        if (keyStoreInfo == null) {
            if (!result.hasErrors()) {
                throw new IllegalStateException("Keystore info silently failed to resolve");
            }
            throw new ValidationException(result);
        }
        KeyStore keyStore = KeyStoreContent.loadKeyStore(this.keyStoreFile, keyStoreInfo.password, result);
        if (keyStore == null) {
            if (!result.hasErrors()) {
                throw new IllegalStateException("Keystore silently failed to load");
            }
            throw new ValidationException(result);
        }
        return new KeyStoreHolder(keyStore, keyStoreInfo);
    }

    private X509Certificate loadCertificate(@Nullable String alias, @Nullable KeyStore keyStore, @NotNull ValidationResult result) {
        X509Certificate certificate;
        if (keyStore == null) {
            return null;
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)alias)) {
                certificate = (X509Certificate)keyStore.getCertificate(alias);
            } else {
                certificate = (X509Certificate)keyStore.getCertificate("1");
                if (certificate != null) {
                    this.setSecureKeyStoreAlias("1");
                }
            }
        }
        catch (Exception e) {
            result.addError(ValidationError.KEYSTORE_FILE_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), KEYSTORE_FILE_NAME));
            return null;
        }
        return certificate;
    }

    private static KeyStore loadKeyStore(@NotNull String keyStoreAsString, @Nullable String keyStorePassword, @NotNull ValidationResult result) {
        if (keyStorePassword == null) {
            keyStorePassword = "";
        }
        KeyStore keyStore = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.decode((String)keyStoreAsString));){
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            ErrorInfo errorInfo = e.getCause() instanceof UnrecoverableKeyException ? ValidationError.KEYSTORE_PASSWORD_INVALID.toErrorInfo(SECURE_KEYSTORE_PASSWORD_PROPERTY) : ValidationError.KEYSTORE_FILE_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), KEYSTORE_FILE_NAME);
            result.addError(errorInfo);
        }
        return keyStore;
    }

    @Override
    public void dumpSecureFiles(@NotNull Properties properties, @NotNull WizardBackendConfig wizardBackendConfig) throws IOException {
        if (this.keyStoreFile != null) {
            byte[] keystoreBytes = Base64.decode((String)this.keyStoreFile);
            Path fileKeystore = BundleEnvironment.getUploadKeyStorePath((Path)wizardBackendConfig.getConfDir());
            Path keystoreDir = fileKeystore.getParent();
            if (Files.isDirectory(keystoreDir, new LinkOption[0]) && Files.exists(keystoreDir, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)keystoreDir.toFile());
            }
            if (!Files.exists(keystoreDir, new LinkOption[0])) {
                Files.createDirectories(keystoreDir, new FileAttribute[0]);
            }
            Files.write(fileKeystore, keystoreBytes, new OpenOption[0]);
            properties.setProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE.getPrefixedName(), fileKeystore.toString());
            Path oldPrivateKeyFile = BundleEnvironment.getUploadPrivateKeyPath((Path)wizardBackendConfig.getConfDir());
            Path oldPrivateKeyDir = oldPrivateKeyFile.getParent();
            if (Files.isDirectory(oldPrivateKeyDir, new LinkOption[0]) && Files.exists(oldPrivateKeyDir, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)oldPrivateKeyDir.toFile());
            }
        }
    }

    @Override
    String getFieldAssociatedWithDumpSecureFilesError() {
        return KEYSTORE_FILE_NAME;
    }

    @Override
    @Nullable
    public X509Certificate getParsedCertificate() {
        if (StringUtils.isEmpty((CharSequence)this.keyStoreFile)) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        KeyStore keyStore = KeyStoreContent.loadKeyStore(this.keyStoreFile, this.secureKeystorePassword, result);
        X509Certificate certificate = this.loadCertificate(this.secureKeyStoreAlias, keyStore, result);
        if (certificate == null && result.hasErrors()) {
            throw new ValidationException(result);
        }
        return certificate;
    }

    static class KeyStoreInfo {
        @NotNull
        private final String password;
        @NotNull
        private final String alias;
        @NotNull
        private final String aliasPassword;

        KeyStoreInfo(@NotNull String password, @NotNull String alias, @NotNull String aliasPassword) {
            this.password = password;
            this.alias = alias;
            this.aliasPassword = aliasPassword;
        }

        @NotNull
        String getPassword() {
            return this.password;
        }

        @NotNull
        String getAlias() {
            return this.alias;
        }

        @NotNull
        String getAliasPassword() {
            return this.aliasPassword;
        }
    }
}

