/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class LicenseAgreementsInfo {
    private List<LicenseAgreementInfo> licenses = new ArrayList<LicenseAgreementInfo>();

    @JsonValue
    public LicenseAgreementInfo[] getLicenseAgreements() {
        return this.licenses.toArray(new LicenseAgreementInfo[this.licenses.size()]);
    }

    public void setLicenseAgreements(List<LicenseAgreementInfo> licenses) {
        this.licenses = licenses;
    }

    public static class LicenseAgreementInfo {
        @JsonProperty
        private String productName;
        @JsonIgnore
        private String documentPath;

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        @JsonProperty(value="document")
        public String getDocument() {
            Path path = Paths.get(this.documentPath, new String[0]);
            try {
                byte[] bytes = Files.readAllBytes(path);
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get license agreement content form file " + this.documentPath, e);
            }
        }

        public String getDocumentPath() {
            return this.documentPath;
        }

        public void setDocumentPath(String documentPath) {
            this.documentPath = documentPath;
        }
    }
}

