/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.StringUtils;

public class PathInfo {
    private static final IOCase IO_CASE = IOCase.SYSTEM;
    public static final String FILE_SEPARATOR = File.separator;
    private boolean isAbsolutePath = false;
    private String path = null;
    private String parent = null;
    private List<String> children = new ArrayList<String>();
    private List<String> roots = new ArrayList<String>();
    private int numOfRoots = 0;

    public static PathInfo getPathInfo(@Nullable String pathString, boolean showFiles, String ... fileExtensions) throws IOException {
        Path normalizedPath;
        String regExp = PathInfo.buildSuffixRegExp(fileExtensions);
        if (pathString == null) {
            return new PathInfo(null, null, showFiles, regExp);
        }
        Path path = Paths.get(pathString, new String[0]);
        if (!path.isAbsolute()) {
            return new PathInfo(null, pathString, showFiles, regExp);
        }
        Path parent = path;
        String prefix = null;
        if (!pathString.endsWith(FILE_SEPARATOR)) {
            parent = path.getParent();
            prefix = path.getFileName().toString();
        }
        if (Files.exists(parent, new LinkOption[0]) && Files.isDirectory(normalizedPath = PathInfo.normalizePath(parent), new LinkOption[0])) {
            return new PathInfo(normalizedPath, prefix, showFiles, regExp);
        }
        parent = PathInfo.getExistingNormalizedParentDirectory(parent);
        return new PathInfo(parent, null, showFiles, regExp);
    }

    @Nullable
    private static Path getExistingNormalizedParentDirectory(@NotNull Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return null;
        }
        do {
            Path normalizedParent;
            if (!Files.exists(parent, new LinkOption[0]) || !Files.isDirectory(normalizedParent = PathInfo.normalizePath(parent), new LinkOption[0])) continue;
            return normalizedParent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    private static String buildSuffixRegExp(String[] extensions) {
        if (extensions == null) {
            return null;
        }
        StringBuilder regExpString = new StringBuilder(".*(");
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            if (StringUtils.isEmpty((Object)extension)) continue;
            String quotedSuffix = Pattern.quote(extension);
            if (i > 0) {
                regExpString.append("|");
            }
            regExpString.append(quotedSuffix);
        }
        regExpString.append(")$");
        return regExpString.toString();
    }

    public PathInfo(@Nullable Path directoryPath, final @Nullable String prefix, final boolean showFiles, @Nullable String filesFilterRegExp) throws IOException {
        Iterable<Path> rootPaths = FileSystems.getDefault().getRootDirectories();
        for (Path rootPath : rootPaths) {
            this.roots.add(rootPath.toAbsolutePath().toString());
        }
        this.numOfRoots = this.roots.size();
        if (this.numOfRoots == 0) {
            return;
        }
        if (directoryPath == null) {
            if (prefix != null) {
                this.isAbsolutePath = Paths.get(prefix, new String[0]).isAbsolute();
                for (String root : this.roots) {
                    if (!this.isItemMatches(root, prefix)) continue;
                    this.isAbsolutePath = true;
                    String rootAsDirectory = root.endsWith(FILE_SEPARATOR) ? root : root + FILE_SEPARATOR;
                    this.children.add(rootAsDirectory);
                }
            } else {
                this.isAbsolutePath = true;
            }
            return;
        }
        this.isAbsolutePath = directoryPath.isAbsolute();
        if (!this.isAbsolutePath) {
            throw new IllegalArgumentException("Path must be absolute! " + directoryPath);
        }
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path does not exist! " + directoryPath);
        }
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path must be directory! " + directoryPath);
        }
        this.path = directoryPath.toString();
        this.parent = directoryPath.getParent() == null ? null : directoryPath.getParent().toString();
        Path normalizedDirectoryPath = PathInfo.normalizePath(directoryPath);
        Pattern pattern = null;
        if (filesFilterRegExp != null) {
            pattern = !IO_CASE.isCaseSensitive() ? Pattern.compile(filesFilterRegExp, 66) : Pattern.compile(filesFilterRegExp);
        }
        final Pattern filesFilterPattern = pattern;
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                Path normalizedPath = PathInfo.normalizePath(entry);
                if (!showFiles && !Files.isDirectory(normalizedPath, new LinkOption[0])) {
                    return false;
                }
                String fileNameString = entry.getFileName().toString();
                if (prefix != null && !PathInfo.this.isItemMatches(fileNameString, prefix)) {
                    return false;
                }
                if (showFiles && Files.isRegularFile(normalizedPath, new LinkOption[0]) && filesFilterPattern != null) {
                    Matcher matcher = filesFilterPattern.matcher(fileNameString);
                    return matcher.matches();
                }
                return true;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(normalizedDirectoryPath, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path item : stream) {
                String itemName = item.getFileName().toString();
                if (Files.isDirectory(PathInfo.normalizePath(normalizedDirectoryPath.resolve(item)), new LinkOption[0])) {
                    itemName = itemName + FILE_SEPARATOR;
                }
                this.children.add(itemName);
            }
            this.sortChildren();
        }
        catch (SecurityException | AccessDeniedException exception) {
            // empty catch block
        }
    }

    public static String ensureEndsAsDir(@Nullable String dirString) {
        if (dirString == null) {
            return null;
        }
        return StringUtils.trimTrailingCharacter((String)dirString, (char)File.separatorChar) + File.separatorChar;
    }

    private void sortChildren() {
        Collections.sort(this.children, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                if (name1.endsWith(FILE_SEPARATOR) && !name2.endsWith(FILE_SEPARATOR)) {
                    return -1;
                }
                if (!name1.endsWith(FILE_SEPARATOR) && name2.endsWith(FILE_SEPARATOR)) {
                    return 1;
                }
                return IO_CASE.checkCompareTo(name1, name2);
            }
        });
    }

    private boolean isItemMatches(@NotNull String itemName, @Nullable String prefix) {
        if (prefix == null) {
            return false;
        }
        return IO_CASE.checkStartsWith(itemName, prefix);
    }

    @NotNull
    private static Path normalizePath(@NotNull Path path) {
        try {
            return Paths.get(path.toFile().getCanonicalPath(), new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException ignore) {
            return path;
        }
    }

    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="separator")
    public String getSeparator() {
        return FILE_SEPARATOR;
    }

    public List<String> getChildren() {
        return this.children;
    }

    public String getParent() {
        return this.parent;
    }

    public int getNumOfRoots() {
        return this.numOfRoots;
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public boolean isAbsolutePath() {
        return this.isAbsolutePath;
    }
}

