/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.KeyCertContent;
import com.jetbrains.installer.model.KeyStoreContent;
import com.jetbrains.installer.model.KeyStoreHolder;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.AbstractDumpableBlock;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.validation.ValidationError;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="secureContentType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=KeyStoreContent.class, name="keystore"), @JsonSubTypes.Type(value=KeyCertContent.class, name="privateKeyAndCert")})
public abstract class SecureContent
extends AbstractDumpableBlock {
    private static final String CERTIFICATE_INFO = "certificateInfo";
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private CertificateInfo certificateInfo;

    @JsonProperty(value="certificateInfo")
    public CertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    @JsonIgnore
    public void setCertificateInfo(CertificateInfo certificateInfo) {
        throw new UnsupportedOperationException("certificateInfo is a read only field set during validation. Value received from frontend should never be deserialized since nested field certificateInfo->base64Der might be not parsable");
    }

    public CertificateInfo validate(@NotNull ValidationResult result) {
        this.certificateInfo = this.doValidate(result);
        return this.certificateInfo;
    }

    abstract CertificateInfo doValidate(@NotNull ValidationResult var1);

    public abstract SecureContent createEmptyContent();

    public abstract Collection<ErrorInfo> clearSecureEmptyFieldsErrors(@NotNull ValidationResult var1);

    public abstract void addCertificateExpiredError(@NotNull X509Certificate var1, boolean var2, @NotNull ValidationResult var3);

    public abstract void addCertificateNotYetValidError(@NotNull X509Certificate var1, boolean var2, @NotNull ValidationResult var3);

    void validateCertificate(@NotNull X509Certificate cert, boolean isChain, @NotNull ValidationResult result) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            this.addCertificateExpiredError(cert, isChain, result);
        }
        catch (CertificateNotYetValidException e) {
            this.addCertificateNotYetValidError(cert, isChain, result);
        }
    }

    @NotNull
    public abstract KeyStoreHolder buildKeyStore() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException;

    abstract void dumpSecureFiles(@NotNull Properties var1, @NotNull WizardBackendConfig var2) throws IOException;

    abstract String getFieldAssociatedWithDumpSecureFilesError();

    @Override
    public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
        super.dump(properties, dumpContext);
        try {
            this.dumpSecureFiles(properties, dumpContext.getWizardBackendConfig());
        }
        catch (IOException e) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError(ValidationError.SECURE_FILES_DUMP_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("message", e.getMessage()), this.getFieldAssociatedWithDumpSecureFilesError()));
            throw new ValidationException(validationResult);
        }
    }

    @Nullable
    CertificateInfo getCertificateInfo(@Nullable X509Certificate certificateToValidate, @NotNull ValidationResult result, @NotNull String jsonPropertyName) {
        try {
            return certificateToValidate != null ? new CertificateInfo(certificateToValidate) : null;
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            result.addError(ValidationError.CERTIFICATE_INVALID.toErrorInfo(Collections.singletonMap("message", e.getMessage()), jsonPropertyName));
            return null;
        }
    }

    SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("d MMM yyyy HH:mm z");
    }

    public abstract X509Certificate getParsedCertificate() throws CertificateException, IOException;
}

