/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.jetbrains.installer.license.WizardLicenseCheckResult;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.installer.model.blocks.HubBundleServiceInfo;
import com.jetbrains.installer.model.blocks.HubSettings;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.BasicSettingsValidator;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.HubSettingsValidator;
import com.jetbrains.installer.validation.UpgradeSettingsValidator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StepsInfo {
    @Resource(name="basicSettings")
    private BasicSettings basicSettings;
    @Autowired
    private BasicSettingsValidator basicSettingsValidator;
    @Resource(name="hubSettings")
    private HubSettings hubSettings;
    @Autowired
    private HubBundleServiceInfo hubBundleServiceInfo;
    @Autowired
    private HubSettingsValidator hubSettingsValidator;
    @Resource(name="upgradeSource")
    private UpgradeSource upgradeSource;
    @Autowired
    private BundleUpgradeHelper upgradeHelper;
    @Resource(name="upgradeSettings")
    private UpgradeSettings upgradeSettings;
    @Autowired
    private UpgradeSettingsValidator upgradeSettingsValidator;
    @Resource(name="licenseKeyInfo")
    private LicenseKeyInfo licenseKeyInfo;
    @JsonIgnore
    private Map<String, Step> steps = new TreeMap<String, Step>();
    private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());

    public StepsInfo() {
        this.steps.put("basic-settings", new BasicSettingsStep());
        this.steps.put("hub-settings", new HubSettingsStep());
        this.steps.put("license-key", new LicenseKeyStep());
        this.steps.put("upgrade-source", new UpgradeSourceStep());
        this.steps.put("upgrade-settings", new UpgradeSettingsStep());
    }

    @JsonValue
    public Step[] getSteps() {
        return this.steps.values().toArray(new Step[this.steps.values().size()]);
    }

    public void markChanged(String stepId) {
        Step step = this.steps.get(stepId);
        if (step != null) {
            step.markChanged();
        }
    }

    private class UpgradeSettingsStep
    extends Step {
        private UpgradeSettingsStep() {
            super("upgrade-settings");
        }

        @Override
        protected boolean checkCompleted() {
            UpgradeSource upgradeSource = StepsInfo.this.upgradeSettings.getUpgradeSource();
            return upgradeSource.getType() != null && upgradeSource.getSourceLocation() != null && !StepsInfo.this.upgradeSettingsValidator.validate(StepsInfo.this.upgradeSettings).hasErrors();
        }
    }

    private class UpgradeSourceStep
    extends Step {
        private UpgradeSourceStep() {
            super("upgrade-source");
        }

        @Override
        protected boolean checkCompleted() {
            return !StepsInfo.this.upgradeHelper.validate(StepsInfo.this.upgradeSource.getType(), StepsInfo.this.upgradeSource.getSourceLocation()).getValidationResult().hasErrors();
        }
    }

    private class LicenseKeyStep
    extends Step {
        private LicenseKeyStep() {
            super("license-key");
        }

        @Override
        public boolean isCompleted() {
            return this.checkCompleted();
        }

        @Override
        protected boolean checkCompleted() {
            return StepsInfo.this.licenseKeyInfo.getKey().getStatus() == WizardLicenseCheckResult.Status.OK;
        }
    }

    private class HubSettingsStep
    extends Step {
        private HubSettingsStep() {
            super("hub-settings");
        }

        @Override
        protected boolean checkCompleted() {
            return !StepsInfo.this.hubSettingsValidator.validate(StepsInfo.this.hubSettings, StepsInfo.this.hubBundleServiceInfo).hasErrors();
        }
    }

    private class BasicSettingsStep
    extends Step {
        private BasicSettingsStep() {
            super("basic-settings");
        }

        @Override
        protected boolean checkCompleted() {
            return !StepsInfo.this.basicSettingsValidator.validate(StepsInfo.this.basicSettings).hasErrors();
        }
    }

    private abstract class Step {
        private String id;
        private Boolean completed;

        private Step(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean isCompleted() {
            if (this.completed == null) {
                try {
                    this.completed = this.checkCompleted();
                }
                catch (Exception e) {
                    StepsInfo.this.LOG.debug(String.format("Step %s is not completed. Check failed with exception", this.id), (Throwable)e);
                    this.completed = false;
                }
            }
            return this.completed;
        }

        protected abstract boolean checkCompleted();

        public void markChanged() {
            this.completed = null;
        }
    }
}

