/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestEndpoint {
    private static final String ID_PROPERTY = "id";
    public static final String STATE_PROPERTY = "testEndpointState";
    private static final String STATE_COMMENT_PROPERTY = "stateComment";
    private static final String STATE_TESTING_URL_PROPERTY = "stateTestingUrl";
    public static final String BASE_URL_BACKEND_ACCESS_STATE = "baseUrlBackendAccessState";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="testEndpointState")
    private final State state;
    @JsonProperty(value="stateComment")
    private final String stateComment;
    @JsonProperty(value="stateTestingUrl")
    private final String stateTestingUrl;
    @JsonIgnore
    private final String listenPort;
    @JsonIgnore
    private final String listenAddress;
    @JsonIgnore
    private SSLContext sslContext;
    @JsonProperty(value="baseUrlBackendAccessState")
    private BaseUrlBackendAccessState baseUrlBackendAccessState;

    public TestEndpoint() {
        this(null, null, null, null, null, null, null);
    }

    private TestEndpoint(String id, State state, String stateComment, String stateTestingUrl, String listenPort, String listenAddress, SSLContext sslContext) {
        this.id = id;
        this.listenAddress = listenAddress;
        this.listenPort = listenPort;
        this.state = state;
        this.stateComment = stateComment;
        this.stateTestingUrl = stateTestingUrl;
        this.sslContext = sslContext;
    }

    public static TestEndpoint createValidEndpoint(@NotNull String id, @NotNull State state, @Nullable String stateComment, @NotNull String stateTestingUrl, @NotNull String listenPort, @NotNull String listenAddress, @Nullable SSLContext sslContext) {
        if (State.readyToCheckAndNeedUserAcceptanceOnSuccess == state && stateComment == null) {
            throw new IllegalArgumentException(String.format("stateComment should has ben set for connection validation state [%s]", new Object[]{state}));
        }
        return new TestEndpoint(id, state, stateComment, stateTestingUrl, listenPort, listenAddress, sslContext);
    }

    public static TestEndpoint createInvalidEndpoint(@NotNull String id, @NotNull String stateComment) {
        return new TestEndpoint(id, State.invalid, stateComment, null, null, null, null);
    }

    public static TestEndpoint createImpossibleToCheckEndpoint(@NotNull String id, @NotNull State state, @NotNull String stateComment) {
        if (state != State.impossibleToCheckError && state != State.impossibleToCheckWarning && state != State.impossibleToCheckNewServerCertWarning) {
            throw new IllegalStateException(String.format("This method could be used for creating endpoints in one of the following states: %s, %s ,%s", new Object[]{State.impossibleToCheckError, State.impossibleToCheckWarning, State.impossibleToCheckNewServerCertWarning}));
        }
        return new TestEndpoint(id, state, stateComment, null, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public String getListenPort() {
        return this.listenPort;
    }

    public String getStateTestingUrl() {
        return this.stateTestingUrl;
    }

    public State getState() {
        return this.state;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @JsonIgnore
    public void setBaseUrlBackendAccessState(BaseUrlBackendAccessState baseUrlBackendAccessState) {
        this.baseUrlBackendAccessState = baseUrlBackendAccessState;
    }

    public static enum BaseUrlBackendAccessState {
        ok,
        fail,
        untrustedCertificate;

    }

    public static enum State {
        invalid,
        impossibleToCheckError,
        impossibleToCheckWarning,
        impossibleToCheckNewServerCertWarning,
        readyToCheck,
        readyToCheckAndNeedUserAcceptanceOnSuccess;

    }
}

