/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.installer.model.SupportedLocale;
import com.jetbrains.service.util.Version;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class WizardBackendConfig {
    @NotNull
    private final String wizardToken;
    @NotNull
    private final Path wizardTokenStorage;
    private String urlToShowAfterCompletion;
    private String urlToShowAfterCompletionContext;
    private boolean urlToShowDependsOnBundlePort;
    private String installationUser;
    @NotNull
    private BundleInstallationType installationType;
    @NotNull
    private final String productFullVersion;
    private String productName;
    private String productPresentationName;
    private Version productUpgradeMinimalVersion;
    private String productScriptPath;
    private boolean externalHubPermitted;
    private boolean upgradeAvailable;
    private String productManufacturer;
    private String wizardBaseUrl;
    private Collection<SupportedLocale> productLocales;
    private String localesCommunityLink;
    private boolean listenAddressEditableFlag;
    private String bundleServiceId;
    private String bundleServiceSecret;
    private String hubConfiguratorConfigFile;
    private String hubConfiguratorConfigFileInBackup;
    @NotNull
    private final String additionalKeystorePath;
    @NotNull
    private final String additionalKeystorePassword;
    private String additionalKeystoreKeyEntriesPassword;
    private boolean upgradeDetected;
    private String productPreviousFullVersion;
    private String installationDirectory;
    private String upgradeHelpLink;
    private String defaultUpgradeSourceLocation;
    @NotNull
    private Path confDir;
    @NotNull
    private Path bundleLogsDir;
    @NotNull
    private final Collection<String> enabledProductServices;
    private final String whatsNewPageLink;
    private String tlsFilesGenerationPageLink;
    private final boolean forceWarningOnInvalidBaseUrlFlag;
    private final boolean httpsFeatureFlag;

    public WizardBackendConfig(@NotNull String wizardToken, @NotNull Path wizardTokenStorage, @NotNull String additionalKeystorePath, @NotNull String additionalKeystorePassword, @NotNull String productFullVersion, @NotNull BundleInstallationType installationType, @NotNull Collection<String> enabledProductServices, @NotNull Path confDir, @NotNull Path bundleLogsDir) {
        this(wizardToken, wizardTokenStorage, null, null, false, null, installationType, productFullVersion, null, null, null, null, false, false, null, null, Collections.emptySet(), null, false, null, null, null, null, additionalKeystorePath, additionalKeystorePassword, null, false, null, null, null, null, enabledProductServices, null, confDir, bundleLogsDir, false, true, null);
    }

    public WizardBackendConfig(@NotNull String wizardToken, @NotNull Path wizardTokenStorage, String urlToShowAfterCompletion, String urlToShowAfterCompletionContext, boolean urlToShowDependsOnBundlePort, String installationUser, @NotNull BundleInstallationType installationType, @NotNull String productFullVersion, String productName, String productPresentationName, String productUpgradeMinimalVersion, String productScriptPath, boolean externalHubPermitted, boolean upgradeAvailable, String productManufacturer, String wizardBaseUrl, Collection<SupportedLocale> productLocales, String localesCommunityLink, boolean listenAddressEditableFlag, String bundleServiceId, String bundleServiceSecret, String hubConfiguratorConfigFile, String hubConfiguratorConfigFileInBackup, @NotNull String additionalKeystorePath, @NotNull String additionalKeystorePassword, String additionalKeystoreKeyEntriesPassword, boolean upgradeDetected, String productPreviousFullVersion, String installationDirectory, String upgradeHelpLink, String defaultUpgradeSourceLocation, @NotNull Collection<String> enabledProductServices, String whatsNewPageLink, @NotNull Path confDir, @NotNull Path bundleLogsDir, boolean forceWarningOnInvalidBaseUrlFlag, boolean httpsFeatureFlag, String tlsFilesGenerationPageLink) {
        this.wizardToken = wizardToken;
        this.wizardTokenStorage = wizardTokenStorage;
        this.urlToShowAfterCompletion = urlToShowAfterCompletion;
        this.urlToShowAfterCompletionContext = urlToShowAfterCompletionContext;
        this.urlToShowDependsOnBundlePort = urlToShowDependsOnBundlePort;
        this.installationUser = installationUser;
        this.productFullVersion = productFullVersion;
        this.productName = productName;
        this.productPresentationName = productPresentationName;
        this.productUpgradeMinimalVersion = Version.parseVersion((String)productUpgradeMinimalVersion);
        this.productScriptPath = productScriptPath;
        this.externalHubPermitted = externalHubPermitted;
        this.upgradeAvailable = upgradeAvailable;
        this.productManufacturer = productManufacturer;
        this.wizardBaseUrl = wizardBaseUrl;
        this.productLocales = productLocales;
        this.localesCommunityLink = localesCommunityLink;
        this.listenAddressEditableFlag = listenAddressEditableFlag;
        this.bundleServiceId = bundleServiceId;
        this.bundleServiceSecret = bundleServiceSecret;
        this.hubConfiguratorConfigFile = hubConfiguratorConfigFile;
        this.hubConfiguratorConfigFileInBackup = hubConfiguratorConfigFileInBackup;
        this.additionalKeystorePath = additionalKeystorePath;
        this.additionalKeystorePassword = additionalKeystorePassword;
        this.additionalKeystoreKeyEntriesPassword = additionalKeystoreKeyEntriesPassword;
        this.upgradeDetected = upgradeDetected;
        this.productPreviousFullVersion = productPreviousFullVersion;
        this.installationDirectory = installationDirectory;
        this.upgradeHelpLink = upgradeHelpLink;
        this.defaultUpgradeSourceLocation = defaultUpgradeSourceLocation;
        this.installationType = installationType;
        this.enabledProductServices = Collections.unmodifiableCollection(enabledProductServices);
        this.whatsNewPageLink = whatsNewPageLink;
        this.confDir = confDir;
        this.bundleLogsDir = bundleLogsDir;
        this.forceWarningOnInvalidBaseUrlFlag = forceWarningOnInvalidBaseUrlFlag;
        this.httpsFeatureFlag = httpsFeatureFlag;
        this.tlsFilesGenerationPageLink = tlsFilesGenerationPageLink;
    }

    @NotNull
    public String getWizardToken() {
        return this.wizardToken;
    }

    @NotNull
    public Path getWizardTokenStorage() {
        return this.wizardTokenStorage;
    }

    public String getUrlToShowAfterCompletion() {
        return this.urlToShowAfterCompletion;
    }

    public void setUrlToShowAfterCompletion(String urlToShowAfterCompletion) {
        this.urlToShowAfterCompletion = urlToShowAfterCompletion;
    }

    public boolean isUrlToShowDependsOnBundlePort() {
        return this.urlToShowDependsOnBundlePort;
    }

    public void setUrlToShowDependsOnBundlePort(boolean urlToShowDependsOnBundlePort) {
        this.urlToShowDependsOnBundlePort = urlToShowDependsOnBundlePort;
    }

    public String getInstallationUser() {
        return this.installationUser;
    }

    @NotNull
    public String getProductFullVersion() {
        return this.productFullVersion;
    }

    public String getUrlToShowAfterCompletionContext() {
        return this.urlToShowAfterCompletionContext;
    }

    public void setUrlToShowAfterCompletionContext(String urlToShowAfterCompletionContext) {
        this.urlToShowAfterCompletionContext = urlToShowAfterCompletionContext;
    }

    public String getProductPresentationName() {
        return this.productPresentationName;
    }

    public boolean isExternalHubPermitted() {
        return this.externalHubPermitted;
    }

    public boolean isUpgradeAvailable() {
        return this.upgradeAvailable;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductManufacturer() {
        return this.productManufacturer;
    }

    public String getWizardBaseUrl() {
        return this.wizardBaseUrl;
    }

    public Collection<SupportedLocale> getProductLocales() {
        return this.productLocales;
    }

    public String getLocalesCommunityLink() {
        return this.localesCommunityLink;
    }

    public boolean isListenAddressEditableFlag() {
        return this.listenAddressEditableFlag;
    }

    public String getBundleServiceId() {
        return this.bundleServiceId;
    }

    public String getBundleServiceSecret() {
        return this.bundleServiceSecret;
    }

    public String getHubConfiguratorConfigFile() {
        return this.hubConfiguratorConfigFile;
    }

    public String getHubConfiguratorConfigFileInBackup() {
        return this.hubConfiguratorConfigFileInBackup;
    }

    @NotNull
    public String getAdditionalKeystorePath() {
        return this.additionalKeystorePath;
    }

    @NotNull
    public String getAdditionalKeystorePassword() {
        return this.additionalKeystorePassword;
    }

    @NotNull
    public String getAdditionalKeystoreKeyEntriesPassword() {
        return this.additionalKeystoreKeyEntriesPassword;
    }

    public boolean isUpgradeDetected() {
        return this.upgradeDetected;
    }

    public String getProductPreviousFullVersion() {
        return this.productPreviousFullVersion;
    }

    public String getInstallationDirectory() {
        return this.installationDirectory;
    }

    public String getUpgradeHelpLink() {
        return this.upgradeHelpLink;
    }

    public String getDefaultUpgradeSourceLocation() {
        return this.defaultUpgradeSourceLocation;
    }

    public String getProductScriptPath() {
        return this.productScriptPath;
    }

    @NotNull
    public BundleInstallationType getInstallationType() {
        return this.installationType;
    }

    @NotNull
    public Collection<String> getEnabledProductServices() {
        return this.enabledProductServices;
    }

    public Version getProductUpgradeMinimalVersion() {
        return this.productUpgradeMinimalVersion;
    }

    public String getWhatsNewPageLink() {
        return this.whatsNewPageLink;
    }

    @NotNull
    public Path getConfDir() {
        return this.confDir;
    }

    @NotNull
    public Path getBundleLogsDir() {
        return this.bundleLogsDir;
    }

    public boolean isForceWarningOnInvalidBaseUrlFlag() {
        return this.forceWarningOnInvalidBaseUrlFlag;
    }

    public boolean isHttpsFeatureFlag() {
        return this.httpsFeatureFlag;
    }

    public String getTlsFilesGenerationPageLink() {
        return this.tlsFilesGenerationPageLink;
    }
}

