/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.installer.model.SupportedLocale;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.rest.UpgradeSourceResource;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeSourceValidationResult;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class WizardInfo {
    public static final String PRODUCT_PRESENTATION_NAME_PROPERTY = "productPresentationName";
    public static final String IS_UPGRADE_AVAILABLE_PROPERTY = "isUpgradeAvailable";
    public static final String IS_EXTERNAL_HUB_PERMITTED_PROPERTY = "isExternalHubPermitted";
    public static final String FILE_SEPARATOR_PROPERTY = "fileSeparator";
    public static final String IS_LISTEN_ADDRESS_EDITABLE_PROPERTY = "isListenAddressEditable";
    public static final String PRODUCT_FULL_VERSION_PROPERTY = "productFullVersion";
    public static final String PRODUCT_MANUFACTURER_PROPERTY = "productManufacturer";
    public static final String PRODUCT_NAME_PROPERTY = "productName";
    public static final String IS_UPGRADE_DETECTED_PROPERTY = "isUpgradeDetected";
    public static final String IS_DETECTED_UPGRADE_SOURCE_VALID_PROPERTY = "isDetectedUpgradeSourceValid";
    public static final String PRODUCT_SCRIPT_PATH = "productScriptPath";
    public static final String INSTALLATION_TYPE = "installationType";
    public static final String INSTALLATION_DIRECTORY_PROPERTY = "installationDirectory";
    public static final String WHATS_NEW_PAGE_LINK = "whatsNewPageLink";
    public static final String FORCE_WARNING_ON_INVALID_BASE_URL_FLAG = "forceWarningOnInvalidBaseUrlFlag";
    public static final String HTTPS_FEATURE_FLAG = "httpsFeatureFlag";
    public static final String TLS_FILES_GENERATION_PAGE_LINK = "tlsFilesGenerationPageLink";
    public static final String LOCALES_COMMUNITY_LINK = "localesCommunityLink";
    @Autowired
    UpgradeSourceResource.OldUpgradeDataInfo oldUpgradeDataInfo;
    @Autowired
    private WizardBackendConfig wizardBackendConfig;
    @Resource(name="defaultUpgradeSource")
    private UpgradeSource defaultUpgradeSource;
    private String productPresentationName;
    private boolean isUpgradeAvailable;
    private boolean isExternalHubPermitted;
    private boolean isListenAddressEditable;
    private String productFullVersion;
    private String productManufacturer;
    private String productName;
    private String productScriptPath;
    private boolean forceWarningOnInvalidBaseUrlFlag;
    private boolean httpsFeatureFlag;
    private String tlsFilesGenerationPageLink;
    @JsonIgnore
    private Boolean isDetectedUpgradeSourceValid;
    private BundleInstallationType installationType;
    @JsonProperty
    private Collection<String> wizardLocales;
    @JsonProperty
    private Collection<SupportedLocale> availableProductLocales;
    private String localesCommunityLink;
    private String installationDirectory;
    @JsonProperty(value="whatsNewPageLink")
    private String whatsNewPageLink;

    @JsonProperty(value="fileSeparator")
    public String getFileSeparator() {
        return File.separator;
    }

    @JsonProperty(value="isExternalHubPermitted")
    public boolean isExternalHubPermitted() {
        return this.isExternalHubPermitted;
    }

    @JsonIgnore
    public void setExternalHubPermitted(boolean isExternalHubPermitted) {
        this.isExternalHubPermitted = isExternalHubPermitted;
    }

    @JsonProperty(value="productPresentationName")
    public String getProductPresentationName() {
        return this.productPresentationName;
    }

    @JsonIgnore
    public void setProductPresentationName(String productPresentationName) {
        this.productPresentationName = productPresentationName;
    }

    @JsonProperty(value="isUpgradeAvailable")
    public boolean isUpgradeAvailable() {
        return this.isUpgradeAvailable;
    }

    @JsonIgnore
    public void setUpgradeAvailable(boolean isUpgradeAvailable) {
        this.isUpgradeAvailable = isUpgradeAvailable;
    }

    @JsonIgnore
    public void setProductFullVersion(String productFullVersion) {
        this.productFullVersion = productFullVersion;
    }

    @JsonProperty(value="productFullVersion")
    public String getProductFullVersion() {
        return this.productFullVersion;
    }

    @JsonIgnore
    public void setProductManufacturer(String productManufacturer) {
        this.productManufacturer = productManufacturer;
    }

    @JsonProperty(value="productManufacturer")
    public String getProductManufacturer() {
        return this.productManufacturer;
    }

    @JsonIgnore
    public void setProductName(String productName) {
        this.productName = productName;
    }

    @JsonProperty(value="productName")
    public String getProductName() {
        return this.productName;
    }

    public Collection<String> getWizardLocales() {
        return this.wizardLocales;
    }

    public void setWizardLocales(Collection<String> wizardLocales) {
        this.wizardLocales = wizardLocales;
    }

    @JsonProperty(value="isListenAddressEditable")
    public boolean isListenAddressEditable() {
        return this.isListenAddressEditable;
    }

    @JsonIgnore
    public void setIsListenAddressEditable(boolean isListenAddressEditable) {
        this.isListenAddressEditable = isListenAddressEditable;
    }

    @JsonProperty(value="productScriptPath")
    public String getProductScriptPath() {
        return this.productScriptPath;
    }

    @JsonIgnore
    public void setProductScriptPath(String productScriptPath) {
        this.productScriptPath = productScriptPath;
    }

    @JsonIgnore
    public void setAvailableProductLocales(Collection<SupportedLocale> availableProductLocales) {
        this.availableProductLocales = availableProductLocales;
    }

    @JsonProperty(value="localesCommunityLink")
    public String getLocalesCommunityLink() {
        return this.localesCommunityLink;
    }

    @JsonIgnore
    public void setLocalesCommunityLink(String localesCommunityLink) {
        this.localesCommunityLink = localesCommunityLink;
    }

    @JsonProperty(value="installationType")
    public BundleInstallationType getInstallationType() {
        return this.installationType;
    }

    @JsonIgnore
    public void setInstallationType(BundleInstallationType installationType) {
        this.installationType = installationType;
    }

    public Collection<SupportedLocale> getAvailableProductLocales() {
        return this.availableProductLocales;
    }

    @JsonIgnore
    public void setInstallationDirectory(String installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    @JsonProperty(value="installationDirectory")
    public String getInstallationDirectory() {
        return this.installationDirectory;
    }

    public String getWhatsNewPageLink() {
        return this.whatsNewPageLink;
    }

    @JsonIgnore
    public void setWhatsNewPageLink(String whatsNewPageLink) {
        this.whatsNewPageLink = whatsNewPageLink;
    }

    @JsonProperty(value="isUpgradeDetected")
    public boolean isUpgradeDetected() {
        if (this.wizardBackendConfig.isUpgradeDetected() && this.defaultUpgradeSource != null && this.defaultUpgradeSource.getSourceLocation() != null) {
            Path installationDir = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]).toAbsolutePath();
            Path sourceLocation = Paths.get(this.defaultUpgradeSource.getSourceLocation(), new String[0]).toAbsolutePath();
            if (UpgradeSource.Type.OLD_INSTALL_DIR.equals((Object)this.defaultUpgradeSource.getType()) && installationDir.equals(sourceLocation)) {
                return !this.oldUpgradeDataInfo.getCompleted();
            }
        }
        return false;
    }

    @JsonIgnore
    public void setUpgradeDetected(boolean ignored) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="isDetectedUpgradeSourceValid")
    public Boolean isDetectedUpgradeSourceValid() {
        return this.isDetectedUpgradeSourceValid;
    }

    @JsonIgnore
    public void setDetectedUpgradeSourceValid(boolean detectedUpgradeSourceValid) {
        this.isDetectedUpgradeSourceValid = detectedUpgradeSourceValid;
    }

    @JsonProperty(value="forceWarningOnInvalidBaseUrlFlag")
    public boolean isForceWarningOnInvalidBaseUrlFlag() {
        return this.forceWarningOnInvalidBaseUrlFlag;
    }

    @JsonIgnore
    public void setForceWarningOnInvalidBaseUrlFlag(boolean forceWarningOnInvalidBaseUrlFlag) {
        this.forceWarningOnInvalidBaseUrlFlag = forceWarningOnInvalidBaseUrlFlag;
    }

    @JsonProperty(value="httpsFeatureFlag")
    public boolean isHttpsFeatureFlag() {
        return this.httpsFeatureFlag;
    }

    public void setHttpsFeatureFlag(boolean httpsFeatureFlag) {
        this.httpsFeatureFlag = httpsFeatureFlag;
    }

    @JsonIgnore
    public void revalidateDetectedUpgradeSource(@NotNull BundleUpgradeHelper upgradeHelper) {
        if (this.isUpgradeDetected()) {
            String location = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]).toAbsolutePath().toString();
            UpgradeSourceValidationResult sourceValidationResult = upgradeHelper.validate(UpgradeSource.Type.OLD_INSTALL_DIR, location);
            this.isDetectedUpgradeSourceValid = !sourceValidationResult.getValidationResult().hasErrors();
            return;
        }
        this.isDetectedUpgradeSourceValid = null;
    }

    @JsonIgnore
    public void setTlsFilesGenerationPageLink(String tlsFilesGenerationPageLink) {
        this.tlsFilesGenerationPageLink = tlsFilesGenerationPageLink;
    }

    @JsonProperty(value="tlsFilesGenerationPageLink")
    public String getTlsFilesGenerationPageLink() {
        return this.tlsFilesGenerationPageLink;
    }
}

