/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.DumpableBlock;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDumpableBlock
implements DumpableBlock {
    @Override
    public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
        for (Field field : AbstractDumpableBlock.getClassFields(this.getClass(), true)) {
            Object value;
            BlockProperty blockProperty = field.getAnnotation(BlockProperty.class);
            if (blockProperty == null) continue;
            field.setAccessible(true);
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot get wizard's value", e);
            }
            if (value == null) continue;
            if (value instanceof AbstractDumpableBlock) {
                ((AbstractDumpableBlock)value).dump(properties, dumpContext);
                continue;
            }
            String propertyName = blockProperty.value();
            if ("".equals(propertyName)) {
                propertyName = field.getName();
            }
            this.doDumpProperty(properties, propertyName, value.toString());
        }
    }

    protected void doDumpProperty(Properties properties, String name, String value) {
        properties.setProperty(name, value);
    }

    @NotNull
    private static List<Field> getClassFields(Class clazz, boolean includeSuper) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        AbstractDumpableBlock.addClassFieldsToList(clazz, fieldsList, false);
        Class superClazz = clazz.getSuperclass();
        while (includeSuper && !AbstractDumpableBlock.class.equals(superClazz)) {
            AbstractDumpableBlock.addClassFieldsToList(superClazz, fieldsList, false);
            superClazz = superClazz.getSuperclass();
        }
        return fieldsList;
    }

    private static void addClassFieldsToList(Class clazz, List<Field> fieldsList, boolean includeStatic) {
        Field[] superClassFields;
        for (Field field : superClassFields = clazz.getDeclaredFields()) {
            if (!includeStatic && Modifier.isStatic(field.getModifiers())) continue;
            fieldsList.add(field);
        }
    }
}

