/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.TestEndpoint;
import com.jetbrains.installer.model.blocks.AbstractDumpableBlock;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.validation.BasicSettingsValidator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicSettings
extends AbstractDumpableBlock {
    @Autowired
    private BasicSettingsValidator settingsValidator;
    public static final String BUNDLE_LOGS_DIR_PROPERTY = "bundle.logs-dir";
    public static final String BUNDLE_DATA_DIR_PROPERTY = "bundle.data-dir";
    public static final String BUNDLE_BACKUPS_DIR_PROPERTY = "bundle.backups-dir";
    public static final String BUNDLE_TEMP_DIR_PROPERTY = "bundle.temp-dir";
    public static final String BUNDLE_BASE_URL_PROPERTY = "bundle.base-url";
    public static final String BUNDLE_LOCALE_PROPERTY = "bundle.locale";
    public static final String BUNDLE_STATISTICS_UPLOAD_PROPERTY = "bundle.statistics-upload";
    public static final String LOGS_DIR_PROPERTY = "logsDir";
    public static final String DATA_DIR_PROPERTY = "dataDir";
    public static final String BACKUPS_DIR_PROPERTY = "backupsDir";
    public static final String TEMP_DIR_PROPERTY = "tempDir";
    public static final String BASE_URL_PROPERTY = "baseUrl";
    public static final String BASE_URL_IS_ACCESSIBLE_FROM_WIZARD_FLAG_PROPERTY = "baseUrlAccessibleFromWizard";
    public static final String LOCALE_PROPERTY = "productLocale";
    public static final String STATISTICS_UPLOAD_PROPERTY = "statisticsUpload";
    public static final String SECURE_CONTENT = "secureContent";
    public static final String SERVER_CONNECTOR_MODE_SETTINGS = "serverConnectorModeSettings";
    public static final String USE_OLD_SERVER_CERT_FLAG = "useOldServerCertFlag";
    public static final String DISABLED_FIELDS = "disabledFields";
    @BlockProperty(value="bundle.logs-dir")
    @JsonProperty(value="logsDir")
    private String logsDir;
    @BlockProperty(value="bundle.data-dir")
    @JsonProperty(value="dataDir")
    private String dataDir;
    @BlockProperty(value="bundle.backups-dir")
    @JsonProperty(value="backupsDir")
    private String backupsDir;
    @BlockProperty(value="bundle.temp-dir")
    @JsonProperty(value="tempDir")
    private String tempDir;
    @BlockProperty(value="bundle.base-url")
    @JsonProperty(value="baseUrl")
    private String baseUrl;
    @JsonProperty(value="baseUrlAccessibleFromWizard")
    private boolean baseUrlAccessibleFromWizard = true;
    @JsonProperty(value="baseUrlBackendAccessState")
    private TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState;
    @JsonProperty(value="testEndpointState")
    private TestEndpoint.State testEndpointState;
    @BlockProperty(value="bundle.locale")
    @JsonProperty(value="productLocale")
    private String productLocale;
    @BlockProperty(value="bundle.statistics-upload")
    @JsonProperty(value="statisticsUpload")
    private volatile boolean statisticsUpload = true;
    @JsonProperty(value="useOldServerCertFlag")
    private boolean useOldServerCertFlag;
    @JsonProperty(value="secureContent")
    @BlockProperty
    private SecureContent secureContent;
    @JsonProperty(value="serverConnectorModeSettings")
    @BlockProperty
    private ServerConnectorModeSettings serverConnectorModeSettings;

    public void copyFrom(@NotNull BasicSettings settings) {
        this.dataDir = settings.dataDir;
        this.logsDir = settings.logsDir;
        this.backupsDir = settings.backupsDir;
        this.tempDir = settings.tempDir;
        this.baseUrl = settings.baseUrl;
        this.productLocale = settings.productLocale;
        this.statisticsUpload = settings.statisticsUpload;
        this.baseUrlAccessibleFromWizard = settings.baseUrlAccessibleFromWizard;
        this.baseUrlBackendAccessState = settings.baseUrlBackendAccessState;
        this.testEndpointState = settings.testEndpointState;
        this.secureContent = settings.getSecureContent();
        this.serverConnectorModeSettings = settings.getServerConnectorModeSettings() != null ? settings.getServerConnectorModeSettings().createCopy() : null;
        this.useOldServerCertFlag = settings.useOldServerCertFlag;
    }

    @JsonProperty(value="disabledFields")
    public Set<String> getDisabledFields() {
        return this.settingsValidator.getDisabledFields();
    }

    @JsonIgnore
    public void setDisabledFields(Set<String> ignore) {
        throw new UnsupportedOperationException("Field [disabledFields ] is read only");
    }

    public Boolean getStatisticsUpload() {
        return this.statisticsUpload;
    }

    public void setStatisticsUpload(Boolean statisticsUpload) {
        this.statisticsUpload = statisticsUpload;
    }

    public String getLogsDir() {
        return this.logsDir;
    }

    public void setLogsDir(String logsDir) {
        this.logsDir = logsDir;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getBackupsDir() {
        return this.backupsDir;
    }

    public void setBackupsDir(String backupsDir) {
        this.backupsDir = backupsDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProductLocale() {
        return this.productLocale;
    }

    public void setProductLocale(String productLocale) {
        this.productLocale = productLocale;
    }

    public Boolean getBaseUrlAccessibleFromWizard() {
        return this.baseUrlAccessibleFromWizard;
    }

    public void setBaseUrlAccessibleFromWizard(Boolean isBaseUrlAccessibleFromWizard) {
        this.baseUrlAccessibleFromWizard = isBaseUrlAccessibleFromWizard;
    }

    public TestEndpoint.BaseUrlBackendAccessState getBaseUrlBackendAccessState() {
        return this.baseUrlBackendAccessState;
    }

    public void setBaseUrlBackendAccessState(TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState) {
        this.baseUrlBackendAccessState = baseUrlBackendAccessState;
    }

    public TestEndpoint.State getTestEndpointState() {
        return this.testEndpointState;
    }

    public void setTestEndpointState(TestEndpoint.State testEndpointState) {
        this.testEndpointState = testEndpointState;
    }

    public SecureContent getSecureContent() {
        return this.secureContent;
    }

    public void setSecureContent(SecureContent secureContent) {
        this.secureContent = secureContent;
    }

    public boolean isUseOldServerCertFlag() {
        return this.useOldServerCertFlag;
    }

    public void setUseOldServerCertFlag(boolean useOldServerCertFlag) {
        this.useOldServerCertFlag = useOldServerCertFlag;
    }

    public ServerConnectorModeSettings getServerConnectorModeSettings() {
        return this.serverConnectorModeSettings;
    }

    public void setServerConnectorModeSettings(ServerConnectorModeSettings serverConnectorModeSettings) {
        this.serverConnectorModeSettings = serverConnectorModeSettings;
    }
}

