/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.DumpOnInstall;
import com.jetbrains.installer.model.blocks.DumpOnUpgrade;
import com.jetbrains.installer.model.blocks.DumpableBlock;
import com.jetbrains.service.util.ConfiguratorUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class BlockService {
    @Autowired
    ConfigurableApplicationContext applicationContext;
    @Autowired
    ServletContext servletContext;
    @Autowired
    DumpContext dumpContext;

    public Properties persist(Collection<DumpableBlock> dumpableBlocks) {
        Properties properties = this.dump(dumpableBlocks);
        String outputFilePath = this.servletContext.getInitParameter("jetbrains.installer.output");
        File file = new File(outputFilePath != null ? outputFilePath : "bundle.installer.properties");
        this.storePropertiesInFile(properties, file);
        return properties;
    }

    @NotNull
    public Properties dump(Collection<DumpableBlock> dumpableBlocks) {
        Properties properties = new Properties();
        for (DumpableBlock dumpableBlock : dumpableBlocks) {
            dumpableBlock.dump(properties, this.dumpContext);
        }
        return properties;
    }

    private void storePropertiesInFile(Properties newProperties, File file) {
        newProperties.put("wizard.configuration.finished", Boolean.TRUE.toString());
        Properties propertiesToStore = newProperties;
        if (file.exists()) {
            propertiesToStore = ConfiguratorUtils.loadPropertiesFile((File)file);
            ConfiguratorUtils.copyProperties((Properties)newProperties, (Properties)propertiesToStore);
        }
        SortedStringProperties sortedProperties = new SortedStringProperties();
        sortedProperties.putAll((Map<?, ?>)propertiesToStore);
        ConfiguratorUtils.savePropertiesFile((File)file, (Properties)sortedProperties, (String)"");
    }

    @NotNull
    private Map<String, Object> getBeansCreatedByMethodsWithAnnotation(Class<? extends Annotation> annotation) {
        String[] beanDefinitionNames;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
        for (String beanName : beanDefinitionNames = this.applicationContext.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            String factoryMethodName = beanDefinition.getFactoryMethodName();
            String factoryBeanName = beanDefinition.getFactoryBeanName();
            if (factoryBeanName == null || factoryMethodName == null) continue;
            try {
                if (AnnotationUtils.findAnnotation((Method)this.applicationContext.getBean(factoryBeanName).getClass().getDeclaredMethod(factoryMethodName, new Class[0]), annotation) == null) continue;
                result.put(beanName, this.applicationContext.getBean(beanName));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return result;
    }

    @NotNull
    public List<DumpableBlock> getBlocks(boolean isUpgrade) {
        ArrayList<DumpableBlock> dumpableBlocks = new ArrayList<DumpableBlock>();
        Map<String, Object> annotatedBeans = this.getBeansCreatedByMethodsWithAnnotation(isUpgrade ? DumpOnUpgrade.class : DumpOnInstall.class);
        for (Object o : annotatedBeans.values()) {
            if (!(o instanceof DumpableBlock)) continue;
            dumpableBlocks.add((DumpableBlock)o);
        }
        return dumpableBlocks;
    }

    class PropertyComparator
    implements Comparator<Object> {
        PropertyComparator() {
        }

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            String lastPropertyName = "wizard.configuration.finished";
            if (lastPropertyName.equals(o1)) {
                return lastPropertyName.equals(o2) ? 0 : 1;
            }
            if (lastPropertyName.equals(o2)) {
                return -1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    }

    class SortedStringProperties
    extends Properties {
        SortedStringProperties() {
        }

        @Override
        @NotNull
        public synchronized Set<Object> keySet() {
            TreeSet<Object> set = new TreeSet<Object>(new PropertyComparator());
            set.addAll(super.keySet());
            return Collections.unmodifiableSet(set);
        }

        @Override
        @NotNull
        public synchronized Enumeration<Object> keys() {
            TreeSet<Object> set = new TreeSet<Object>(new PropertyComparator());
            set.addAll(super.keySet());
            return Collections.enumeration(set);
        }
    }
}

