/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.service.util.SecureMode;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HttpModeSettings
extends ServerConnectorModeSettings<HttpModeSettings> {
    @BlockProperty(value="bundle.listen-port")
    @JsonProperty(value="nonSecureListenPort")
    private String nonSecureListenPort;

    public HttpModeSettings() {
    }

    public HttpModeSettings(String nonSecureListenPort) {
        this.nonSecureListenPort = nonSecureListenPort;
    }

    @Override
    @NotNull
    public SecureMode getSecureMode() {
        return SecureMode.DISABLE;
    }

    public String getNonSecureListenPort() {
        return this.nonSecureListenPort;
    }

    public void setNonSecureListenPort(String nonSecureListenPort) {
        this.nonSecureListenPort = nonSecureListenPort;
    }

    @Override
    public void validate(@NotNull BundlePropertiesValidator bundlePropertiesValidator, @NotNull ValidationResult result) {
        bundlePropertiesValidator.validateBundleListenAddressAndPort(this.getListenAddress(), this.nonSecureListenPort, result, "nonSecureListenPort");
    }

    @Override
    @NotNull
    public Set<String> getPorts() {
        HashSet<String> ports = new HashSet<String>();
        if (this.nonSecureListenPort != null) {
            ports.add(this.nonSecureListenPort);
        }
        return ports;
    }
}

