/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.service.util.SecureMode;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HttpsModeSettings
extends ServerConnectorModeSettings<HttpsModeSettings> {
    public static final String BUNDLE_NON_SECURE_REDIRECT_LISTEN_PORT_PROPERTY = "bundle.tls-redirect-from-http-listen-port";
    public static final String BUNDLE_NON_SECURE_REDIRECT_ENABLED_PROPERTY = "bundle.tls-redirect-from-http";
    public static final String REDIRECTION_FROM_HTTP_FLAG = "redirectionFromHttpFlag";
    @BlockProperty(value="bundle.listen-port")
    @JsonProperty(value="secureListenPort")
    private String secureListenPort;
    @BlockProperty(value="bundle.tls-redirect-from-http-listen-port")
    @JsonProperty(value="nonSecureListenPort")
    private String nonSecureRedirectListenPort;
    @BlockProperty(value="bundle.tls-redirect-from-http")
    @JsonProperty(value="redirectionFromHttpFlag")
    private boolean isRedirectionFromHttpEnabled;

    public HttpsModeSettings() {
    }

    public HttpsModeSettings(String secureListenPort, String nonSecureRedirectListenPort, boolean isRedirectionFromHttpEnabled) {
        this.secureListenPort = secureListenPort;
        this.nonSecureRedirectListenPort = nonSecureRedirectListenPort;
        this.isRedirectionFromHttpEnabled = isRedirectionFromHttpEnabled;
    }

    @Override
    @NotNull
    public SecureMode getSecureMode() {
        return SecureMode.TLS;
    }

    @Override
    public void validate(@NotNull BundlePropertiesValidator bundlePropertiesValidator, @NotNull ValidationResult result) {
        bundlePropertiesValidator.validateBundleListenAddressAndPort(this.getListenAddress(), this.secureListenPort, result, "secureListenPort");
        if (this.isRedirectionFromHttpEnabled) {
            bundlePropertiesValidator.validateBundleListenAddressAndPort(this.getListenAddress(), this.nonSecureRedirectListenPort, result, "nonSecureListenPort");
        }
    }

    @Override
    @NotNull
    public Set<String> getPorts() {
        HashSet<String> ports = new HashSet<String>();
        if (this.secureListenPort != null) {
            ports.add(this.secureListenPort);
        }
        if (this.isRedirectionFromHttpEnabled && this.nonSecureRedirectListenPort != null) {
            ports.add(this.nonSecureRedirectListenPort);
        }
        return ports;
    }

    public String getSecureListenPort() {
        return this.secureListenPort;
    }

    public void setSecureListenPort(String secureListenPort) {
        this.secureListenPort = secureListenPort;
    }

    public String getNonSecureRedirectListenPort() {
        return this.nonSecureRedirectListenPort;
    }

    public void setNonSecureRedirectListenPort(String nonSecureRedirectListenPort) {
        this.nonSecureRedirectListenPort = nonSecureRedirectListenPort;
    }

    public boolean isRedirectionFromHttpEnabled() {
        return this.isRedirectionFromHttpEnabled;
    }

    public void setRedirectionFromHttpEnabled(boolean redirectionFromHttpEnabled) {
        this.isRedirectionFromHttpEnabled = redirectionFromHttpEnabled;
    }
}

