/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.jetbrains.installer.license.ProductInfo;
import com.jetbrains.installer.license.WizardLicenseCheckResult;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.DumpableBlock;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseKeyInfo
implements DumpableBlock {
    private static final String PRODUCT_ID_PROPERTY = "id";
    private static final String PRODUCT_NAME_PROPERTY = "productName";
    private static final String STATUS_PROPERTY = "status";
    private static final String LIMITATIONS_PROPERTY = "limitations";
    public static final String KEY_PROPERTY = "key";
    public static final String USER_NAME_PROPERTY = "userName";
    @JsonIgnore
    private LicenseKey licenseKey;

    @JsonValue
    public LicenseKey getKey() {
        return this.licenseKey;
    }

    public void setKey(LicenseKey licenseKey) {
        this.licenseKey = licenseKey;
    }

    public static LicenseKeyInfo resolveKnownKeysFromProperties(@NotNull Properties extractedProperties, @NotNull LicenseKeyInfo knownLicenseKey) {
        LicenseKeyInfo licenseKeyInfo = new LicenseKeyInfo();
        if (knownLicenseKey.getKey() != null) {
            Map serviceToLicenseKey = PropertiesBasedConfigurationHelper.getHelper().getServicesPropertyValue((Object)extractedProperties, "license-key");
            for (String serviceId : serviceToLicenseKey.keySet()) {
                LicenseKey knownKey = knownLicenseKey.getKey();
                if (knownKey != null) {
                    String licenseKey = (String)serviceToLicenseKey.get(serviceId);
                    String licenseUserName = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)extractedProperties, serviceId, "license-user-name");
                    LicenseKey extractedKey = LicenseKey.createKeyFrom(licenseUserName, licenseKey, knownKey);
                    licenseKeyInfo.setKey(extractedKey);
                    continue;
                }
                LicenseKeyInfo.getLogger().warn("Skipping license key for service " + serviceId + " ...");
            }
        }
        return licenseKeyInfo;
    }

    @JsonIgnore
    public void clearKey() {
        this.licenseKey = null;
    }

    @JsonIgnore
    public void addKeysFrom(@NotNull LicenseKeyInfo other) {
        this.licenseKey = other.getKey();
    }

    @JsonIgnore
    public void updateKeysFrom(@NotNull LicenseKeyInfo otherLicenseKeyInfo) {
        LicenseKey otherKey = otherLicenseKeyInfo.getKey();
        if (this.licenseKey != null && otherKey != null) {
            this.licenseKey = otherKey;
        }
    }

    @Override
    public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
        if (!dumpContext.isUpgrade() || dumpContext.getDefaultUpgradeLicenseKeyInfo().getKey() != null) {
            String productId = this.licenseKey.getId();
            String key = this.licenseKey.getKey();
            String licenseUserName = this.licenseKey.getUserName();
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(productId, "license-key"), key);
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(productId, "license-user-name"), licenseUserName);
        }
    }

    @JsonIgnore
    public boolean isGuestBanForbidden() {
        boolean isGuestBanForbidden = false;
        if (WizardLicenseCheckResult.Status.OK.equals((Object)this.licenseKey.getStatus()) && this.licenseKey.getCheckResult().isGuestBanForbidden()) {
            isGuestBanForbidden = true;
        }
        return isGuestBanForbidden;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(LicenseKeyInfo.class);
    }

    public static class LicenseKey {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="userName")
        private String userName;
        @JsonIgnore
        private WizardLicenseCheckResult checkResult = null;
        @JsonIgnore
        private ProductInfo productType;
        private Integer distMajorVersion;
        private Integer distMinorVersion;
        private Integer distBuildNumber;
        private Date firstMajorReleaseDate;

        @JsonProperty(value="productName")
        public String getProductName() {
            return this.productType != null ? this.productType.toString() : "Not available";
        }

        @JsonProperty(value="status")
        public WizardLicenseCheckResult.Status getStatus() {
            return this.checkResult.getStatus();
        }

        @JsonProperty(value="limitations")
        public Map<String, String> getLimitations() {
            return this.checkResult.toMap(this.productType != null ? this.productType.getFieldsToShow() : null);
        }

        public LicenseKey(@NotNull String id, @NotNull String userName, @NotNull String key, @Nullable Integer distMajorVersion, @Nullable Integer distMinorVersion, @Nullable Integer distBuildNumber, @Nullable Date firstMajorReleaseDate) {
            this(id, userName, key, distMajorVersion, distMinorVersion, distBuildNumber, firstMajorReleaseDate, null);
        }

        private LicenseKey(@NotNull String id, @NotNull String userName, @NotNull String key, @Nullable Integer distMajorVersion, @Nullable Integer distMinorVersion, @Nullable Integer distBuildNumber, @Nullable Date firstMajorReleaseDate, @Nullable ProductInfo productType) {
            this.id = id;
            this.userName = userName;
            this.key = key;
            this.distMajorVersion = distMajorVersion;
            this.distMinorVersion = distMinorVersion;
            this.distBuildNumber = distBuildNumber;
            this.firstMajorReleaseDate = firstMajorReleaseDate;
            this.productType = productType;
            this.checkLicense();
        }

        public static LicenseKey createKeyFrom(@NotNull String userName, @NotNull String key, @NotNull LicenseKey other) {
            return new LicenseKey(other.id, userName, key, other.distMajorVersion, other.distMinorVersion, other.distBuildNumber, other.firstMajorReleaseDate, other.productType);
        }

        public String getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getUserName() {
            return this.userName;
        }

        private void checkLicense() {
            Integer currentProductId = this.productType != null ? Integer.valueOf(this.productType.getLicenseProductId()) : null;
            this.checkResult = WizardLicenseCheckResult.checkLicense(this.userName, this.key, currentProductId, this.distMajorVersion, this.distMinorVersion, null, this.firstMajorReleaseDate);
            if (currentProductId == null && this.checkResult.getStatus() != WizardLicenseCheckResult.Status.INVALID_KEY) {
                this.productType = this.checkResult.getProductType();
            }
            Integer buildNumber = this.distBuildNumber;
            if (this.productType == null || !this.productType.getType().equals((Object)ProductInfo.ProductType.UPSOURCE)) {
                this.checkResult = WizardLicenseCheckResult.checkLicense(this.userName, this.key, currentProductId, this.distMajorVersion, this.distMinorVersion, buildNumber, this.firstMajorReleaseDate);
            }
        }

        public WizardLicenseCheckResult getCheckResult() {
            return this.checkResult;
        }

        public Date getFirstMajorReleaseDate() {
            return this.firstMajorReleaseDate;
        }

        public Integer getDistMajorVersion() {
            return this.distMajorVersion;
        }

        public Integer getDistMinorVersion() {
            return this.distMinorVersion;
        }

        public Integer getDistBuildNumber() {
            return this.distBuildNumber;
        }

        public ProductInfo getProductType() {
            return this.productType;
        }
    }

    public static class LicenseKeyUpdateInfo {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="userName")
        private String userName;

        public String getKey() {
            return this.key;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

