/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.blocks.AbstractDumpableBlock;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.HttpModeSettings;
import com.jetbrains.installer.model.blocks.HttpsModeSettings;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SecureMode;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="secureMode")
@JsonSubTypes(value={@JsonSubTypes.Type(value=HttpModeSettings.class, name="disable"), @JsonSubTypes.Type(value=HttpsModeSettings.class, name="tls")})
public abstract class ServerConnectorModeSettings<T extends ServerConnectorModeSettings>
extends AbstractDumpableBlock
implements Cloneable {
    public static final String SECURE_MODE_PROPERTY = "secureMode";
    public static final String BUNDLE_LISTEN_ADDRESS_PROPERTY = "bundle.listen-address";
    public static final String BUNDLE_LISTEN_PORT_PROPERTY = "bundle.listen-port";
    public static final String LISTEN_ADDRESS_PROPERTY = "listenAddress";
    public static final String NON_SECURE_LISTEN_PORT = "nonSecureListenPort";
    public static final String SECURE_LISTEN_PORT = "secureListenPort";
    public static final String DEFAULT_SECURE_LISTEN_PORT_PROPERTY = "defaultSecureListenPort";
    public static final String DEFAULT_REDIRECTION_FROM_HTTP_FLAG_PROPERTY = "defaultRedirectionFromHttpFlag";
    public static final String DEFAULT_NON_SECURE_LISTEN_PORT_PROPERTY = "defaultNonSecureListenPort";
    @BlockProperty(value="bundle.listen-address")
    @JsonProperty(value="listenAddress")
    private String listenAddress;
    @JsonProperty(value="defaultSecureListenPort")
    @NotNull
    private String defaultSecureListenPort;
    @JsonProperty(value="defaultRedirectionFromHttpFlag")
    private boolean defaultRedirectionFromHttpFlag;
    @JsonProperty(value="defaultNonSecureListenPort")
    @NotNull
    private String defaultNonSecureListenPort;

    @NotNull
    public abstract SecureMode getSecureMode();

    T createCopy() {
        return (T)((ServerConnectorModeSettings)this.clone());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
        super.dump(properties, dumpContext);
        properties.setProperty(BundleProperty.SECURE_MODE.getPrefixedName(), this.getSecureMode().getName());
    }

    public abstract void validate(@NotNull BundlePropertiesValidator var1, @NotNull ValidationResult var2);

    @NotNull
    public abstract Set<String> getPorts();

    public String getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
    }

    @NotNull
    public String getDefaultSecureListenPort() {
        return this.defaultSecureListenPort;
    }

    public void setDefaultSecureListenPort(@NotNull String defaultSecureListenPort) {
        this.defaultSecureListenPort = defaultSecureListenPort;
    }

    @NotNull
    public String getDefaultNonSecureListenPort() {
        return this.defaultNonSecureListenPort;
    }

    public void setDefaultNonSecureListenPort(@NotNull String defaultNonSecureListenPort) {
        this.defaultNonSecureListenPort = defaultNonSecureListenPort;
    }

    public boolean isDefaultRedirectionFromHttpFlag() {
        return this.defaultRedirectionFromHttpFlag;
    }

    public void setDefaultRedirectionFromHttpFlag(boolean defaultRedirectionFromHttpFlag) {
        this.defaultRedirectionFromHttpFlag = defaultRedirectionFromHttpFlag;
    }
}

