/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.TestEndpoint;
import com.jetbrains.installer.model.blocks.AbstractDumpableBlock;
import com.jetbrains.installer.model.blocks.BlockProperty;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettingsContextProvider;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.UpgradeSettingsValidator;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeSettings
extends AbstractDumpableBlock {
    @Resource(name="upgradeSource")
    private UpgradeSource upgradeSource;
    @JsonIgnore
    private UpgradeSettingsContextProvider upgradeSettingsContext;
    @Autowired
    private UpgradeSettingsValidator upgradeSettingsValidator;
    private static final String BUNDLE_LOGS_DIR_PROPERTY = "bundle.logs-dir";
    private static final String BUNDLE_DATA_DIR_PROPERTY = "bundle.data-dir";
    private static final String BUNDLE_BACKUPS_DIR_PROPERTY = "bundle.backups-dir";
    private static final String BUNDLE_TEMP_DIR_PROPERTY = "bundle.temp-dir";
    private static final String BUNDLE_BASE_URL_PROPERTY = "bundle.base-url";
    private static final String BUNDLE_EXTERNAL_HUB_URL_PROPERTY = "bundle.hub-url";
    public static final String LOGS_DIR_PROPERTY = "logsDir";
    public static final String DATA_DIR_PROPERTY = "dataDir";
    public static final String BACKUPS_DIR_PROPERTY = "backupsDir";
    public static final String TEMP_DIR_PROPERTY = "tempDir";
    public static final String BASE_URL_PROPERTY = "baseUrl";
    public static final String BASE_URL_IS_ACCESSIBLE_FROM_WIZARD_PROPERTY = "baseUrlAccessibleFromWizard";
    public static final String OLD_PRODUCT_VERSION_PROPERTY = "oldProductVersion";
    public static final String IS_EXTERNAL_HUB_USED_PROPERTY = "externalHubUsed";
    public static final String EXTERNAL_HUB_URL_PROPERTY = "externalHubUrl";
    public static final String IS_RESTORE_PROPERTY = "isRestore";
    public static final String USE_OLD_SERVER_CERT_FLAG = "useOldServerCertFlag";
    private static final String OLD_CERT_ERRORS = "oldCertErrors";
    private static final String OLD_CERT_INFO = "oldCertInfo";
    public static final String DISABLED_FIELDS = "disabledFields";
    @BlockProperty(value="bundle.logs-dir")
    @JsonProperty(value="logsDir")
    private String logsDir;
    @BlockProperty(value="bundle.data-dir")
    @JsonProperty(value="dataDir")
    private String dataDir;
    @BlockProperty(value="bundle.backups-dir")
    @JsonProperty(value="backupsDir")
    private String backupsDir;
    @BlockProperty(value="bundle.temp-dir")
    @JsonProperty(value="tempDir")
    private String tempDir;
    @BlockProperty(value="bundle.base-url")
    @JsonProperty(value="baseUrl")
    private String baseUrl;
    @JsonProperty(value="baseUrlAccessibleFromWizard")
    private boolean baseUrlAccessibleFromWizard = true;
    @JsonProperty(value="baseUrlBackendAccessState")
    private TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState;
    @JsonProperty(value="testEndpointState")
    private TestEndpoint.State testEndpointState;
    @JsonProperty(value="serverConnectorModeSettings")
    @BlockProperty
    private ServerConnectorModeSettings serverConnectorModeSettings;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @BlockProperty(value="bundle.hub-url")
    @JsonProperty(value="externalHubUrl")
    private String externalHubUrl;
    @JsonProperty(value="useOldServerCertFlag")
    private boolean useOldServerCertFlag;
    @JsonProperty(value="secureContent")
    @BlockProperty
    private SecureContent secureContent;

    @JsonGetter(value="disabledFields")
    public Set<String> getDisabledFields() {
        return this.upgradeSettingsValidator.getDisabledFields();
    }

    @JsonIgnore
    public void setDisabledFields(Set<String> ignore) {
        throw new UnsupportedOperationException("Field [disabledFields ] is read only");
    }

    public String getLogsDir() {
        return this.logsDir;
    }

    public void setLogsDir(String logsDir) {
        this.logsDir = logsDir;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getBackupsDir() {
        return this.backupsDir;
    }

    public void setBackupsDir(String backupsDir) {
        this.backupsDir = backupsDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getExternalHubUrl() {
        return this.externalHubUrl;
    }

    public void setExternalHubUrl(String externalHubUrl) {
        this.externalHubUrl = externalHubUrl;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="sourceLocation")
    public String getSourceLocation() {
        return this.upgradeSource.getSourceLocation();
    }

    @JsonIgnore
    public void setSourceLocation(String ignored) {
        throw new UnsupportedOperationException("Field [sourceLocation ] is read only");
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    public UpgradeSource.Type getType() {
        return this.upgradeSource.getType();
    }

    @JsonIgnore
    public void setType(UpgradeSource.Type type) {
        throw new UnsupportedOperationException("Field [type ] is read only");
    }

    @JsonGetter(value="oldProductVersion")
    public String getOldProductVersion() {
        return this.upgradeSettingsContext.getOldProductVersion();
    }

    @JsonIgnore
    public void setOldProductVersion(String ignored) {
        throw new UnsupportedOperationException("Field [oldProductVersion ] is read only");
    }

    @JsonGetter(value="isRestore")
    public boolean getIsRestore() {
        return this.upgradeSettingsContext.getIsRestore();
    }

    @JsonIgnore
    public void setIsRestore(boolean isRestore) {
        throw new UnsupportedOperationException("Field [isRestore ] is read only");
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="minimalCompatibleVersion")
    public String getMinimalCompatibleVersion() {
        return this.upgradeSource.getMinimalCompatibleVersion();
    }

    @JsonIgnore
    public void setMinimalCompatibleVersion(String ignored) {
        throw new UnsupportedOperationException("Field [minimalCompatibleVersion ] is read only");
    }

    @JsonGetter(value="externalHubUsed")
    public boolean isExternalHubUsed() {
        return this.upgradeSettingsContext.isExternalHubUsed();
    }

    @JsonIgnore
    public void setExternalHubUsed(boolean ignored) {
        throw new UnsupportedOperationException("Field [externalHubUsed ] is read only");
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="oldCertErrors")
    public ValidationResult getOldCertErrors() {
        return this.upgradeSettingsContext.getExtractedSecureContentValidationResult();
    }

    @JsonIgnore
    public void setOldCertErrors(ValidationResult ignored) {
        throw new UnsupportedOperationException("Field [oldCertErrors ] is read only");
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="oldCertInfo")
    public CertificateInfo getOldCertInfo() {
        return this.upgradeSettingsContext.getExtractedSecureContent() != null ? this.upgradeSettingsContext.getExtractedSecureContent().getCertificateInfo() : null;
    }

    @JsonIgnore
    public void setOldCertInfo(CertificateInfo ignored) {
        throw new UnsupportedOperationException("Field [oldCertInfo ] is read only");
    }

    public void copyFrom(@NotNull UpgradeSettings settings) {
        this.dataDir = settings.dataDir;
        this.logsDir = settings.logsDir;
        this.backupsDir = settings.backupsDir;
        this.tempDir = settings.tempDir;
        this.baseUrl = settings.baseUrl;
        this.externalHubUrl = settings.externalHubUrl;
        this.baseUrlAccessibleFromWizard = settings.baseUrlAccessibleFromWizard;
        this.baseUrlBackendAccessState = settings.baseUrlBackendAccessState;
        this.testEndpointState = settings.testEndpointState;
        this.secureContent = settings.getSecureContent();
        this.serverConnectorModeSettings = settings.getServerConnectorModeSettings() != null ? settings.getServerConnectorModeSettings().createCopy() : null;
        this.useOldServerCertFlag = settings.useOldServerCertFlag;
        if (settings.upgradeSettingsContext != null) {
            this.upgradeSettingsContext = settings.upgradeSettingsContext;
        }
    }

    @Override
    public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
        assert (this.getOldProductVersion() != null);
        Properties extractedProperties = this.upgradeSettingsContext.getExtractedProperties();
        HashSet excluded = new HashSet();
        excluded.addAll(PropertiesBasedConfigurationHelper.getHelper().getAllServicesProperties((Object)extractedProperties, "license-key"));
        excluded.addAll(PropertiesBasedConfigurationHelper.getHelper().getAllServicesProperties((Object)extractedProperties, "license-user-name"));
        ConfiguratorUtils.copyProperties((Properties)extractedProperties, (Properties)properties, excluded);
        super.dump(properties, dumpContext);
        this.upgradeSettingsContext.dump(properties, dumpContext);
    }

    public Boolean getBaseUrlAccessibleFromWizard() {
        return this.baseUrlAccessibleFromWizard;
    }

    public void setBaseUrlAccessibleFromWizard(Boolean baseUrlAccessibleFromWizard) {
        this.baseUrlAccessibleFromWizard = baseUrlAccessibleFromWizard;
    }

    public TestEndpoint.BaseUrlBackendAccessState getBaseUrlBackendAccessState() {
        return this.baseUrlBackendAccessState;
    }

    public void setBaseUrlBackendAccessState(TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState) {
        this.baseUrlBackendAccessState = baseUrlBackendAccessState;
    }

    public TestEndpoint.State getTestEndpointState() {
        return this.testEndpointState;
    }

    public void setTestEndpointState(TestEndpoint.State testEndpointState) {
        this.testEndpointState = testEndpointState;
    }

    @JsonIgnore
    public void setContext(UpgradeSettingsContextProvider upgradeSettingsContext) {
        this.upgradeSettingsContext = upgradeSettingsContext;
    }

    @JsonIgnore
    public void setUpgradeSource(@NotNull UpgradeSource upgradeSource) {
        this.upgradeSource = upgradeSource;
    }

    @JsonIgnore
    public UpgradeSource getUpgradeSource() {
        return this.upgradeSource;
    }

    @JsonIgnore
    public void setUpgradeSettingsValidator(@NotNull UpgradeSettingsValidator upgradeSettingsValidator) {
        this.upgradeSettingsValidator = upgradeSettingsValidator;
    }

    @JsonIgnore
    public UpgradeSettingsValidator getUpgradeSettingsValidator() {
        return this.upgradeSettingsValidator;
    }

    @JsonIgnore
    public UpgradeSettingsContextProvider getContext() {
        return this.upgradeSettingsContext;
    }

    public boolean isUseOldServerCertFlag() {
        return this.useOldServerCertFlag;
    }

    public void setUseOldServerCertFlag(boolean useOldServerCertFlag) {
        this.useOldServerCertFlag = useOldServerCertFlag;
    }

    public SecureContent getSecureContent() {
        return this.secureContent;
    }

    public void setSecureContent(SecureContent secureContent) {
        this.secureContent = secureContent;
    }

    public ServerConnectorModeSettings getServerConnectorModeSettings() {
        return this.serverConnectorModeSettings;
    }

    public void setServerConnectorModeSettings(ServerConnectorModeSettings serverConnectorModeSettings) {
        this.serverConnectorModeSettings = serverConnectorModeSettings;
    }
}

