/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.model.blocks;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.installer.model.PathInfo;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import java.nio.file.Path;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeSource {
    public static final String TYPE_PROPERTY = "type";
    public static final String SOURCE_LOCATION_PROPERTY = "sourceLocation";
    public static final String MINIMAL_COMPATIBLE_VERSION_PROPERTY = "minimalCompatibleVersion";
    public static final String UPGRADE_HELP_LINK_PROPERTY = "upgradeHelpLink";
    public static final String DEFAULT_UPGRADE_SOURCE_LOCATION_PROPERTY = "defaultUpgradeSourceLocation";
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    BundleUpgradeHelper upgradeHelper;
    @JsonIgnore
    private Type type;
    @JsonProperty(value="sourceLocation")
    private String sourceLocation;
    @JsonIgnore
    private Path preparedSourceLocation;

    public UpgradeSource() {
    }

    public UpgradeSource(String sourceLocation, Type type) {
        this.type = type;
        this.sourceLocation = sourceLocation;
    }

    @JsonIgnore
    public Path getPreparedSourceLocation() {
        return this.preparedSourceLocation;
    }

    public void setPreparedSourceLocation(Path preparedSourceLocation) {
        this.preparedSourceLocation = preparedSourceLocation;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="minimalCompatibleVersion")
    public String getMinimalCompatibleVersion() {
        return this.upgradeHelper.getMinimalCompatibleVersionForOldInstallationSource();
    }

    @JsonIgnore
    public void setMinimalCompatibleVersion(String ignored) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonIgnore
    public void setType(Type type) {
        this.type = type;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="upgradeHelpLink")
    public String getUpgradeHelpLink() {
        return this.wizardBackendConfig.getUpgradeHelpLink();
    }

    @JsonIgnore
    public void setUpgradeHelpLink(String ignored) {
    }

    @JsonProperty(value="defaultUpgradeSourceLocation")
    public String getDefaultUpgradeSourceLocation() {
        String location = this.wizardBackendConfig.getDefaultUpgradeSourceLocation();
        if (location != null && !location.endsWith(PathInfo.FILE_SEPARATOR)) {
            location = location + PathInfo.FILE_SEPARATOR;
        }
        return location;
    }

    @JsonIgnore
    public void setDefaultUpgradeSourceLocation(boolean ignored) {
    }

    public static enum Type {
        BACKUP_ARCHIVE(true),
        BACKUP_UNCOMPRESSED(true),
        OLD_INSTALL_DIR;

        private final boolean isBackup;

        private Type() {
            this(false);
        }

        private Type(boolean isBackup) {
            this.isBackup = isBackup;
        }

        public boolean isBackup() {
            return this.isBackup;
        }
    }
}

