/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.validation.BasicSettingsValidator;
import com.jetbrains.installer.validation.ValidationError;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/basic-settings"})
public class BasicSettingsResource {
    public static final String ID = "basic-settings";
    @Resource(name="upgradeMode")
    private AtomicBoolean upgradeMode;
    @Resource(name="basicSettings")
    private BasicSettings settings;
    @Autowired
    private StepsInfo stepsInfo;
    @Autowired
    private BasicSettingsValidator settingsValidator;
    @Autowired
    WizardInfo wizardInfo;
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Resource(name="defaultLicenseKeyInfo")
    private LicenseKeyInfo defaultLicenseKeyInfo;
    @Resource(name="defaultUpgradeLicenseKeyInfo")
    private LicenseKeyInfo defaultUpgradeLicenseKeyInfo;
    @Resource(name="licenseKeyInfo")
    LicenseKeyInfo licenseKeyInfo;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public BasicSettings get() {
        return this.settings;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public BasicSettings post(@RequestBody BasicSettings data) {
        ValidationResult validationResult = new ValidationResult();
        if (this.wizardInfo.isUpgradeDetected()) {
            validationResult.addError(ValidationError.OLD_UPGRADE_DATA_MUST_BE_REMOVED.toErrorInfo("sourceLocation"));
            throw new ValidationException(validationResult);
        }
        this.resetUpgradeMode();
        validationResult = this.settingsValidator.validate(data);
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
        this.settings.copyFrom(data);
        this.stepsInfo.markChanged(ID);
        return this.settings;
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public synchronized void checkFolder(@RequestParam(value="path") String path, @RequestParam(value="property") String property) throws ValidationException {
        ErrorInfo error = this.settingsValidator.checkPath(path, property);
        if (error != null) {
            ValidationResult result = new ValidationResult();
            result.addError(error);
            throw new ValidationException(result);
        }
    }

    private void resetUpgradeMode() {
        if (this.upgradeMode.get()) {
            this.defaultUpgradeLicenseKeyInfo.clearKey();
            this.licenseKeyInfo.clearKey();
            this.licenseKeyInfo.addKeysFrom(this.defaultLicenseKeyInfo);
        }
        this.upgradeMode.set(false);
    }
}

