/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.installer.model.SecureContent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/"})
public class CertificateUrlResource {
    private static final String CERT = "cert";

    @RequestMapping(method={RequestMethod.POST}, value={"cert"})
    @ResponseBody
    public Map<String, String> getHostnameFromCertificate(@RequestBody SecureContent content) throws ValidationException {
        try {
            X509Certificate certificate = content.getParsedCertificate();
            return this.resolveHostname(certificate);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    private HashMap<String, String> resolveHostname(X509Certificate certificate) throws CertificateException {
        HashMap<String, String> certificateUrl = new HashMap<String, String>();
        if (certificate != null) {
            Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null && !subjectAlternativeNames.isEmpty()) {
                String url = CertificateUrlResource.resolveFromSubjectAlternativeNames(subjectAlternativeNames);
                certificateUrl.put("certificateUrl", url);
            } else {
                String url = this.resolveFromCommonName(certificate);
                certificateUrl.put("certificateUrl", url);
            }
        }
        return certificateUrl;
    }

    @Nullable
    private String resolveFromCommonName(@NotNull X509Certificate certificate) throws CertificateEncodingException {
        String cn;
        X500Name x500name = new JcaX509CertificateHolder(certificate).getSubject();
        RDN[] cns = x500name.getRDNs(BCStyle.CN);
        if (cns.length != 0 && !(cn = IETFUtils.valueToString((ASN1Encodable)cns[0].getFirst().getValue())).contains("*") && cn.contains(".")) {
            return cn;
        }
        return null;
    }

    private static String resolveFromSubjectAlternativeNames(@NotNull Collection<List<?>> altNames) {
        ArrayList<String> type2 = new ArrayList<String>();
        ArrayList<String> type7 = new ArrayList<String>();
        boolean useType2 = false;
        if (!altNames.isEmpty()) {
            for (List<?> altName : altNames) {
                if (altName.get(0).equals(2)) {
                    useType2 = true;
                    String type2Item = (String)altName.get(1);
                    if (!type2Item.contains("*") && type2Item.contains(".")) {
                        type2.add(type2Item);
                    }
                    if (type2Item.contains("*")) {
                        type2.clear();
                        break;
                    }
                }
                if (!altName.get(0).equals(7)) continue;
                String type7Item = (String)altName.get(1);
                type7.add(type7Item);
            }
        }
        if (type2.size() == 1) {
            return (String)type2.get(0);
        }
        if (type7.size() == 1 && !useType2) {
            return (String)type7.get(0);
        }
        return null;
    }
}

