/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.installer.model.blocks.AdditionalKeystoreWrapper;
import com.jetbrains.installer.rest.UnknownResourceException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"})
public class CertificatesResource {
    public static final String ID = "certificates";
    @Autowired
    AdditionalKeystoreWrapper additionalKeystoreWrapper;

    @RequestMapping(method={RequestMethod.GET}, value={"/wizard/certificates"})
    @ResponseBody
    public CertificateInfo[] getCertificates() {
        return this.additionalKeystoreWrapper.getKeystore().getCertificates();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/wizard/certificates"})
    @ResponseBody
    public CertificateInfo addCertificate(@RequestBody CertificateInfo info) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.additionalKeystoreWrapper.getKeystore().setCertificate(info.getFingerprintSHA1(), info);
        return info;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/wizard/certificates/{fingerprint}"})
    @ResponseBody
    public CertificateInfo getCertificate(HttpServletRequest request, @PathVariable(value="fingerprint") String fingerprint) throws UnknownResourceException {
        CertificateInfo info = this.additionalKeystoreWrapper.getKeystore().getCertificate(fingerprint);
        if (info == null) {
            throw new UnknownResourceException(request.getRequestURI());
        }
        return info;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/wizard/certificates/{fingerprint}"})
    @ResponseBody
    public void deleteCertificate(@PathVariable(value="fingerprint") String fingerprint) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.additionalKeystoreWrapper.getKeystore().removeCertificate(fingerprint);
    }
}

