/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.PathInfo;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.impl.FolderWriteAccessValidator;
import com.jetbrains.service.util.SystemUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/browse"}, produces={"application/json"})
public class FilesResource {
    @Autowired
    protected FolderWriteAccessValidator writeAccessValidator;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public PathInfo getFolder(@RequestParam(value="path", required=false) String path, @RequestParam(value="showFiles", required=false) Boolean showFiles) {
        try {
            return PathInfo.getPathInfo(path, showFiles != null && showFiles != false, ".zip", ".tar.gz");
        }
        catch (Exception e) {
            ValidationResult result = new ValidationResult();
            result.addError(ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), e.getMessage(), "path"));
            throw new ValidationException(result);
        }
    }

    @RequestMapping(value={"/access/write"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public void checkFolder(@RequestParam(value="path") String path) throws ValidationException {
        String error;
        if (path != null && (error = SystemUtil.checkFolderIsWritable((File)new File(path))) != null) {
            this.reportErrors(Collections.singletonList(this.writeAccessValidator.constructNoWriteAccessError(error, error, null)));
        }
    }

    private void reportErrors(@NotNull List<ErrorInfo> errors) {
        if (!errors.isEmpty()) {
            ValidationResult result = new ValidationResult();
            for (ErrorInfo error : errors) {
                error.setField("path");
                result.addError(error);
            }
            throw new ValidationException(result);
        }
    }
}

