/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.OneTimeTokenHolder;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.validation.DefaultServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.ExternalHubInfo;
import com.jetbrains.bundle.hub_client.util.validation.HubHomeUrlInfo;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.HubBundleServiceInfo;
import com.jetbrains.installer.rest.HubAuthenticationFailedException;
import com.jetbrains.installer.rest.HubForbiddenException;
import com.jetbrains.installer.util.WizardHubUtil;
import com.jetbrains.installer.validation.ValidationError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import jersey.repackaged.com.google.common.collect.Sets;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/hub/bundle-service"})
public class HubBundleServiceResource {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String ID = "bundle-service";
    public static final String HUB_URL_PARAM = "hubUrl";
    public static final String REDIRECT_URI_PARAM = "redirectUri";
    public static final String LOGIN_PARAM = "login";
    public static final String PASSWORD_PARAM = "password";
    private final Object mutex = new Object();
    @Autowired
    HubClientProvider hubClientProvider;
    @Autowired
    private HubBundleServiceInfo hubBundleServiceInfo;
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    WizardHubUtil wizardHubUtil;
    @Autowired
    private StepsInfo stepsInfo;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ExternalHubInfo createBundleService(@RequestBody ExternalHubInfo data, @RequestParam(value="redirectUri") String redirectUri, @RequestParam(value="login", required=false) String login, @RequestParam(value="password", required=false) String password) throws HubForbiddenException, HubAuthenticationFailedException {
        String hubUrl = data.getHubUrl();
        ValidationResult validationResult = new ValidationResult();
        HubUrlValidator hubUrlValidator = this.wizardHubUtil.getHubUrlValidatorForCleanInstallation();
        hubUrl = hubUrlValidator.validate(hubUrl, validationResult, HUB_URL_PARAM, true);
        if (login != null || password != null) {
            if (StringUtils.isEmpty((Object)login)) {
                validationResult.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Login must not be empty", LOGIN_PARAM));
            }
            if (StringUtils.isEmpty((Object)password)) {
                validationResult.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Password must not be empty", PASSWORD_PARAM));
            }
        }
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
        Object object = this.mutex;
        synchronized (object) {
            String serviceId = this.hubBundleServiceInfo.getBundleServiceId();
            String serviceSecret = this.hubBundleServiceInfo.getBundleServiceSecret();
            if (serviceId == null || serviceSecret == null) {
                throw new IllegalStateException("Bundle service id or service secret in Hub not provided!");
            }
            try {
                ServiceJSON service;
                this.removeBundleServiceInOldHubIfNeeded(hubUrl);
                this.hubBundleServiceInfo.setHubUrl(hubUrl);
                this.hubBundleServiceInfo.setOriginalHubUrl(hubUrl);
                this.hubBundleServiceInfo.setTrusted(false);
                HubClient hubClient = this.hubClientProvider.getHubClient(hubUrl);
                ServiceClient serviceClient = this.getServiceClient(hubClient, login, password);
                try {
                    ArrayList<String> redirectUris = new ArrayList<String>();
                    redirectUris.add(redirectUri);
                    service = this.wizardHubUtil.createService(serviceClient, serviceId, serviceSecret, this.hubBundleServiceInfo.getBundleServiceName(), redirectUris);
                    if (login != null && password != null && !Boolean.TRUE.equals(service.isTrusted())) {
                        validationResult.addError(this.wizardHubUtil.getService(serviceClient, serviceId) == null ? ValidationError.HUB_USER_HAS_NO_READ_SERVICE_PERMISSION.toErrorInfo(HUB_URL_PARAM) : ValidationError.HUB_USER_HAS_NO_UPDATE_SERVICE_PERMISSION.toErrorInfo(HUB_URL_PARAM));
                        throw new HubForbiddenException(validationResult);
                    }
                }
                catch (WebApplicationException e) {
                    if (e.getResponse().getStatus() == 403) {
                        validationResult.addError(ValidationError.HUB_BASIC_AUTHENTICATION_REQUIRED.toErrorInfo(HUB_URL_PARAM));
                        throw new HubForbiddenException(e, validationResult);
                    }
                    if (e.getResponse().getStatus() == 401) {
                        validationResult.addError(ValidationError.HUB_BASIC_AUTHENTICATION_FAILED.toErrorInfo(HUB_URL_PARAM));
                        throw new HubAuthenticationFailedException(e, validationResult);
                    }
                    if (e.getResponse().getStatus() != 409) {
                        throw e;
                    }
                    service = this.trustExistingBundleServiceBehalfOnUser(redirectUri, login, password, serviceId, serviceClient);
                }
                return this.doGetBundleService(hubUrl, (Service)service);
            }
            catch (ValidationException | HubAuthenticationFailedException | HubForbiddenException e) {
                throw e;
            }
            catch (Exception e) {
                validationResult.addError((Enum)ValidationResult.Error.INVALID_HUB_URL, HUB_URL_PARAM, "Cannot use Hub: " + e.getMessage());
                this.LOG.error("Cannot create bundle service in external Hub", (Throwable)e);
                throw new ValidationException(validationResult);
            }
        }
    }

    private ServiceJSON trustExistingBundleServiceBehalfOnUser(@NotNull String redirectUri, String login, String password, String serviceId, ServiceClient serviceClient) throws HubForbiddenException {
        if (login == null || password == null) {
            return null;
        }
        ServiceJSON service = this.wizardHubUtil.getService(serviceClient, serviceId);
        if (service == null) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError(ValidationError.HUB_USER_HAS_NO_READ_SERVICE_PERMISSION.toErrorInfo(HUB_URL_PARAM));
            throw new HubForbiddenException(validationResult);
        }
        if (!Boolean.TRUE.equals(service.isTrusted())) {
            service.setTrusted(Boolean.valueOf(true));
            HashSet<String> existingRedirectUris = service.getRedirectUris() != null ? Sets.newHashSet((Iterable)service.getRedirectUris()) : new HashSet<String>();
            existingRedirectUris.add(redirectUri);
            service.setRedirectUris(existingRedirectUris);
            try {
                serviceClient.updateService(serviceId, service);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == 403) {
                    ValidationResult validationResult = new ValidationResult();
                    validationResult.addError(ValidationError.HUB_USER_HAS_NO_UPDATE_SERVICE_PERMISSION.toErrorInfo(HUB_URL_PARAM));
                    throw new HubForbiddenException(validationResult);
                }
                throw e;
            }
        }
        return service;
    }

    private void removeBundleServiceInOldHubIfNeeded(@NotNull String hubUrl) {
        String serviceId = this.hubBundleServiceInfo.getBundleServiceId();
        String serviceSecret = this.hubBundleServiceInfo.getBundleServiceSecret();
        String oldHubUrl = this.hubBundleServiceInfo.getHubUrl();
        if (!hubUrl.equals(oldHubUrl) && oldHubUrl != null) {
            try {
                HubClient hubClient = this.hubClientProvider.getHubClient(oldHubUrl);
                hubClient.getAccountsClient(serviceId, serviceSecret, new String[0]).getServiceClient().deleteService(serviceId);
            }
            catch (Exception e) {
                this.LOG.info("Cannot delete service " + serviceId);
            }
        }
    }

    private ExternalHubInfo doGetBundleService(String hubUrl, @Nullable Service service) {
        HubClient hubClient = this.hubClientProvider.getHubClient(hubUrl);
        String serviceId = this.hubBundleServiceInfo.getBundleServiceId();
        String serviceSecret = this.hubBundleServiceInfo.getBundleServiceSecret();
        ServiceClient serviceClient = this.wizardHubUtil.getServiceClientByIdAndSecret(hubClient, serviceId, serviceSecret);
        boolean changed = false;
        ExternalHubInfo result = new ExternalHubInfo();
        if (service == null) {
            try {
                service = this.wizardHubUtil.getService(serviceClient, serviceId);
            }
            catch (Exception ignore) {
                this.hubBundleServiceInfo.setTrusted(false);
                changed = true;
            }
        }
        Boolean isTrusted = false;
        if (service != null) {
            isTrusted = Boolean.TRUE.equals(service.isTrusted());
            if (!Boolean.valueOf(this.hubBundleServiceInfo.isTrusted()).equals(isTrusted)) {
                this.hubBundleServiceInfo.setTrusted(isTrusted);
                changed = true;
            }
            if (isTrusted.booleanValue()) {
                ValidationResult validationResult = new ValidationResult();
                HubUrlValidator hubUrlValidator = this.wizardHubUtil.getHubUrlValidatorForCleanInstallation();
                hubUrlValidator.validateLicense(hubClient, serviceClient, validationResult, HUB_URL_PARAM);
                if (validationResult.hasErrors()) {
                    throw new ValidationException(validationResult);
                }
                HubHomeUrlInfo hubHomeUrlInfo = hubUrlValidator.getHubHomeUrlInfo(hubClient, serviceId, (IServiceClientFactory)new DefaultServiceClientFactory(serviceId, serviceSecret), validationResult, "hubHomeUrl");
                if (validationResult.hasErrorForField("hubHomeUrl")) {
                    throw new ValidationException(validationResult);
                }
                result.setHubHomeUrl(hubHomeUrlInfo.getHubHomeUrl());
                boolean hubHomeUrlIsAvailable = hubHomeUrlInfo.isHubHomeUrlIsAvailable();
                result.setHubHomeUrlIsAvailable(Boolean.valueOf(hubHomeUrlIsAvailable));
                if (hubHomeUrlInfo.isHubHomeUrlIsAvailable()) {
                    if (!Objects.equals(this.hubBundleServiceInfo.getHubUrl(), hubHomeUrlInfo.getHubHomeUrl())) {
                        this.hubBundleServiceInfo.setHubUrl(hubHomeUrlInfo.getHubHomeUrl());
                        this.hubBundleServiceInfo.setOriginalHubUrl(hubUrl);
                        changed = true;
                    }
                    hubUrl = hubHomeUrlInfo.getHubHomeUrl();
                }
            }
        }
        result.setHubUrl(hubUrl);
        result.setServiceId(serviceId);
        result.setIsVerified(isTrusted.booleanValue());
        if (changed) {
            this.stepsInfo.markChanged("hub-settings");
        }
        return result;
    }

    @NotNull
    private ServiceClient getServiceClient(HubClient hubClient, @Nullable String login, @Nullable String password) {
        BaseAccountsClient accountsClient = login == null || password == null ? hubClient.getAccountsClient() : hubClient.getAccountsClient((TokenHolder)new OneTimeTokenHolder((AuthToken)new BasicAuthToken(login, password)));
        return accountsClient.getServiceClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ExternalHubInfo getBundleService() {
        Object object = this.mutex;
        synchronized (object) {
            String savedHubUrl = this.hubBundleServiceInfo.getHubUrl();
            return this.doGetBundleService(savedHubUrl, null);
        }
    }
}

