/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.blocks.HubBundleServiceInfo;
import com.jetbrains.installer.model.blocks.HubSettings;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.validation.HubSettingsValidator;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/hub-settings"})
public class HubSettingsResource {
    public static final String ID = "hub-settings";
    @Resource(name="hubSettings")
    private HubSettings settings;
    @Autowired
    private HubBundleServiceInfo hubBundleServiceInfo;
    @Resource(name="licenseKeyInfo")
    private LicenseKeyInfo licenseKeyInfo;
    @Autowired
    private HubSettingsValidator hubSettingsValidator;
    @Autowired
    private StepsInfo stepsInfo;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public HubSettings get() {
        return this.settings;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public HubSettings post(@RequestBody HubSettings data) throws IOException {
        ValidationResult validationResult = this.hubSettingsValidator.validate(data, this.hubBundleServiceInfo);
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
        Boolean disableInternalHub = data.getDisableInternalHub();
        if (disableInternalHub.booleanValue()) {
            this.settings.setHubUrl(this.hubBundleServiceInfo.getHubUrl());
            this.settings.setRootUser(null);
            this.settings.setRootPassword(null);
            this.settings.setAllowAnonymousAccess(null);
        } else {
            this.settings.setHubUrl(null);
            this.settings.setRootUser(data.getRootUser());
            this.settings.setRootPassword(data.getRootPassword());
            if (!this.licenseKeyInfo.isGuestBanForbidden()) {
                this.settings.setAllowAnonymousAccess(data.getAllowAnonymousAccess());
            }
        }
        this.settings.setDisableInternalHub(disableInternalHub);
        this.stepsInfo.markChanged(ID);
        return this.settings;
    }
}

