/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.license.WizardLicenseCheckResult;
import com.jetbrains.installer.model.blocks.HubSettings;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.rest.UnknownResourceException;
import com.jetbrains.installer.validation.ValidationError;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"})
public class LicenseKeyResource {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String ID = "license-key";
    @Resource(name="licenseKeyInfo")
    private LicenseKeyInfo licenseKeyInfo;
    @Resource(name="hubSettings")
    private HubSettings hubSettings;

    @RequestMapping(method={RequestMethod.GET}, value={"/wizard/license-key"})
    @ResponseBody
    public LicenseKeyInfo.LicenseKey getKey() {
        return this.licenseKeyInfo.getKey();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/wizard/license-key"})
    @ResponseBody
    public LicenseKeyInfo.LicenseKey setKey(HttpServletRequest request, @RequestBody LicenseKeyInfo.LicenseKeyUpdateInfo data) throws UnknownResourceException {
        LicenseKeyInfo.LicenseKey newKey;
        String newUserName;
        LicenseKeyInfo.LicenseKey key = this.licenseKeyInfo.getKey();
        if (key == null) {
            throw new UnknownResourceException(request.getRequestURI());
        }
        ValidationResult validationResult = new ValidationResult();
        String newLicenseKey = data.getKey();
        if (newLicenseKey == null || "".equals(newLicenseKey.trim())) {
            validationResult.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("License key cannot be empty", "key"));
        }
        if ((newUserName = data.getUserName()) == null || "".equals(newUserName.trim())) {
            validationResult.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("License user name cannot be empty", "userName"));
        }
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
        if (Objects.equals(key.getKey(), newLicenseKey) && Objects.equals(key.getUserName(), newUserName)) {
            newKey = key;
        } else {
            newKey = LicenseKeyInfo.LicenseKey.createKeyFrom(newUserName, newLicenseKey, key);
            this.licenseKeyInfo.setKey(newKey);
        }
        if (WizardLicenseCheckResult.Status.OK.equals((Object)newKey.getStatus()) && !this.hubSettings.getDisableInternalHub().booleanValue() && !this.hubSettings.getAllowAnonymousAccess().booleanValue() && newKey.getCheckResult().isGuestBanForbidden()) {
            this.hubSettings.setAllowAnonymousAccess(true);
            this.LOG.warn("'Allow anonymous access' was set on 'User management' step, because it is required by license.");
        }
        return newKey;
    }
}

