/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.bundle.util.auth.exceptions.AuthenticationException;
import com.jetbrains.bundle.util.auth.exceptions.TooManyFailedAuthAttemptsException;
import com.jetbrains.installer.model.error.ErrorResult;
import com.jetbrains.installer.model.error.InvalidAuthTokenResult;
import com.jetbrains.installer.model.error.TooManyFailedAuthAttemptsResult;
import com.jetbrains.installer.rest.HubAuthenticationFailedException;
import com.jetbrains.installer.rest.HubForbiddenException;
import com.jetbrains.installer.rest.UnknownResourceException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RequestErrorHandler {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String ERROR_PARAM = "error";

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ValidationException.class})
    @ResponseBody
    public ValidationResult handleException(ValidationException exception, HttpServletRequest request) {
        this.LOG.debug("Validation error on {} request to {}: {}", new Object[]{request.getMethod(), request.getRequestURI(), this.convertToString(exception.getResult())});
        return exception.getResult();
    }

    private String convertToString(@Nullable ValidationResult result) {
        if (result == null || result.getErrors() == null || result.getErrors().length == 0) {
            return "no additional info";
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        for (ErrorInfo errorInfo : result.getErrors()) {
            stringBuilder.append(errorInfo.getField()).append(" ==> ").append(errorInfo.getError()).append('[').append(errorInfo.getDescription()).append(']').append('[').append(errorInfo.getDeveloperMessage()).append(']').append('\n');
        }
        return stringBuilder.toString();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={UnknownResourceException.class})
    @ResponseBody
    public Map<String, String> handleUnknownResourceException(UnknownResourceException exception) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ERROR_PARAM, String.format("Requested resource not found: %s", exception.getRequestURI()));
        return result;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    public ErrorResult handleException(AuthenticationException exception) {
        return new InvalidAuthTokenResult("INVALID_AUTH_TOKEN", "Invalid auth token", exception.getTokenStorage().toString());
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={TooManyFailedAuthAttemptsException.class})
    @ResponseBody
    public ErrorResult handleException(TooManyFailedAuthAttemptsException exception) {
        return new TooManyFailedAuthAttemptsResult("TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS", "Two many failed authentication attempts", exception.getIntervalToWaitInMillis(), exception.getFailedAttemptsCount(), exception.getTokenStorage().toString());
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={HubForbiddenException.class})
    @ResponseBody
    public ValidationResult handleHubForbiddenException(HubForbiddenException exception) {
        return exception.getValidationResult();
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={HubAuthenticationFailedException.class})
    @ResponseBody
    public ValidationResult handleAuthenticationFailedException(HubAuthenticationFailedException exception) {
        return exception.getValidationResult();
    }
}

