/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.KeyStoreHolder;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.TestConnection;
import com.jetbrains.installer.model.TestEndpoint;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.rest.UnknownResourceException;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.installer.validation.ValidationEndpointsManager;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.est.jcajce.JsseDefaultHostnameAuthorizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/connections"})
public class TestConnectionResource {
    public static final String ID = "connections";
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    BundleDefaults bundleDefaults;
    @Autowired
    StepsInfo stepsInfo;
    @Autowired
    BundlePropertiesValidator bundlePropertiesValidator;
    @Autowired
    ValidationEndpointsManager validationEndpointsManager;
    @Resource(name="defaultUpgradeSettings")
    private UpgradeSettings defaultUpgradeSettings;
    private static final String TEST_CONNECTION_SERVICE_CONTEXT = "/wizard/connections/status";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static Map<String, TestEndpoint> endpoints = new ConcurrentHashMap<String, TestEndpoint>();

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public TestEndpoint createEndpoint(@RequestBody TestConnection data) throws ValidationException {
        URL baseUrl;
        String id = UUID.randomUUID().toString();
        ValidationResult result = new ValidationResult();
        String url = data.getUrl();
        String nonSecureListenPort = data.getNonSecureListenPort();
        String listenAddress = data.getListenAddress();
        String secureMode = data.getSecureMode();
        String secureListenPort = data.getSecureListenPort();
        boolean useOldServerCert = data.isUseOldServerCertFlag();
        SecureContent secureContent = useOldServerCert ? this.defaultUpgradeSettings.getContext().getExtractedSecureContent() : data.getSecureContent();
        this.bundlePropertiesValidator.validateUrl(url, "baseUrl", result);
        this.bundlePropertiesValidator.validateListenAddress(listenAddress, result);
        if (!secureMode.equals(SecureMode.DISABLE.getName()) && !UrlUtil.isSecuredUrl((String)url)) {
            return TestEndpoint.createInvalidEndpoint(id, "Base URL should start from https");
        }
        try {
            baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL should has been validated to this moment");
        }
        if (secureMode.equals(SecureMode.DISABLE.getName())) {
            this.bundlePropertiesValidator.validateListenPort(nonSecureListenPort, result, "nonSecureListenPort");
        } else {
            this.bundlePropertiesValidator.validateListenPort(secureListenPort, result, "secureListenPort");
            if (data.isRedirectionFromHttpEnabled() && nonSecureListenPort != null) {
                this.bundlePropertiesValidator.validateListenPort(nonSecureListenPort, result, "nonSecureListenPort");
            }
            if (!useOldServerCert) {
                secureContent.validate(result);
            }
            CertificateInfo certificateInfo = secureContent.getCertificateInfo();
            if (!result.hasErrors() && certificateInfo != null) {
                String hostnameFromBaseUrl = baseUrl.getHost();
                try {
                    JsseDefaultHostnameAuthorizer hostnameVerifier = new JsseDefaultHostnameAuthorizer(null);
                    boolean match = hostnameVerifier.verify(hostnameFromBaseUrl, certificateInfo.getCertificate());
                    if (!match) {
                        result.addError(ValidationError.HOSTNAME_FROM_BASE_URL_DOES_NOT_MATCH_CERTIFICATE.toErrorInfo(Collections.singletonMap("hostname", hostnameFromBaseUrl), "baseUrl"));
                    }
                }
                catch (Exception e) {
                    this.LOG.debug("Hostname verification failed unexpectedly", (Throwable)e);
                }
            }
        }
        if (result.hasErrors()) {
            throw new ValidationException(result);
        }
        listenAddress = listenAddress != null ? listenAddress : this.bundleDefaults.getListenAddress();
        int portFromBaseUrl = UrlUtil.getPort((URL)baseUrl);
        if (!secureMode.equals(SecureMode.DISABLE.getName())) {
            if (!String.valueOf(portFromBaseUrl).equals(secureListenPort)) {
                return TestEndpoint.createInvalidEndpoint(id, "Port in base URL doesn't match with secure listen port");
            }
            if (data.isRedirectionFromHttpEnabled() && secureListenPort.equals(nonSecureListenPort)) {
                return TestEndpoint.createInvalidEndpoint(id, "Secure listen port should differ from non secure redirection port");
            }
        }
        String portToCheck = this.resolveDynamicEndpointPort(nonSecureListenPort, secureMode, secureListenPort);
        TestEndpoint endpoint = this.getTestEndpoint(id, portToCheck, listenAddress, url, useOldServerCert, secureMode, secureListenPort, nonSecureListenPort, secureContent, result);
        if (secureMode.equals(SecureMode.TLS.getName()) && (endpoint.getState() == TestEndpoint.State.readyToCheck || endpoint.getState() == TestEndpoint.State.readyToCheckAndNeedUserAcceptanceOnSuccess)) {
            this.checkBaseUrlAccessibility(endpoint);
        }
        endpoints.put(id, endpoint);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int connectToUrl(@NotNull URL url, @Nullable SSLContext sslContext) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection instanceof HttpsURLConnection && sslContext != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkBaseUrlAccessibility(@NotNull TestEndpoint testEndpoint) {
        TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState;
        URL siteURL;
        try {
            siteURL = new URL(testEndpoint.getStateTestingUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("Test endpoint URL %s should not be malformed at this point", testEndpoint.getStateTestingUrl()));
        }
        try {
            this.connectToUrl(siteURL, null);
            baseUrlBackendAccessState = TestEndpoint.BaseUrlBackendAccessState.ok;
        }
        catch (IOException e) {
            if (e instanceof SSLHandshakeException && testEndpoint.getSslContext() != null) {
                try {
                    this.connectToUrl(siteURL, testEndpoint.getSslContext());
                    baseUrlBackendAccessState = TestEndpoint.BaseUrlBackendAccessState.untrustedCertificate;
                }
                catch (IOException e1) {
                    this.LOG.debug(String.format("Service is not accessible by URL %s even with appropriate SSL context", testEndpoint.getStateTestingUrl()), (Throwable)e);
                    baseUrlBackendAccessState = TestEndpoint.BaseUrlBackendAccessState.fail;
                }
            }
            this.LOG.debug(String.format("Service is not accessible by URL %s", testEndpoint.getStateTestingUrl()), (Throwable)e);
            baseUrlBackendAccessState = TestEndpoint.BaseUrlBackendAccessState.fail;
        }
        testEndpoint.setBaseUrlBackendAccessState(baseUrlBackendAccessState);
    }

    @NotNull
    private TestEndpoint getTestEndpoint(String id, String portToCheck, String listenAddress, String url, boolean useOldServerCert, String secureMode, String secureListenPort, String nonSecureListenPort, SecureContent secureContent, ValidationResult result) {
        TestEndpoint endpoint;
        boolean portIsOccupiedByWizard = portToCheck.equals(this.bundleDefaults.getBundleListenPort());
        SecureMode wizardSecureMode = this.bundleDefaults.getSecureMode();
        boolean wizardRedirectionPortIsUsed = SecureMode.TLS == wizardSecureMode && Boolean.parseBoolean(this.bundleDefaults.getTlsRedirectionFromHttpFlag());
        String wizardRedirectionPort = wizardRedirectionPortIsUsed ? this.bundleDefaults.getTlsRedirectionFromHttpListenPort() : null;
        boolean addressIsOccupiedByWizard = listenAddress.equalsIgnoreCase(this.bundleDefaults.getListenAddress());
        if (portIsOccupiedByWizard && addressIsOccupiedByWizard) {
            endpoint = secureMode.equals(SecureMode.DISABLE.getName()) && this.bundleDefaults.getSecureMode() != SecureMode.DISABLE || !secureMode.equals(SecureMode.DISABLE.getName()) && this.bundleDefaults.getSecureMode() == SecureMode.DISABLE ? TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckError, "It is not possible to check base URL accessibility. Wizard occupies target listen port and address and its secure mode differs from selected one") : (secureMode.equals(SecureMode.DISABLE.getName()) ? TestEndpoint.createValidEndpoint(id, TestEndpoint.State.readyToCheck, null, this.buildWizardBasedStateTestingUrl(url), portToCheck, listenAddress, null) : (useOldServerCert ? TestEndpoint.createValidEndpoint(id, TestEndpoint.State.readyToCheck, null, this.buildWizardBasedStateTestingUrl(url), portToCheck, listenAddress, this.buildClientSslContext(secureContent)) : TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckNewServerCertWarning, "It is not possible to check base URL accessibility. Wizard occupies target listen port and address, but new TLS certificate files were uploaded. Continue with the current settings if you are sure base URL is valid and matches uploaded server certificate, or change listen port to another value")));
        } else if (!portIsOccupiedByWizard) {
            endpoint = !portToCheck.equals(wizardRedirectionPort) ? this.startDynamicTestingEndpoint(id, result, url, nonSecureListenPort, listenAddress, secureMode, secureListenPort, secureContent) : (secureMode.equals(SecureMode.TLS.getName()) ? TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckError, "It is not possible to check base URL accessibility. Wizard occupies target listen port and address for none-secure redirection endpoint. ") : (!(addressIsOccupiedByWizard || "0.0.0.0".equals(this.bundleDefaults.getListenAddress()) || "0.0.0.0".equals(listenAddress)) ? this.startDynamicTestingEndpoint(id, result, url, nonSecureListenPort, listenAddress, secureMode, secureListenPort, secureContent) : TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckWarning, String.format("It is not possible to check base URL accessibility. Configuration Wizard occupies listen port %s for none-secure redirection endpoint.Continue with the current settings if you are sure base URL is valid, or change the listen port to another value", portToCheck))));
        } else if (!"0.0.0.0".equals(this.bundleDefaults.getListenAddress()) && !"0.0.0.0".equals(listenAddress)) {
            endpoint = this.startDynamicTestingEndpoint(id, result, url, nonSecureListenPort, listenAddress, secureMode, secureListenPort, secureContent);
        } else if (secureMode.equals(SecureMode.DISABLE.getName()) && this.bundleDefaults.getSecureMode() != SecureMode.DISABLE || !secureMode.equals(SecureMode.DISABLE.getName()) && this.bundleDefaults.getSecureMode() == SecureMode.DISABLE) {
            endpoint = TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckError, "It is not possible to check base URL accessibility. Wizard occupies target listen port and its secure mode differs from selected one ");
        } else if (secureMode.equals(SecureMode.DISABLE.getName()) || useOldServerCert) {
            String stateComment = String.format("Service started on listen address %s is accessible by given base URL. And new listen address %s is a valid one. Though it is not possible to check automatically if service being deployed on the new listen address would be still accessible by the base URL. Continue with the current settings if you are sure new listen address and base URL are valid, or change the listen address back to %s", this.bundleDefaults.getListenAddress(), listenAddress, this.bundleDefaults.getListenAddress());
            endpoint = TestEndpoint.createValidEndpoint(id, TestEndpoint.State.readyToCheckAndNeedUserAcceptanceOnSuccess, stateComment, this.buildWizardBasedStateTestingUrl(url), portToCheck, listenAddress, null);
        } else {
            endpoint = TestEndpoint.createImpossibleToCheckEndpoint(id, TestEndpoint.State.impossibleToCheckNewServerCertWarning, "It is not possible to check base URL accessibility. Wizard occupies target listen port, but new TLS certificate files were uploaded. Continue with the current settings if you are sure base URL is valid and matches uploaded server certificate, or change listen port to another value");
        }
        return endpoint;
    }

    private String resolveDynamicEndpointPort(String listenPort, String secureMode, String secureListenPort) {
        return secureMode.equals(SecureMode.DISABLE.getName()) ? listenPort : secureListenPort;
    }

    private String resolveDynamicEndpointPortPropertyName(String secureMode) {
        return secureMode.equals(SecureMode.DISABLE.getName()) ? "nonSecureListenPort" : "secureListenPort";
    }

    @NotNull
    private TestEndpoint startDynamicTestingEndpoint(String id, ValidationResult result, String url, String listenPort, String listenAddress, String secureMode, String secureListenPort, SecureContent secureContent) {
        TestEndpoint testEndpoint;
        URL dynamicEndpointUrl;
        String dynamicEndpointPort = this.resolveDynamicEndpointPort(listenPort, secureMode, secureListenPort);
        this.bundlePropertiesValidator.checkCanListenOn(listenAddress, Integer.parseInt(dynamicEndpointPort), result, this.resolveDynamicEndpointPortPropertyName(secureMode));
        if (result.hasErrors()) {
            throw new ValidationException(result);
        }
        try {
            dynamicEndpointUrl = new URL(UrlUtil.combineUrls((String)url, (String)"/dynamic.ext"));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unexpected exception, should never be thrown. URL " + url + " should has been validated to this moment already");
        }
        if (secureMode.equals(SecureMode.DISABLE.getName())) {
            this.validationEndpointsManager.startServiceEndpoint(listenAddress, dynamicEndpointPort, dynamicEndpointUrl.getPath(), (KeyStoreHolder)null);
            testEndpoint = TestEndpoint.createValidEndpoint(id, TestEndpoint.State.readyToCheck, null, dynamicEndpointUrl.toString(), dynamicEndpointPort, listenAddress, null);
        } else {
            KeyStoreHolder keyStoreHolder;
            try {
                keyStoreHolder = secureContent.buildKeyStore();
            }
            catch (Exception e) {
                return TestEndpoint.createInvalidEndpoint(id, "Failed to build keystore for validation endpoint: " + e.getMessage());
            }
            SSLContext sslContext = this.validationEndpointsManager.startServiceEndpoint(listenAddress, dynamicEndpointPort, dynamicEndpointUrl.getPath(), keyStoreHolder);
            testEndpoint = TestEndpoint.createValidEndpoint(id, TestEndpoint.State.readyToCheck, null, dynamicEndpointUrl.toString(), dynamicEndpointPort, listenAddress, sslContext);
        }
        return testEndpoint;
    }

    private SSLContext buildClientSslContext(SecureContent secureContent) {
        KeyStoreHolder keyStoreHolder;
        if (secureContent == null) {
            return null;
        }
        try {
            keyStoreHolder = secureContent.buildKeyStore();
        }
        catch (Exception e) {
            this.LOG.error("Fail building keystore from TLS settings", (Throwable)e);
            return null;
        }
        return this.validationEndpointsManager.buildClientSslContext(keyStoreHolder);
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    public String status(@RequestHeader HttpHeaders headers) throws ValidationException {
        List hostHeaders = headers.get((Object)"Host");
        String hostHeader = hostHeaders != null && !hostHeaders.isEmpty() ? (String)hostHeaders.get(0) : null;
        this.LOG.debug(String.format("Status request is received %s", hostHeader != null ? "from " + hostHeader : ""));
        return "{\"status\":\"Success\"}";
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public TestEndpoint[] getAllEndpoints() throws ValidationException {
        return endpoints.values().toArray(new TestEndpoint[0]);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public TestEndpoint getEndpoint(HttpServletRequest request, @PathVariable(value="id") String id) throws ValidationException, UnknownResourceException {
        TestEndpoint endpoint = endpoints.get(id);
        if (endpoint == null) {
            throw new UnknownResourceException(request.getRequestURI());
        }
        this.validationEndpointsManager.stopEndpoint(endpoint.getListenAddress(), endpoint.getListenPort());
        return endpoint;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteEndpoint(HttpServletRequest request, @PathVariable(value="id") String id) throws ValidationException, UnknownResourceException {
        TestEndpoint endpoint = endpoints.get(id);
        if (endpoint == null) {
            throw new UnknownResourceException(request.getRequestURI());
        }
        String listenAddress = endpoint.getListenAddress();
        String listenPort = endpoint.getListenPort();
        if (listenAddress != null && listenPort != null) {
            this.validationEndpointsManager.stopEndpoint(listenAddress, listenPort);
        }
        endpoints.remove(id);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLEncoder.encode("http://unit-581.labs.intellij.net/", "UTF-8"));
    }

    @NotNull
    private String buildWizardBasedStateTestingUrl(@NotNull String url) {
        return UrlUtil.combineUrls((String)url, (String)UrlUtil.combineUrls((String)this.calculateWizardOwnContext(), (String)UrlUtil.combineUrls((String)"/api", (String)TEST_CONNECTION_SERVICE_CONTEXT)));
    }

    @NotNull
    private String calculateWizardOwnContext() {
        String bundleBaseUrl = this.bundleDefaults.getBaseUrl();
        String wizardBaseUrl = this.wizardBackendConfig.getWizardBaseUrl();
        if (wizardBaseUrl.startsWith(bundleBaseUrl)) {
            return wizardBaseUrl.substring(bundleBaseUrl.length(), wizardBaseUrl.length());
        }
        return "";
    }
}

