/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.util.WizardHubUtil;
import com.jetbrains.installer.validation.UpgradeSettingsValidator;
import com.jetbrains.installer.validation.ValidationError;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/upgrade-settings"})
public class UpgradeSettingsResource {
    public static final String ID = "upgrade-settings";
    @Autowired
    WizardBackendConfig config;
    @Resource(name="upgradeSettings")
    private UpgradeSettings upgradeSettings;
    @Resource(name="upgradeMode")
    private AtomicBoolean upgradeMode;
    @Autowired
    private UpgradeSettingsValidator settingsValidator;
    @Autowired
    WizardHubUtil wizardHubUtil;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public UpgradeSettings get() {
        if (this.upgradeSettings.getContext() == null) {
            ValidationResult errorResult = new ValidationResult();
            errorResult.addError(ValidationError.VALID_UPGRADE_SOURCE_SHOULD_HAS_BEEN_SELECTED_FIRST.toErrorInfo("sourceLocation"));
            throw new ValidationException(errorResult);
        }
        return this.upgradeSettings;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/candidate"})
    @ResponseBody
    public UpgradeSettings validate(@RequestBody UpgradeSettings data) {
        ValidationResult validationResult = this.validateUpgradeSettings(data);
        if (validationResult.hasErrors() && data.getOldCertErrors() != null && data.getOldCertErrors().hasErrors()) {
            data.getSecureContent().clearSecureEmptyFieldsErrors(validationResult);
        }
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
        return data;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public UpgradeSettings post(@RequestBody UpgradeSettings data) {
        this.upgradeMode.set(true);
        ValidationResult result = this.validateUpgradeSettings(data);
        if (result.hasErrors()) {
            throw new ValidationException(result);
        }
        this.upgradeSettings.copyFrom(data);
        return this.upgradeSettings;
    }

    @NotNull
    private ValidationResult validateUpgradeSettings(@RequestBody UpgradeSettings data) {
        data.setContext(this.upgradeSettings.getContext());
        data.setUpgradeSource(this.upgradeSettings.getUpgradeSource());
        data.setUpgradeSettingsValidator(this.upgradeSettings.getUpgradeSettingsValidator());
        return this.settingsValidator.validate(data);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public synchronized void checkFolder(@RequestParam(value="path") String path, @RequestParam(value="property") String property) throws ValidationException {
        ValidationResult validationResult = new ValidationResult();
        this.settingsValidator.validateDirectory(validationResult, path, property);
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
    }
}

